/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.xmleditor.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementSchemaMapping {
    private String rootElement;
    private String filePath;

    public ElementSchemaMapping(String rootElement, String filePath) {
        this.setRootElement(rootElement);
        this.setFilePath(filePath);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(String rootElement) {
        this.rootElement = rootElement;
    }

    public static void saveToPreference(List<ElementSchemaMapping> list) {
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            ElementSchemaMapping mapping = list.get(i);
            sb.append(mapping.getRootElement());
            sb.append("\t");
            sb.append(mapping.getFilePath());
            sb.append("\n");
        }
        store.setValue("__pref_schema_mappings", sb.toString());
    }

    public static List<ElementSchemaMapping> loadFromPreference() {
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        ArrayList<ElementSchemaMapping> list = new ArrayList<ElementSchemaMapping>();
        String customMappings = store.getString("__pref_schema_mappings");
        String[] dim = customMappings.split("\n");
        for (int i = 0; i < dim.length; ++i) {
            if (dim[i].length() <= 0) continue;
            String[] elemAndPath = dim[i].split("\t");
            ElementSchemaMapping mapping = new ElementSchemaMapping(elemAndPath[0], elemAndPath[1]);
            list.add(mapping);
        }
        return list;
    }
}

