/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.locate.cache;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.objectstyle.wolips.locate.LocatePlugin;
import org.objectstyle.wolips.locate.cache.PreCloseVisitor;
import org.objectstyle.wolips.locate.cache.PreDeleteVisitor;
import org.objectstyle.wolips.locate.result.LocalizedComponentsLocateResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentLocateCache
implements IResourceChangeListener {
    private Map<String, Map<String, LocalizedComponentsLocateResult>> projects = new HashMap<String, Map<String, LocalizedComponentsLocateResult>>();

    public void forgetCacheForProject(IProject project) {
        String projectKey = project.getName();
        this.projects.remove(projectKey);
    }

    public void forgetCacheForFile(IResource resource) {
        Map<String, LocalizedComponentsLocateResult> projectHashMap = this.project(resource.getProject());
        if (projectHashMap == null) {
            return;
        }
        String key = LocatePlugin.getDefault().fileNameWithoutExtension(resource);
        projectHashMap.remove(key);
    }

    public LocalizedComponentsLocateResult getLocalizedComponentsLocateResult(IResource resource) {
        Map<String, LocalizedComponentsLocateResult> projectHashMap = this.project(resource.getProject());
        if (projectHashMap == null) {
            return null;
        }
        String key = LocatePlugin.getDefault().fileNameWithoutExtension(resource);
        LocalizedComponentsLocateResult localizedComponentsLocateResult = projectHashMap.get(key);
        return localizedComponentsLocateResult;
    }

    public LocalizedComponentsLocateResult getLocalizedComponentsLocateResult(IProject project, String filenameWithoutExtension) {
        Map<String, LocalizedComponentsLocateResult> projectHashMap = this.project(project);
        if (projectHashMap == null) {
            return null;
        }
        String key = LocatePlugin.getDefault().fileNameWithoutExtension(filenameWithoutExtension);
        LocalizedComponentsLocateResult localizedComponentsLocateResult = projectHashMap.get(key);
        return localizedComponentsLocateResult;
    }

    public void addToCache(IResource resource, LocalizedComponentsLocateResult localizedComponentsLocateResult) {
        this.addToCache(resource.getProject(), LocatePlugin.getDefault().fileNameWithoutExtension(resource), localizedComponentsLocateResult);
    }

    public void addToCache(IProject project, String filenameWithoutExtension, LocalizedComponentsLocateResult localizedComponentsLocateResult) {
        Map<String, LocalizedComponentsLocateResult> projectHashMap = this.project(project);
        if (projectHashMap == null) {
            projectHashMap = new HashMap<String, LocalizedComponentsLocateResult>();
            String projectsKey = project.getName();
            this.projects.put(projectsKey, projectHashMap);
        }
        projectHashMap.put(filenameWithoutExtension, localizedComponentsLocateResult);
    }

    private Map<String, LocalizedComponentsLocateResult> project(IProject project) {
        Map<String, LocalizedComponentsLocateResult> projectHashMap = this.projects.get(project.getName());
        return projectHashMap;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getDelta() != null && event.getType() == 2) {
            try {
                event.getDelta().accept((IResourceDeltaVisitor)new PreCloseVisitor(this));
            }
            catch (CoreException e) {
                LocatePlugin.getDefault().log(e);
                this.projects = new HashMap<String, Map<String, LocalizedComponentsLocateResult>>();
            }
        }
        if (event.getDelta() != null && event.getType() == 1) {
            try {
                event.getDelta().accept((IResourceDeltaVisitor)new PreDeleteVisitor(this));
            }
            catch (CoreException e) {
                LocatePlugin.getDefault().log(e);
                this.projects = new HashMap<String, Map<String, LocalizedComponentsLocateResult>>();
            }
        }
    }
}

