/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.locate.result;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.objectstyle.wolips.locate.LocateException;
import org.objectstyle.wolips.locate.LocatePlugin;
import org.objectstyle.wolips.locate.result.AbstractLocateResult;

public class LocalizedComponentsLocateResult
extends AbstractLocateResult {
    private List<IFolder> components = new ArrayList<IFolder>();
    private IFile dotJava;
    private IFile dotGroovy;
    private IFile dotApi;
    private String[] superclasses = new String[]{"com.webobjects.appserver.WOElement"};

    public String getName() {
        String name = null;
        IFile javaFile = this.getDotJava();
        if (javaFile != null) {
            name = LocatePlugin.getDefault().fileNameWithoutExtension((IResource)javaFile);
        } else {
            IFile apiFile;
            IFolder[] iFolderArray;
            int n;
            int n2;
            IFolder[] componentFolders = this.getComponents();
            if (componentFolders != null && (n2 = 0) < (n = (iFolderArray = componentFolders).length)) {
                IFolder componentFolder = iFolderArray[n2];
                name = LocatePlugin.getDefault().fileNameWithoutExtension((IResource)componentFolder);
            }
            if (name == null && (apiFile = this.getDotApi()) != null) {
                name = LocatePlugin.getDefault().fileNameWithoutExtension((IResource)javaFile);
            }
        }
        if (name == null) {
            name = "Unknown Component";
        }
        return name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(IResource resource) throws LocateException {
        super.add(resource);
        if (resource.getType() == 2) {
            this.components.add((IFolder)resource);
            return;
        }
        if (resource.getType() != 1) {
            String message = "unsupported type " + resource;
            this.alert(message);
            throw new LocateException(message);
        }
        IFile file = (IFile)resource;
        String extension = resource.getFileExtension();
        if (extension.equals("java")) {
            block19: {
                IJavaProject javaProject;
                IJavaElement javaElement;
                block18: {
                    if (this.dotJava != null) {
                        javaElement = JavaCore.create((IFile)file);
                        try {
                            javaProject = javaElement.getJavaProject();
                            if (javaProject != null && javaProject.isOnClasspath(javaElement)) {
                                if (!this.isValidSubclass(javaElement)) {
                                    file = null;
                                }
                                break block18;
                            }
                            file = null;
                        }
                        catch (JavaModelException e) {
                            file = null;
                            LocatePlugin.getDefault().log(e);
                        }
                    }
                }
                if (file != null && this.dotJava != null) {
                    javaElement = JavaCore.create((IFile)this.dotJava);
                    try {
                        javaProject = javaElement.getJavaProject();
                        if (javaProject != null && javaProject.isOnClasspath(javaElement)) {
                            if (!this.isValidSubclass(javaElement)) {
                                this.dotJava = null;
                            }
                            break block19;
                        }
                        this.dotJava = null;
                    }
                    catch (JavaModelException e) {
                        this.dotJava = null;
                        LocatePlugin.getDefault().log(e);
                    }
                }
            }
            if (file != null && this.dotJava != null) {
                String message = "Duplicate located: " + this.dotJava + " " + file;
                this.alert(message);
                throw new LocateException(message);
            }
            if (file == null) return;
            this.dotJava = file;
            return;
        }
        if (extension.equals("groovy")) {
            if (this.dotGroovy != null) {
                String message = "Duplicate located: " + this.dotGroovy + " " + file;
                this.alert(message);
                throw new LocateException(message);
            }
            this.dotGroovy = file;
            return;
        }
        if (!extension.equals("api")) {
            String message = "unknown extension on " + file;
            this.alert(message);
            throw new LocateException(message);
        }
        if (this.dotApi != null) {
            String message = "Duplicate located: " + this.dotApi + " " + file;
            this.alert(message);
            return;
        }
        this.dotApi = file;
    }

    private void alert(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError(null, (String)"", (String)message);
            }
        });
    }

    public IFolder[] getComponents() {
        return this.components.toArray(new IFolder[this.components.size()]);
    }

    public IFile getDotApi() {
        return this.dotApi;
    }

    public IFile getDotApi(boolean guessIfMissing) throws CoreException {
        IFile apiFile = this.dotApi;
        if (apiFile == null && guessIfMissing) {
            IFile firstHtmlFile = this.getFirstHtmlFile();
            IContainer apiFolder = null;
            if (firstHtmlFile != null) {
                apiFolder = firstHtmlFile.getParent().getParent();
            }
            if (apiFolder != null) {
                apiFile = apiFolder.getFile((IPath)new Path(LocatePlugin.getDefault().fileNameWithoutExtension((IResource)firstHtmlFile) + ".api"));
            }
        }
        return apiFile;
    }

    public IFile getDotJava() {
        return this.dotJava;
    }

    public IType getDotJavaType() {
        IType dotJavaType = null;
        IFile javaFile = this.getDotJava();
        if (javaFile != null) {
            try {
                IType[] types;
                IJavaElement javaElement = JavaCore.create((IFile)javaFile);
                if (javaElement instanceof ICompilationUnit && (types = ((ICompilationUnit)javaElement).getTypes()).length > 0) {
                    dotJavaType = types[0];
                }
            }
            catch (JavaModelException e) {
                LocatePlugin.getDefault().log(new RuntimeException(javaFile.getLocation() + " had a problem.", e));
            }
        }
        return dotJavaType;
    }

    public IFile getDotGroovy() {
        return this.dotGroovy;
    }

    public IFile getFirstHtmlFile() throws CoreException {
        IFile htmlFile;
        if (this.components.size() > 0) {
            IFolder componentFolder = this.components.get(0);
            htmlFile = LocalizedComponentsLocateResult.getHtml(componentFolder);
        } else {
            htmlFile = null;
        }
        return htmlFile;
    }

    public IFile getFirstWodFile() throws CoreException {
        IFile wodFile;
        if (this.components.size() > 0) {
            IFolder componentFolder = this.components.get(0);
            wodFile = LocalizedComponentsLocateResult.getWod(componentFolder);
        } else {
            wodFile = null;
        }
        return wodFile;
    }

    public IFile getFirstWooFile() throws CoreException {
        IFile wooFile;
        if (this.components.size() > 0) {
            IFolder componentFolder = this.components.get(0);
            wooFile = LocalizedComponentsLocateResult.getWoo(componentFolder);
        } else {
            wooFile = null;
        }
        return wooFile;
    }

    public boolean isValid() {
        boolean valid = true;
        for (IFolder component : this.components) {
            if (component.exists()) continue;
            valid = false;
        }
        if (this.dotApi == null) {
            try {
                IFile guessDotApi = this.getDotApi(true);
                if (guessDotApi != null && guessDotApi.exists()) {
                    valid = false;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (!this.dotApi.exists()) {
            valid = false;
        }
        if (this.dotJava != null && !this.dotJava.exists()) {
            valid = false;
        }
        return valid;
    }

    public static IFile getHtml(IFolder component) throws CoreException {
        return LocalizedComponentsLocateResult.getMemberWithExtension(component, "html", true);
    }

    public static IFile getWod(IFolder component) throws CoreException {
        return LocalizedComponentsLocateResult.getMemberWithExtension(component, "wod", true);
    }

    public static IFile getWoo(IFolder component) throws CoreException {
        return LocalizedComponentsLocateResult.getMemberWithExtension(component, "woo", false);
    }

    private static IFile getMemberWithExtension(IFolder folder, String extension, boolean mustExist) throws CoreException {
        IResource[] member = folder.members();
        for (int i = 0; i < member.length; ++i) {
            IResource resource = member[i];
            String fileExtension = resource.getFileExtension();
            if (resource.getType() != 1 || fileExtension == null || !fileExtension.equalsIgnoreCase(extension)) continue;
            return (IFile)resource;
        }
        if (!mustExist) {
            return folder.getFile(LocatePlugin.getDefault().fileNameWithoutExtension(folder.getName()) + "." + extension);
        }
        return null;
    }

    private boolean isValidSubclass(IJavaElement javaElement) throws JavaModelException {
        if (this.superclasses == null || this.superclasses.length == 0) {
            return true;
        }
        ICompilationUnit compilationUnit = (ICompilationUnit)javaElement;
        IType typeToCeck = compilationUnit.findPrimaryType();
        ITypeHierarchy typeHierarchy = typeToCeck.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        IType[] types = typeHierarchy.getAllClasses();
        for (int i = 0; i < types.length; ++i) {
            IType type = types[i];
            for (int j = 0; j < this.superclasses.length; ++j) {
                String superclass = this.superclasses[j];
                if (!type.getFullyQualifiedName().equals(superclass)) continue;
                return true;
            }
        }
        return false;
    }
}

