/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt.decorator;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.graphics.Image;

public class ActionMethodDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    public String decorateText(String text, Object element) {
        return text;
    }

    private boolean isAction(Object element) {
        if (!(element instanceof IMethod)) {
            return false;
        }
        try {
            IMethod method = (IMethod)element;
            if (!method.getJavaProject().isOnClasspath((IJavaElement)method)) {
                return false;
            }
            if (method.isConstructor()) {
                return false;
            }
            if (method.isMainMethod()) {
                return false;
            }
            int flags = method.getFlags();
            if (Flags.isPrivate((int)flags) || Flags.isStatic((int)flags)) {
                return false;
            }
            if (method.getNumberOfParameters() > 0) {
                return false;
            }
            String returnType = method.getReturnType();
            if (returnType == null || returnType.length() == 0) {
                return false;
            }
            if (returnType.equals("QWOComponent;")) {
                return true;
            }
            if (returnType.equals("QWOActionResults;")) {
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    public Image decorateImage(Image image, Object element) {
        return image;
    }

    public void decorate(Object element, IDecoration decoration) {
        if (this.isAction(element)) {
            decoration.addOverlay(ImageDescriptor.createFromFile(ActionMethodDecorator.class, (String)"action_overlay.gif"));
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }
}

