/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt.ui.tags.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.objectstyle.wolips.jdt.ui.tags.Tag;
import org.objectstyle.wolips.jdt.ui.tags.TagLib;
import org.objectstyle.wolips.workbenchutilities.actions.AbstractActionOnIResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagResourcesAction
extends AbstractActionOnIResources {
    public void run(IAction action) {
        HashMap<IProject, ArrayList<IResource>> projectFilesMap = new HashMap<IProject, ArrayList<IResource>>();
        IResource[] resources = this.getActionResources();
        for (int i = 0; i < resources.length; ++i) {
            IResource resource = resources[i];
            ArrayList<IResource> resourcesList = (ArrayList<IResource>)projectFilesMap.get(resource.getProject());
            if (resourcesList == null) {
                resourcesList = new ArrayList<IResource>();
                projectFilesMap.put(resource.getProject(), resourcesList);
            }
            resourcesList.add(resource);
        }
        for (IProject project : projectFilesMap.keySet()) {
            TagLib tagLib = new TagLib(project);
            TagDialog tagDialog = new TagDialog(this.part.getSite().getShell(), tagLib);
            int status = tagDialog.open();
            if (status != 0) {
                return;
            }
            String tagName = tagDialog.tag;
            if (tagName == null || tagName.length() == 0) {
                return;
            }
            List resourcesList = (List)projectFilesMap.get(project);
            String[] componentNames = this.find((IProgressMonitor)new NullProgressMonitor(), resourcesList);
            tagLib.tagComponents(componentNames, tagName);
        }
    }

    protected String[] find(IProgressMonitor monitor, List<IResource> resourcesList) {
        ArrayList<String> components = new ArrayList<String>();
        try {
            for (IResource resource : resourcesList) {
                this.find(resource, components, monitor);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return components.toArray(new String[components.size()]);
    }

    private void find(IResource resource, ArrayList<String> components, IProgressMonitor monitor) throws CoreException {
        if (resource.getType() == 1) {
            return;
        }
        IResource[] members = null;
        if (resource.getType() == 2) {
            if (resource.getFileExtension() != null && "wo".equals(resource.getFileExtension())) {
                components.add(resource.getName().substring(0, resource.getName().indexOf(46)));
                return;
            }
            members = ((IFolder)resource).members();
        }
        if (resource.getType() == 4) {
            members = ((IProject)resource).members();
        }
        if (members != null) {
            for (int i = 0; i < members.length; ++i) {
                this.find(members[i], components, monitor);
            }
        }
    }

    private class TagDialog
    extends Dialog {
        Text textTag;
        Combo comboTags;
        private TagLib tagLib;
        String tag;

        public TagDialog(Shell parentShell, TagLib tagLib) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.tagLib = tagLib;
        }

        protected Point getInitialSize() {
            Point size = super.getInitialSize();
            size.x = 300;
            return size;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText("Add Tag");
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(composite, 0);
            label.setText("Existing Tags");
            this.comboTags = new Combo(composite, 8);
            this.comboTags.setLayoutData((Object)new GridData(768));
            Tag[] tags = this.tagLib.getTags();
            for (int i = 0; i < tags.length; ++i) {
                this.comboTags.add(tags[i].name);
            }
            label = new Label(composite, 0);
            label.setText("Tag");
            this.textTag = new Text(composite, 2048);
            this.textTag.setLayoutData((Object)new GridData(768));
            this.comboTags.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    int selected = TagDialog.this.comboTags.getSelectionIndex();
                    if (selected >= 0) {
                        TagDialog.this.textTag.setText(TagDialog.this.comboTags.getItem(selected));
                    }
                }
            });
            return composite;
        }

        protected void okPressed() {
            this.tag = this.textTag.getText();
            super.okPressed();
        }
    }
}

