/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.wod;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectstyle.wolips.bindings.wod.HtmlElementName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlElementCache {
    private Map<String, List<HtmlElementName>> _htmlElementCache = new HashMap<String, List<HtmlElementName>>();
    private Set<String> _vars = new HashSet<String>();

    public void addHtmlElement(HtmlElementName htmlElement) {
        List<HtmlElementName> htmlElementNames = this._htmlElementCache.get(htmlElement.getName());
        if (htmlElementNames == null) {
            htmlElementNames = new LinkedList<HtmlElementName>();
            this._htmlElementCache.put(htmlElement.getName(), htmlElementNames);
        }
        htmlElementNames.add(htmlElement);
    }

    public boolean containsElementNamed(String name) {
        List<HtmlElementName> htmlElementNames = this._htmlElementCache.get(name);
        return htmlElementNames != null && htmlElementNames.size() > 0;
    }

    public List<HtmlElementName> getHtmlElementNames(String name) {
        return this._htmlElementCache.get(name);
    }

    public Set<String> elementNames() {
        return this._htmlElementCache.keySet();
    }

    public Set<String> getVars() {
        return this._vars;
    }

    public void clearCache() {
        this._htmlElementCache.clear();
        this._vars.clear();
    }
}

