/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.databaseConfig;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.objectstyle.wolips.eomodeler.Messages;
import org.objectstyle.wolips.eomodeler.core.model.EODatabaseConfig;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.editors.databaseConfig.AdaptorNameContentProvider;
import org.objectstyle.wolips.eomodeler.editors.databaseConfig.BlankConnectionDictionarySection;
import org.objectstyle.wolips.eomodeler.editors.databaseConfig.IConnectionDictionarySection;
import org.objectstyle.wolips.eomodeler.editors.databaseConfig.JDBCConnectionDictionarySection;
import org.objectstyle.wolips.eomodeler.editors.databaseConfig.JNDIConnectionDictionarySection;
import org.objectstyle.wolips.eomodeler.editors.databaseConfig.RESTConnectionDictionarySection;
import org.objectstyle.wolips.eomodeler.editors.entity.EOEntityLabelProvider;
import org.objectstyle.wolips.eomodeler.editors.entity.EOPrototypeEntityListContentProvider;
import org.objectstyle.wolips.eomodeler.utils.ComboViewerBinding;
import org.objectstyle.wolips.eomodeler.utils.FormUtils;
import org.objectstyle.wolips.eomodeler.utils.StringLabelProvider;
import org.objectstyle.wolips.eomodeler.utils.UglyFocusHackWorkaroundListener;

public class DatabaseConfigSection
extends AbstractPropertySection {
    private DataBindingContext _bindingContext;
    private Text _nameText;
    private Text _priorityText;
    private Text _deploymentProfileText;
    private ComboViewer _prototypeComboViewer;
    private ComboViewerBinding _prototypeBinding;
    private ComboViewer _adaptorNameComboViewer;
    private ComboViewerBinding _adaptorNameBinding;
    private Button _makeActiveButton;
    private ActiveDatabaseConfigHandler _activeDatabaseConfigHandler = new ActiveDatabaseConfigHandler();
    private AdaptorNameHandler _adaptorNameHandler = new AdaptorNameHandler();
    private EODatabaseConfig _databaseConfig;
    private Composite _connectionDictionaryContainer;
    private IConnectionDictionarySection _connectionDictionarySection;
    private String _lastAdaptorName;
    private Composite _form;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this._form = this.getWidgetFactory().createFlatFormComposite(parent);
        FormLayout formLayout = new FormLayout();
        this._form.setLayout((Layout)formLayout);
        Composite topForm = FormUtils.createForm(this.getWidgetFactory(), this._form);
        this.getWidgetFactory().createCLabel(topForm, Messages.getString("EODatabaseConfig.name"), 0);
        this._nameText = new Text(topForm, 2048);
        this._nameText.setLayoutData((Object)new GridData(768));
        UglyFocusHackWorkaroundListener.addListener(this._nameText);
        this.getWidgetFactory().createCLabel(topForm, Messages.getString("EODatabaseConfig.deploymentProfile"), 0);
        this._deploymentProfileText = new Text(topForm, 2048);
        this._deploymentProfileText.setLayoutData((Object)new GridData(768));
        UglyFocusHackWorkaroundListener.addListener(this._deploymentProfileText);
        this.getWidgetFactory().createCLabel(topForm, Messages.getString("EODatabaseConfig.priority"), 0);
        this._priorityText = new Text(topForm, 2048);
        this._priorityText.setLayoutData((Object)new GridData(768));
        UglyFocusHackWorkaroundListener.addListener(this._priorityText);
        this.getWidgetFactory().createCLabel(topForm, Messages.getString("EODatabaseConfig.prototype"), 0);
        this._prototypeComboViewer = new ComboViewer(topForm, 8);
        this._prototypeComboViewer.setContentProvider((IContentProvider)new EOPrototypeEntityListContentProvider(true));
        this._prototypeComboViewer.setLabelProvider((IBaseLabelProvider)new EOEntityLabelProvider());
        this._prototypeComboViewer.getCombo().setLayoutData((Object)new GridData(768));
        this.getWidgetFactory().createCLabel(topForm, Messages.getString("EODatabaseConfig.adaptorName"), 0);
        this._adaptorNameComboViewer = new ComboViewer(topForm, 8);
        this._adaptorNameComboViewer.setContentProvider((IContentProvider)new AdaptorNameContentProvider());
        this._adaptorNameComboViewer.setLabelProvider((IBaseLabelProvider)new StringLabelProvider());
        this._adaptorNameComboViewer.getCombo().setLayoutData((Object)new GridData(768));
        this._connectionDictionaryContainer = new Composite(topForm, 0);
        this._connectionDictionaryContainer.setBackground(topForm.getBackground());
        GridLayout connectionDictionaryLayout = new GridLayout();
        connectionDictionaryLayout.marginLeft = 0;
        connectionDictionaryLayout.marginWidth = 0;
        connectionDictionaryLayout.marginRight = 0;
        connectionDictionaryLayout.marginHeight = 0;
        connectionDictionaryLayout.marginTop = 0;
        connectionDictionaryLayout.marginBottom = 0;
        this._connectionDictionaryContainer.setLayout((Layout)connectionDictionaryLayout);
        GridData connectionDictionaryData = new GridData(768);
        connectionDictionaryData.horizontalSpan = 2;
        connectionDictionaryData.grabExcessHorizontalSpace = true;
        this._connectionDictionaryContainer.setLayoutData((Object)connectionDictionaryData);
        this._makeActiveButton = this.getWidgetFactory().createButton(topForm, Messages.getString("EODatabaseConfig.makeActiveLabel"), 8);
        GridData makeActiveData = new GridData();
        makeActiveData.horizontalSpan = 2;
        this._makeActiveButton.setLayoutData((Object)makeActiveData);
        this._makeActiveButton.addSelectionListener((SelectionListener)new MakeActiveHandler());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        this.disposeBindings();
        super.setInput(part, selection);
        Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
        this._databaseConfig = (EODatabaseConfig)selectedObject;
        if (this._databaseConfig != null) {
            this._bindingContext = new DataBindingContext();
            this.addBindings();
        }
        this.adaptorNameChanged();
    }

    protected void adaptorNameChanged() {
        if (this._databaseConfig != null) {
            String adaptorName = this._databaseConfig.getAdaptorName();
            if (adaptorName == null || !adaptorName.equals(this._lastAdaptorName)) {
                if (this._connectionDictionarySection != null) {
                    this._connectionDictionarySection.dispose();
                    this._connectionDictionarySection = null;
                }
                Composite connectionDictionarySection = "JDBC".equals(adaptorName) ? new JDBCConnectionDictionarySection(this._connectionDictionaryContainer, 0, this.getWidgetFactory()) : ("JNDI".equals(adaptorName) ? new JNDIConnectionDictionarySection(this._connectionDictionaryContainer, 0, this.getWidgetFactory()) : ("REST".equals(adaptorName) ? new RESTConnectionDictionarySection(this._connectionDictionaryContainer, 0, this.getWidgetFactory()) : new BlankConnectionDictionarySection(this._connectionDictionaryContainer, 0)));
                GridData connectionDictionaryData = new GridData(768);
                connectionDictionaryData.grabExcessHorizontalSpace = true;
                ((Composite)connectionDictionarySection).setLayoutData((Object)connectionDictionaryData);
                this._connectionDictionarySection = connectionDictionarySection;
            }
            this._lastAdaptorName = adaptorName;
            if (this._connectionDictionarySection != null) {
                this._connectionDictionarySection.setInput(this._databaseConfig);
            }
        } else {
            if (this._connectionDictionarySection != null) {
                this._connectionDictionarySection.dispose();
                this._connectionDictionarySection = null;
            }
            this._lastAdaptorName = null;
        }
        this._form.layout();
    }

    public EODatabaseConfig getDatabaseConfig() {
        return this._databaseConfig;
    }

    public void dispose() {
        this.disposeBindings();
        if (this._connectionDictionarySection != null) {
            this._connectionDictionarySection.dispose();
        }
        super.dispose();
    }

    protected void disposeBindings() {
        EODatabaseConfig databaseConfig;
        if (this._bindingContext != null) {
            this._bindingContext.dispose();
        }
        if (this._prototypeBinding != null) {
            this._prototypeBinding.dispose();
        }
        if (this._adaptorNameBinding != null) {
            this._adaptorNameBinding.dispose();
        }
        if ((databaseConfig = this.getDatabaseConfig()) != null) {
            EOModel model = databaseConfig.getModel();
            if (model != null) {
                model.removePropertyChangeListener("activeDatabaseConfig", this._activeDatabaseConfigHandler);
            }
            databaseConfig.removePropertyChangeListener("adaptorName", this._adaptorNameHandler);
        }
    }

    protected void addBindings() {
        this._bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int)24), BeansObservables.observeValue((Object)this.getDatabaseConfig(), (String)"name"), null, null);
        this._bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this._priorityText, (int)24), BeansObservables.observeValue((Object)this.getDatabaseConfig(), (String)"priority"), null, null);
        this._bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this._deploymentProfileText, (int)24), BeansObservables.observeValue((Object)this.getDatabaseConfig(), (String)"deploymentProfile"), null, null);
        this._prototypeComboViewer.setInput((Object)this.getDatabaseConfig());
        this._prototypeBinding = new ComboViewerBinding(this._prototypeComboViewer, this.getDatabaseConfig(), "prototype", null, null, EOPrototypeEntityListContentProvider.BLANK_ENTITY);
        this._adaptorNameComboViewer.setInput((Object)this.getDatabaseConfig());
        this._adaptorNameBinding = new ComboViewerBinding(this._adaptorNameComboViewer, this.getDatabaseConfig(), "adaptorName", null, null, null);
        EODatabaseConfig databaseConfig = this.getDatabaseConfig();
        if (databaseConfig != null) {
            EOModel model = databaseConfig.getModel();
            if (model != null) {
                model.addPropertyChangeListener("activeDatabaseConfig", this._activeDatabaseConfigHandler);
            }
            databaseConfig.addPropertyChangeListener("adaptorName", this._adaptorNameHandler);
        }
        this.activeDatabaseConfigChanged();
    }

    protected void makeActive() {
        EODatabaseConfig databaseConfig = this.getDatabaseConfig();
        if (databaseConfig != null) {
            databaseConfig.setActive();
        }
    }

    protected void activeDatabaseConfigChanged() {
        EODatabaseConfig databaseConfig = this.getDatabaseConfig();
        if (databaseConfig != null) {
            this._makeActiveButton.setEnabled(!databaseConfig.isActive());
        }
    }

    protected class MakeActiveHandler
    implements SelectionListener {
        protected MakeActiveHandler() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            DatabaseConfigSection.this.makeActive();
        }
    }

    protected class AdaptorNameHandler
    implements PropertyChangeListener {
        protected AdaptorNameHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            DatabaseConfigSection.this.adaptorNameChanged();
        }
    }

    protected class ActiveDatabaseConfigHandler
    implements PropertyChangeListener {
        protected ActiveDatabaseConfigHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            DatabaseConfigSection.this.activeDatabaseConfigChanged();
        }
    }
}

