/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.openEntity;

import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.objectstyle.wolips.eomodeler.Activator;

public class OpenEntityDialog
extends FilteredResourcesSelectionDialog {
    private Button openWithButton;

    public OpenEntityDialog(Shell parentShell, IContainer container, boolean showSelectionHistory) {
        super(parentShell, true, container, 3);
        this.setTitle("Open Model");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parentShell, "org.eclipse.ui.ide.open_resource_dialog");
        this.setListLabelProvider((ILabelProvider)new EntityLabelProvider());
        this.setDetailsLabelProvider((ILabelProvider)new EntityDetailsLabelProvider());
        if (!showSelectionHistory) {
            this.setSelectionHistory(null);
        }
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new EntityFilter((IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, 3);
    }

    protected void fillContextMenu(IMenuManager menuManager) {
        super.fillContextMenu(menuManager);
        StructuredSelection selectedItems = this.getSelectedItems();
        if (selectedItems.isEmpty()) {
            return;
        }
        IWorkbenchPage activePage = this.getActivePage();
        if (activePage == null) {
            return;
        }
        OpenFileAction openFileAction = new OpenFileAction(activePage){

            public void run() {
                OpenEntityDialog.this.okPressed();
            }
        };
        openFileAction.selectionChanged((IStructuredSelection)selectedItems);
        if (!openFileAction.isEnabled()) {
            return;
        }
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)openFileAction);
        IAdaptable selectedAdaptable = this.getSelectedAdaptable();
        if (selectedAdaptable == null) {
            return;
        }
        MenuManager subMenu = new MenuManager(IDEWorkbenchMessages.OpenResourceDialog_openWithMenu_label);
        OpenWithMenu openWithMenu = new OpenWithMenu(activePage, selectedAdaptable){

            protected void openEditor(IEditorDescriptor editorDescriptor, boolean openUsingDescriptor) {
                OpenEntityDialog.this.computeResult();
                OpenEntityDialog.this.setResult(Collections.EMPTY_LIST);
                OpenEntityDialog.this.close();
                super.openEditor(editorDescriptor, openUsingDescriptor);
            }
        };
        subMenu.add((IContributionItem)openWithMenu);
        menuManager.add((IContributionItem)subMenu);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        int buttonWidth;
        GridLayout parentLayout = (GridLayout)parent.getLayout();
        ++parentLayout.numColumns;
        parentLayout.makeColumnsEqualWidth = false;
        final Composite openComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        openComposite.setLayout((Layout)layout);
        Button okButton = this.createButton(openComposite, 0, IDEWorkbenchMessages.OpenResourceDialog_openButton_text, true);
        ++((GridLayout)openComposite.getLayout()).numColumns;
        this.openWithButton = new Button(openComposite, 8);
        this.openWithButton.setToolTipText(IDEWorkbenchMessages.OpenResourceDialog_openWithButton_text);
        this.openWithButton.setImage(WorkbenchImages.getImage((String)"IMG_LCL_BUTTON_MENU"));
        GridData data = new GridData(0x1000000, 4, false, true);
        this.openWithButton.setLayoutData((Object)data);
        this.openWithButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                OpenEntityDialog.this.showOpenWithMenu(openComposite);
            }
        });
        this.openWithButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenEntityDialog.this.showOpenWithMenu(openComposite);
            }
        });
        Button cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        GridData cancelLayoutData = (GridData)cancelButton.getLayoutData();
        GridData okLayoutData = (GridData)okButton.getLayoutData();
        cancelLayoutData.widthHint = buttonWidth = Math.max(cancelLayoutData.widthHint, okLayoutData.widthHint);
        okLayoutData.widthHint = buttonWidth;
        if (openComposite.getDisplay().getDismissalAlignment() == 131072) {
            openComposite.moveBelow(null);
            if (Util.isCarbon()) {
                okLayoutData.horizontalIndent = -10;
            }
        }
    }

    protected void initializeBounds() {
        super.initializeBounds();
        if (this.openWithButton.getDisplay().getDismissalAlignment() == 131072 && !Util.isMac()) {
            this.openWithButton.moveBelow(null);
            this.openWithButton.getParent().layout();
        }
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        if (this.openWithButton != null && !this.openWithButton.isDisposed()) {
            this.openWithButton.setEnabled(!status.matches(4) && this.getSelectedItems().size() == 1);
        }
    }

    private IAdaptable getSelectedAdaptable() {
        StructuredSelection s = this.getSelectedItems();
        if (s.size() != 1) {
            return null;
        }
        Object selectedElement = s.getFirstElement();
        if (selectedElement instanceof IAdaptable) {
            return (IAdaptable)selectedElement;
        }
        return null;
    }

    private IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    private void showOpenWithMenu(Composite openComposite) {
        IWorkbenchPage activePage = this.getActivePage();
        if (activePage == null) {
            return;
        }
        IAdaptable selectedAdaptable = this.getSelectedAdaptable();
        if (selectedAdaptable == null) {
            return;
        }
        OpenWithMenu openWithMenu = new OpenWithMenu(activePage, selectedAdaptable){

            protected void openEditor(IEditorDescriptor editorDescriptor, boolean openUsingDescriptor) {
                OpenEntityDialog.this.computeResult();
                OpenEntityDialog.this.setResult(Collections.EMPTY_LIST);
                OpenEntityDialog.this.close();
                super.openEditor(editorDescriptor, openUsingDescriptor);
            }
        };
        Menu menu = new Menu((Control)openComposite.getParent());
        Composite c = openComposite;
        Point p = c.getLocation();
        p.y += c.getSize().y;
        p = c.getParent().toDisplay(p);
        menu.setLocation(p);
        openWithMenu.fill(menu, -1);
        menu.setVisible(true);
    }

    protected class EntityDetailsLabelProvider
    extends EntityLabelProvider {
        protected EntityDetailsLabelProvider() {
        }

        public Image getImage(Object element) {
            if (!(element instanceof IResource)) {
                return super.getImage(element);
            }
            IContainer parent = ((IResource)element).getParent();
            return super.getImage(parent);
        }

        public String getText(Object element) {
            if (!(element instanceof IResource)) {
                return super.getText(element);
            }
            IContainer parent = ((IResource)element).getParent();
            if (parent.getType() == 8) {
                return null;
            }
            return this.removeExtension(parent.getFullPath().makeRelative().toString());
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] l = ((EntityLabelProvider)this).listeners.getListeners();
            for (int i = 0; i < ((EntityLabelProvider)this).listeners.size(); ++i) {
                ((ILabelProviderListener)l[i]).labelProviderChanged(event);
            }
        }
    }

    protected class EntityLabelProvider
    extends LabelProvider
    implements ILabelProviderListener,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private ListenerList listeners = new ListenerList();
        private WorkbenchLabelProvider _provider = new WorkbenchLabelProvider();

        public EntityLabelProvider() {
            this._provider.addListener((ILabelProviderListener)this);
        }

        protected String removeExtension(String str) {
            String finalStr = str;
            int dotIndex = finalStr.lastIndexOf(46);
            if (dotIndex != -1) {
                finalStr = finalStr.substring(0, dotIndex);
            }
            return finalStr;
        }

        public Image getImage(Object element) {
            if (!(element instanceof IResource)) {
                return super.getImage(element);
            }
            IResource res = (IResource)element;
            String extension = res.getFileExtension();
            Image image = "eomodeld".equals(extension) ? Activator.getDefault().getImageRegistry().get("eoModel") : ("plist".equals(extension) ? Activator.getDefault().getImageRegistry().get("eoEntity") : ("fspec".equals(extension) ? Activator.getDefault().getImageRegistry().get("eoFetchSpec") : ("storedProcedure".equals(extension) ? Activator.getDefault().getImageRegistry().get("eoStoredProcedure") : this._provider.getImage(element))));
            return image;
        }

        public String getText(Object element) {
            if (!(element instanceof IResource)) {
                return super.getText(element);
            }
            IResource res = (IResource)element;
            String str = res.getName();
            str = this.removeExtension(str);
            if (OpenEntityDialog.this.isDuplicateElement(element)) {
                str = str + " - " + this.removeExtension(res.getParent().getFullPath().makeRelative().toString());
            }
            return str;
        }

        public StyledString getStyledText(Object element) {
            if (!(element instanceof IResource)) {
                return new StyledString(super.getText(element));
            }
            IResource res = (IResource)element;
            StyledString str = new StyledString(this.removeExtension(res.getName()));
            if (OpenEntityDialog.this.isDuplicateElement(element)) {
                str.append(" - ", StyledString.QUALIFIER_STYLER);
                str.append(this.removeExtension(res.getParent().getFullPath().makeRelative().toString()), StyledString.QUALIFIER_STYLER);
            }
            return str;
        }

        public void dispose() {
            this._provider.removeListener((ILabelProviderListener)this);
            this._provider.dispose();
            super.dispose();
        }

        public void addListener(ILabelProviderListener listener) {
            this.listeners.add((Object)listener);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.listeners.remove((Object)listener);
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] l = this.listeners.getListeners();
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ILabelProviderListener)l[i]).labelProviderChanged(event);
            }
        }
    }

    protected class EntityFilter
    extends FilteredResourcesSelectionDialog.ResourceFilter {
        public EntityFilter(IContainer container, boolean showDerived, int typeMask) {
            super((FilteredResourcesSelectionDialog)OpenEntityDialog.this, container, showDerived, typeMask);
        }

        public boolean matchItem(Object item) {
            boolean matches = super.matchItem(item);
            if (matches) {
                matches = false;
                IResource resource = (IResource)item;
                if ("plist".equals(resource.getFileExtension()) || "storedProcedure".equals(resource.getFileExtension())) {
                    if ("eomodeld".equals(resource.getParent().getFileExtension())) {
                        matches = true;
                    }
                } else if ("eomodeld".equals(resource.getFileExtension()) && resource instanceof IContainer) {
                    matches = true;
                }
            }
            return matches;
        }
    }
}

