/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.factories;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import org.objectstyle.wolips.baseforplugins.util.URLUtils;
import org.objectstyle.wolips.eomodeler.core.model.AbstractEOClassLoader;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.factories.SimpleManifestUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleManifestEOClassLoaderFactory
extends AbstractEOClassLoader {
    @Override
    protected void fillInDevelopmentClasspath(Set<URL> classpathUrls) throws Exception {
    }

    @Override
    protected void fillInModelClasspath(EOModel model, Set<URL> classpathUrls) throws Exception {
        File modelFolder = URLUtils.cheatAndTurnIntoFile((URL)model.getModelURL()).getParentFile();
        this.fillInClasspathURLs(new File(modelFolder, "EntityModeler.classpath"), classpathUrls);
        this.fillInClasspathURLs(new File(modelFolder, ".EntityModeler.classpath"), classpathUrls);
        for (File modelParentFolder = modelFolder.getParentFile(); modelParentFolder != null; modelParentFolder = modelParentFolder.getParentFile()) {
            this.fillInClasspathURLs(new File(modelParentFolder, "EntityModeler.classpath"), classpathUrls);
            this.fillInClasspathURLs(new File(modelParentFolder, ".EntityModeler.classpath"), classpathUrls);
        }
        this.fillInClasspathURLs(new File(System.getProperty("user.home"), "EntityModeler.classpath"), classpathUrls);
        this.fillInClasspathURLs(new File(System.getProperty("user.home"), ".EntityModeler.classpath"), classpathUrls);
        this.fillInClasspathURLs(new File(System.getProperty("user.home") + "/Library", "EntityModeler.classpath"), classpathUrls);
        this.fillInClasspathURLs(new File(System.getProperty("user.home") + "/Library", ".EntityModeler.classpath"), classpathUrls);
        this.fillInClasspathURLs(new File(System.getProperty("user.home") + "/Library/Preferences", "EntityModeler.classpath"), classpathUrls);
        this.fillInClasspathURLs(new File(System.getProperty("user.home") + "/Library/Preferences", ".EntityModeler.classpath"), classpathUrls);
    }

    protected void addClasspathURL(File manifestItem, Set<URL> classpathUrls) throws IOException {
        File searchFolder = manifestItem.getCanonicalFile();
        if (searchFolder != null && searchFolder.exists()) {
            if (searchFolder.getName().endsWith(".framework")) {
                File javaFolder = new File(searchFolder, "Resources/Java");
                if (javaFolder.exists()) {
                    File[] jarFiles;
                    classpathUrls.add(javaFolder.toURL());
                    for (File jarFile : jarFiles = javaFolder.listFiles()) {
                        if (!jarFile.getName().toLowerCase().endsWith(".jar")) continue;
                        System.out.println("SimpleManifestEOClassLoaderFactory.fillInClasspathURLs:   jar = " + jarFile);
                        classpathUrls.add(jarFile.toURL());
                    }
                }
            } else {
                classpathUrls.add(searchFolder.toURL());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillInClasspathURLs(File manifestFile, final Set<URL> classpathUrls) throws IOException {
        if (manifestFile.exists()) {
            System.out.println("SimpleManifestEOClassLoaderFactory.fillInClasspathURLs: Manifest = " + manifestFile + " ...");
            BufferedReader manifestReader = new BufferedReader(new FileReader(manifestFile));
            try {
                String searchFolderPath;
                while ((searchFolderPath = manifestReader.readLine()) != null) {
                    if (searchFolderPath.contains("*")) {
                        SimpleManifestUtilities.fillInSearchFolders(manifestFile.getParentFile(), searchFolderPath, new SimpleManifestUtilities.SearchFolderDelegate(){

                            public void fileMatched(File file) throws IOException {
                                SimpleManifestEOClassLoaderFactory.this.addClasspathURL(file, classpathUrls);
                            }
                        });
                        continue;
                    }
                    this.addClasspathURL(new File(searchFolderPath), classpathUrls);
                }
            }
            finally {
                manifestReader.close();
            }
        }
    }
}

