/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.objectstyle.wolips.bindings.utils.BindingReflectionUtils;
import org.objectstyle.wolips.componenteditor.ComponenteditorPlugin;
import org.objectstyle.wolips.core.resources.types.TypeNameCollector;

public class WOElementSelectionDialog
extends ElementListSelectionDialog {
    private IJavaProject _javaProject;
    private Point _location;
    private Point _size;
    private IRunnableContext _context;

    public WOElementSelectionDialog(Shell parent, IJavaProject javaProject, IRunnableContext context) {
        super(parent, (ILabelProvider)new ComponentLabelProvider());
        this._javaProject = javaProject;
        this._context = context;
        this.setIgnoreCase(true);
        this.setMultipleSelection(false);
        this.setAllowDuplicates(false);
    }

    public int open() {
        try {
            final TypeNameCollector typeNameCollector = new TypeNameCollector(this._javaProject, false);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        BindingReflectionUtils.findMatchingElementClassNames((String)"", (int)1, (TypeNameCollector)typeNameCollector, (IProgressMonitor)monitor);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new InvocationTargetException(e);
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            };
            this._context.run(true, true, runnable);
            if (typeNameCollector.isEmpty()) {
                String title = "None";
                String message = "None";
                MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
                return 1;
            }
            this.setElements(typeNameCollector.getTypeNames().toArray());
        }
        catch (Exception e) {
            return 1;
        }
        return super.open();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    public boolean close() {
        return super.close();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        return control;
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        if (this._size != null) {
            result.x = Math.max(result.x, this._size.x);
            result.y = Math.max(result.y, this._size.y);
            Rectangle display = this.getShell().getDisplay().getClientArea();
            result.x = Math.min(result.x, display.width);
            result.y = Math.min(result.y, display.height);
        }
        return result;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point result = super.getInitialLocation(initialSize);
        if (this._location != null) {
            int ye;
            result.x = this._location.x;
            result.y = this._location.y;
            Rectangle display = this.getShell().getDisplay().getClientArea();
            int xe = result.x + initialSize.x;
            if (xe > display.width) {
                result.x -= xe - display.width;
            }
            if ((ye = result.y + initialSize.y) > display.height) {
                result.y -= ye - display.height;
            }
        }
        return result;
    }

    public static class ComponentLabelProvider
    implements ILabelProvider {
        private static Image _componentImage;

        public ComponentLabelProvider() {
            _componentImage = ComponenteditorPlugin.getImageDescriptor("icons/ComponentEditor.png").createImage();
        }

        public Image getImage(Object element) {
            return _componentImage;
        }

        public String getText(Object element) {
            String str = (String)element;
            int dotIndex = str.lastIndexOf(46);
            if (dotIndex != -1) {
                str = str.substring(dotIndex + 1);
            }
            return str;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            _componentImage.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

