/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.inspector;

import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.objectstyle.wolips.componenteditor.inspector.BindingsDragHandler;
import org.objectstyle.wolips.componenteditor.inspector.IAutoscroller;
import org.objectstyle.wolips.componenteditor.inspector.IWOBrowserDelegate;
import org.objectstyle.wolips.componenteditor.inspector.PopAnimator;
import org.objectstyle.wolips.componenteditor.inspector.WOBrowserColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBindingsDropHandler<T, U, V, W extends Control>
implements IWOBrowserDelegate,
IAutoscroller.Delegate {
    private V _bindingsAnnotation;
    private U _selectedItem;
    private IAutoscroller _autoscroller;
    private PopAnimator _popper;
    private W _editorControl;

    public AbstractBindingsDropHandler(W editorControl) {
        this._editorControl = editorControl;
        this._popper = new PopAnimator();
        this._popper.setControl((Control)this._editorControl);
        this._autoscroller = this.createAutoscroller(this._editorControl);
        this._autoscroller.setDelegate(this);
    }

    public W getEditorControl() {
        return this._editorControl;
    }

    @Override
    public void autoscrollOccurred(IAutoscroller scroller) {
        this.removeHoverAnnotation();
    }

    public void dispose() {
        if (this._popper != null) {
            if (!this._editorControl.isDisposed()) {
                this._editorControl.removePaintListener((PaintListener)this._popper);
            }
            this._popper.dispose();
        }
    }

    public synchronized V getBindingsAnnotation() {
        return this._bindingsAnnotation;
    }

    protected synchronized void addHoverAnnotation(U selectedItem) {
        this._bindingsAnnotation = this._addHoverAnnotation(selectedItem);
        this._popper.startAnimation();
    }

    protected synchronized void removeHoverAnnotation() {
        this._popper.stopAnimation();
        if (this._bindingsAnnotation != null) {
            this._removeHoverAnnotation(this._bindingsAnnotation);
            this._bindingsAnnotation = null;
            this._selectedItem = null;
        }
    }

    protected boolean isEditorActive() {
        return this._editorControl.isVisible();
    }

    @Override
    public void bindingDragging(WOBrowserColumn column, Point dragPoint) {
        try {
            if (!this.isEditorActive()) {
                this.removeHoverAnnotation();
                return;
            }
            U previousSelectedItem = this._selectedItem;
            Point controlDragPoint = this._editorControl.toControl(dragPoint);
            this._autoscroller.autoscroll(controlDragPoint);
            Rectangle controlBounds = this._editorControl.getBounds();
            controlBounds.x = 0;
            controlBounds.y = 0;
            if (controlBounds.contains(controlDragPoint)) {
                T selectedContainer = this.getSelectedContainerAtPoint(controlDragPoint, false);
                if (selectedContainer != null) {
                    U selectedItem = this.getSelectedItemAtPoint(selectedContainer, controlDragPoint);
                    if (selectedItem == null) {
                        this.removeHoverAnnotation();
                    } else if (this.isSelectedItemChanged(previousSelectedItem, selectedItem)) {
                        this.removeHoverAnnotation();
                        if (!this._autoscroller.isScrollStarted()) {
                            try {
                                this._selectedItem = selectedItem;
                                Rectangle selectionRect = this.getSelectionRectangle(selectedItem);
                                this._popper.setAnimationRect(selectionRect);
                                this.addHoverAnnotation(selectedItem);
                            }
                            catch (Throwable t) {
                                this._popper.setAnimationRect(null);
                            }
                        }
                    } else {
                        this._popper.step();
                    }
                } else if (this._bindingsAnnotation != null) {
                    this.removeHoverAnnotation();
                }
            } else if (this._bindingsAnnotation != null) {
                this.removeHoverAnnotation();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void bindingDragCanceled(WOBrowserColumn column) {
        this.bindingDragFinished(column, null, false, null);
    }

    @Override
    public boolean bindingDropped(WOBrowserColumn column, Point dropPoint, BindingsDragHandler dragHandler) {
        return this.bindingDragFinished(column, dropPoint, true, dragHandler);
    }

    public boolean bindingDragFinished(WOBrowserColumn column, Point dropPoint, boolean dropped, BindingsDragHandler dragHandler) {
        boolean dropFinished = true;
        try {
            this._autoscroller.stopScroll();
            Point controlDragPoint = this._editorControl.toControl(dropPoint);
            Rectangle controlBounds = this._editorControl.getBounds();
            controlBounds.x = 0;
            controlBounds.y = 0;
            if (this.isEditorActive() && dropped && controlBounds.contains(controlDragPoint)) {
                dropFinished = this.dropFromColumnAtPoint(column, dropPoint, dragHandler);
            } else {
                this.removeHoverAnnotation();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dropFinished;
    }

    @Override
    public void browserColumnAdded(WOBrowserColumn column) {
    }

    @Override
    public void browserColumnRemoved(WOBrowserColumn column) {
    }

    protected abstract IAutoscroller createAutoscroller(W var1);

    protected abstract V _addHoverAnnotation(U var1);

    protected abstract void _removeHoverAnnotation(V var1);

    protected abstract boolean isSelectedItemChanged(U var1, U var2);

    protected abstract U getSelectedItemAtPoint(T var1, Point var2);

    protected abstract T getSelectedContainerAtPoint(Point var1, boolean var2) throws Exception;

    protected abstract Rectangle getSelectionRectangle(U var1);

    protected abstract boolean dropFromColumnAtPoint(WOBrowserColumn var1, Point var2, BindingsDragHandler var3) throws Exception;
}

