/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.inspector;

import java.util.List;
import java.util.TreeSet;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.objectstyle.wolips.bindings.api.IApiBinding;
import org.objectstyle.wolips.bindings.api.Wo;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.WodProblem;
import org.objectstyle.wolips.componenteditor.ComponenteditorPlugin;
import org.objectstyle.wolips.componenteditor.inspector.BindingsDragHandler;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.refactoring.RefactoringWodElement;
import org.objectstyle.wolips.wodclipse.core.util.WodModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingsPopUpMenu
implements MenuListener {
    private Menu _menu;
    private WodParserCache _cache;

    public BindingsPopUpMenu(Decorations parent, WodParserCache cache) {
        this._menu = new Menu(parent, 8);
        this._menu.addMenuListener((MenuListener)this);
        this._cache = cache;
    }

    public void menuHidden(MenuEvent e) {
        Menu menu = (Menu)e.widget;
        BindingsDragHandler dragHandler = (BindingsDragHandler)menu.getData();
        if (dragHandler != null) {
            dragHandler.bindingDropFinished();
        }
    }

    public void menuShown(MenuEvent e) {
    }

    public Menu getMenu() {
        return this._menu;
    }

    public void dispose() {
        this._menu.dispose();
    }

    public boolean showMenuAtLocation(IWodElement wodElement, String droppedKeyPath, Point location, BindingsDragHandler dragHandler) throws Exception {
        boolean showMenu = false;
        Wo api = wodElement.getApi(this._cache.getJavaProject(), WodParserCache.getTypeCache());
        if (api != null) {
            IApiBinding[] apiBindings = wodElement.getApiBindings(api);
            if (apiBindings != null && apiBindings.length > 0) {
                MenuItem mi;
                TreeSet<IApiBinding> keyBindings = new TreeSet<IApiBinding>();
                TreeSet<IApiBinding> actionBindings = new TreeSet<IApiBinding>();
                for (IApiBinding iApiBinding : apiBindings) {
                    if (iApiBinding.isAction()) {
                        actionBindings.add(iApiBinding);
                        showMenu = true;
                        continue;
                    }
                    keyBindings.add(iApiBinding);
                    showMenu = true;
                }
                for (IApiBinding iApiBinding : this._menu.getItems()) {
                    iApiBinding.dispose();
                }
                List wodProblems = WodModelUtils.getProblems((IWodElement)wodElement, (WodParserCache)this._cache);
                BindingSelectionListener selectionListener = new BindingSelectionListener(wodElement, droppedKeyPath, this._cache);
                for (IApiBinding iApiBinding : keyBindings) {
                    mi = this.createMenuItem(wodElement, iApiBinding, wodProblems);
                    mi.addSelectionListener((SelectionListener)selectionListener);
                }
                if (!keyBindings.isEmpty() && !actionBindings.isEmpty()) {
                    new MenuItem(this._menu, 2);
                }
                for (IApiBinding iApiBinding : actionBindings) {
                    mi = this.createMenuItem(wodElement, iApiBinding, wodProblems);
                    mi.addSelectionListener((SelectionListener)selectionListener);
                }
                if (showMenu) {
                    this._menu.setData((Object)dragHandler);
                    this._menu.setLocation(location.x, location.y);
                    this._menu.setVisible(true);
                }
            } else {
                showMenu = false;
            }
        }
        return showMenu;
    }

    protected MenuItem createMenuItem(IWodElement element, IApiBinding binding, List<WodProblem> wodProblems) {
        MenuItem menuItem = new MenuItem(this._menu, 0);
        menuItem.setData((Object)binding);
        menuItem.setText(binding.getName());
        if (element.getBindingNamed(binding.getName()) != null) {
            menuItem.setImage(ComponenteditorPlugin.getDefault().getImage("connected"));
        } else if (WodModelUtils.hasValidationProblem((IApiBinding)binding, wodProblems)) {
            menuItem.setImage(ComponenteditorPlugin.getDefault().getImage("unconnectedProblem"));
        } else {
            menuItem.setImage(ComponenteditorPlugin.getDefault().getImage("unconnected"));
        }
        return menuItem;
    }

    protected static class BindingSelectionListener
    implements SelectionListener {
        private IWodElement _wodElement;
        private String _droppedKeyPath;
        private WodParserCache _cache;

        public BindingSelectionListener(IWodElement wodElement, String droppedKeyPath, WodParserCache cache) {
            this._wodElement = wodElement;
            this._droppedKeyPath = droppedKeyPath;
            this._cache = cache;
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            MenuItem item = (MenuItem)event.widget;
            item.setImage(ComponenteditorPlugin.getDefault().getImage("connected"));
            IApiBinding apiBinding = (IApiBinding)item.getData();
            RefactoringWodElement refactoringWodElement = new RefactoringWodElement(this._wodElement, this._cache);
            try {
                refactoringWodElement.setValueForBinding(this._droppedKeyPath, apiBinding.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
                ComponenteditorPlugin.getDefault().log("Failed to add binding.", e);
            }
        }
    }
}

