/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.pbserver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class PBServer {
    public static final int DEFAULT_PB_PORT = 8547;
    ServerSocket myServerSocket;
    private Thread myServerThread;
    boolean myRunning;

    public synchronized void start(int _port) throws IOException {
        this.myServerSocket = new ServerSocket(_port);
        this.myRunning = true;
        this.myServerThread = new Thread(new ServerSocketAcceptor());
        this.myServerThread.start();
    }

    public synchronized void stop() throws IOException {
        this.myRunning = false;
        this.myServerSocket.close();
    }

    private Element appendArray(Document _document) {
        Element arrayElement = _document.createElement("array");
        _document.appendChild(arrayElement);
        return arrayElement;
    }

    private Element appendString(Element _element, String _string) {
        Element stringElement = _element.getOwnerDocument().createElement("string");
        _element.appendChild(stringElement);
        Text stringText = _element.getOwnerDocument().createTextNode(_string);
        stringElement.appendChild(stringText);
        return stringElement;
    }

    private String text(Element _element, String _tagName) {
        String text;
        NodeList elementsList = _element.getElementsByTagName(_tagName);
        if (elementsList.getLength() > 0) {
            Element textElementContainer = (Element)elementsList.item(0);
            Text textNode = (Text)textElementContainer.getChildNodes().item(0);
            text = textNode.getNodeValue();
        } else {
            text = null;
        }
        return text;
    }

    public String[] strings(Element _parentElement, String _arrayName) {
        Element arrayParentElement = (Element)_parentElement.getElementsByTagName(_arrayName).item(0);
        Element arrayElement = (Element)arrayParentElement.getElementsByTagName("array").item(0);
        NodeList stringsList = arrayElement.getChildNodes();
        String[] strings = new String[stringsList.getLength()];
        for (int i = 0; i < strings.length; ++i) {
            Element textElementContainer = (Element)stringsList.item(0);
            Text textNode = (Text)textElementContainer.getChildNodes().item(0);
            strings[i] = textNode.getNodeValue();
        }
        return strings;
    }

    private IProject project(Document _requestDocument, String _cookieName) {
        String cookie = this.text(_requestDocument.getDocumentElement(), _cookieName);
        IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(cookie));
        IProject project = container.getProject();
        return project;
    }

    private String path(Document _requestDocument) {
        String path = this.text(_requestDocument.getDocumentElement(), "path");
        return path;
    }

    public Document openProjectsAppropriateForFile(Document _requestDocument) throws ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        String path = this.path(_requestDocument);
        Document responseDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocation((IPath)new Path(path));
        Element arrayElement = this.appendArray(responseDocument);
        for (int i = 0; i < containers.length; ++i) {
            IProject project = containers[i].getProject();
            IFile xcodeFile = project.getFile(project.getName() + ".xcode");
            if (!xcodeFile.exists()) {
                xcodeFile = project.getFile(project.getName() + ".xcodeproj");
            }
            String xcodeFilePath = xcodeFile.getLocation().toOSString();
            if (containers[i].getName().endsWith(".woa")) {
                IFile pbDevelopmentResourceFile = containers[i].getFile(new Path("Contents").append("pbdevelopment.plist"));
                Document pbDevelopmentDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element plistElement = pbDevelopmentDocument.createElement("plist");
                plistElement.setAttribute("version", "1.0");
                pbDevelopmentDocument.appendChild(plistElement);
                Element dictElement = pbDevelopmentDocument.createElement("dict");
                plistElement.appendChild(dictElement);
                Element keyElement = pbDevelopmentDocument.createElement("key");
                dictElement.appendChild(keyElement);
                keyElement.appendChild(pbDevelopmentDocument.createTextNode("PBXProjectSourcePath"));
                Element stringElement = pbDevelopmentDocument.createElement("string");
                dictElement.appendChild(stringElement);
                stringElement.appendChild(pbDevelopmentDocument.createTextNode(xcodeFilePath));
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                DOMSource source = new DOMSource(pbDevelopmentDocument);
                File pbDevelopmentFile = pbDevelopmentResourceFile.getLocation().toFile();
                StreamResult result = new StreamResult(pbDevelopmentFile);
                transformer.transform(source, result);
            }
            this.appendString(arrayElement, xcodeFilePath);
        }
        return responseDocument;
    }

    public Document targetsInProjectContainingFile(Document _requestDocument) throws ParserConfigurationException {
        IProject project = this.project(_requestDocument, "cookie");
        Document responseDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        this.appendString(this.appendArray(responseDocument), project.getName());
        this.appendString(this.appendArray(responseDocument), "Application Server");
        this.appendString(this.appendArray(responseDocument), "Web Server");
        return responseDocument;
    }

    public Document targetsInProject() throws ParserConfigurationException {
        Document responseDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        this.appendString(this.appendArray(responseDocument), "mockTarget");
        return responseDocument;
    }

    public void nameOfProject(Document _requestDocument, OutputStream _os) {
        IProject project = this.project(_requestDocument, "projectCookie");
        new PrintStream(_os, true).print(project.getName());
    }

    public void addFilesToProject(Document _requestDocument, OutputStream _os) {
        Element documentElement = _requestDocument.getDocumentElement();
        String[] addFiles = this.strings(documentElement, "addFiles");
        for (int i = 0; i < addFiles.length; ++i) {
            System.out.println("PBServer.addFilesToProject: add files " + addFiles[i]);
        }
        new PrintStream(_os, true).print("YES");
    }

    public Document filesOfTypesInTargetOfProject(Document _requestDocument) throws ParserConfigurationException, CoreException {
        IProject project = this.project(_requestDocument, "cookie");
        Element documentElement = _requestDocument.getDocumentElement();
        String[] typesArray = this.strings(documentElement, "typesArray");
        FileTypeResourceVisitor visitor = new FileTypeResourceVisitor(typesArray);
        project.accept((IResourceVisitor)visitor, 2, 4);
        Document responseDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element arrayElement = this.appendArray(responseDocument);
        for (IResource resource : visitor.getMatchingFiles()) {
            this.appendString(arrayElement, resource.getLocation().toOSString());
        }
        return responseDocument;
    }

    public void nameOfTargetInProject(Document _requestDocument, OutputStream _os) {
        Element documentElement = _requestDocument.getDocumentElement();
        String targetCookie = this.text(documentElement, "targetCookie");
        new PrintStream(_os, true).print(targetCookie);
    }

    public void openFile(Document _requestDocument, OutputStream _os) {
        String filename = this.text(_requestDocument.getDocumentElement(), "filename");
        String lineNumberStr = this.text(_requestDocument.getDocumentElement(), "linenumber");
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(filename));
        final int lineNumber = Integer.parseInt(lineNumberStr);
        if (file != null) {
            IWorkbenchWindow[] workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
            for (int i = 0; i < workbenchWindows.length; ++i) {
                final IWorkbenchPage workbenchPage = workbenchWindows[i].getActivePage();
                if (workbenchPage == null) continue;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)workbenchPage, (IFile)file, (boolean)true);
                            if (editorPart != null && editorPart instanceof ITextEditor) {
                                ITextEditor textEditor = (ITextEditor)editorPart;
                                IDocumentProvider documentProvider = textEditor.getDocumentProvider();
                                IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
                                int lineOffset = document.getLineOffset(lineNumber - 1);
                                textEditor.selectAndReveal(lineOffset, 0);
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace(System.out);
                        }
                    }
                });
            }
        }
        new PrintStream(_os, true).print("YES");
    }

    public void addGroup(Document _requestDocument, OutputStream _os) {
        String name = this.text(_requestDocument.getDocumentElement(), "name");
        System.out.println("PBServer.addGroup: name = " + name);
        new PrintStream(_os, true).print("YES");
    }

    public void addGroupToPreferredInsertionGroup(Document _requestDocument, OutputStream _os) {
        String name = this.text(_requestDocument.getDocumentElement(), "name");
        System.out.println("PBServer.addGroupToPreferredInsertionGroup: name = " + name);
        new PrintStream(_os, true).print("YES");
    }

    public void handleRequestDocument(Document _requestDocument, OutputStream _os) throws Throwable {
        Document responseDocument = null;
        String nodeName = _requestDocument.getDocumentElement().getNodeName();
        if ("openProjectsAppropriateForFile".equals(nodeName)) {
            responseDocument = this.openProjectsAppropriateForFile(_requestDocument);
        } else if ("targetsInProjectContainingFile".equals(nodeName)) {
            responseDocument = this.targetsInProjectContainingFile(_requestDocument);
        } else if ("targetsInProject".equals(nodeName)) {
            responseDocument = this.targetsInProject();
        } else if ("nameOfProject".equals(nodeName)) {
            this.nameOfProject(_requestDocument, _os);
        } else if ("addFilesToProject".equals(nodeName)) {
            this.addFilesToProject(_requestDocument, _os);
        } else if ("filesOfTypesInTargetOfProject".equals(nodeName)) {
            responseDocument = this.filesOfTypesInTargetOfProject(_requestDocument);
        } else if ("nameOfTarget".equals(nodeName)) {
            this.nameOfTargetInProject(_requestDocument, _os);
        } else if ("OpenFile".equals(nodeName)) {
            this.openFile(_requestDocument, _os);
        } else if ("addGroup".equals(nodeName)) {
            this.addGroup(_requestDocument, _os);
        } else if ("addGroupToPreferredInsertionGroup".equals(nodeName)) {
            this.addGroupToPreferredInsertionGroup(_requestDocument, _os);
        } else {
            System.out.println("PBServer.run: Unknown request: " + nodeName);
        }
        if (responseDocument != null) {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(responseDocument);
            StreamResult result = new StreamResult(_os);
            transformer.transform(source, result);
        }
    }

    public class ServerSocketAcceptor
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (PBServer.this.myRunning) {
                try {
                    Socket socket = PBServer.this.myServerSocket.accept();
                    OutputStream os = socket.getOutputStream();
                    try {
                        InputStream is = socket.getInputStream();
                        StringBuffer sb = new StringBuffer();
                        sb.append((char)is.read());
                        while (is.available() > 0) {
                            int ch = is.read();
                            sb.append((char)ch);
                        }
                        Document requestDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(sb.toString())));
                        PBServer.this.handleRequestDocument(requestDocument, os);
                    }
                    finally {
                        os.flush();
                        os.close();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace(System.out);
                }
            }
        }
    }

    public class FileTypeResourceVisitor
    implements IResourceVisitor {
        private String[] myFileTypes;
        private List myMatchingFiles;

        public FileTypeResourceVisitor(String[] _fileTypes) {
            this.myFileTypes = _fileTypes;
            this.myMatchingFiles = new LinkedList();
        }

        public List getMatchingFiles() {
            return this.myMatchingFiles;
        }

        public boolean visit(IResource _resource) throws CoreException {
            boolean matched = false;
            for (int i = 0; !matched && i < this.myFileTypes.length; ++i) {
                if (!this.myFileTypes[i].equalsIgnoreCase(_resource.getFileExtension())) continue;
                this.myMatchingFiles.add(_resource);
                matched = true;
            }
            return true;
        }
    }
}

