/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforuiplugins.utils;

import java.util.LinkedList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TreeItem;

public class WOTreeCellNavigationStrategy
extends CellNavigationStrategy {
    public void collapse(ColumnViewer viewer, ViewerCell cellToCollapse, Event event) {
        if (cellToCollapse != null) {
            ((TreeItem)cellToCollapse.getItem()).setExpanded(false);
        }
    }

    public void expand(ColumnViewer viewer, ViewerCell cellToExpand, Event event) {
        if (cellToExpand != null) {
            TreeViewer v = (TreeViewer)viewer;
            LinkedList<Object> segments = new LinkedList<Object>();
            for (TreeItem item = (TreeItem)cellToExpand.getItem(); item != null; item = item.getParentItem()) {
                Object segment = item.getData();
                Assert.isNotNull((Object)segment);
                segments.addFirst(segment);
            }
            TreePath selectedPath = new TreePath(segments.toArray());
            v.setExpandedState((Object)selectedPath, true);
        }
    }

    public boolean isCollapseEvent(ColumnViewer viewer, ViewerCell cellToCollapse, Event event) {
        if (cellToCollapse == null) {
            return false;
        }
        return cellToCollapse != null && ((TreeItem)cellToCollapse.getItem()).getExpanded() && event.keyCode == 0x1000003 && this.isFirstColumnCell(cellToCollapse);
    }

    public boolean isExpandEvent(ColumnViewer viewer, ViewerCell cellToExpand, Event event) {
        if (cellToExpand == null) {
            return false;
        }
        return cellToExpand != null && ((TreeItem)cellToExpand.getItem()).getItemCount() > 0 && !((TreeItem)cellToExpand.getItem()).getExpanded() && event.keyCode == 0x1000004 && this.isFirstColumnCell(cellToExpand);
    }

    private boolean isFirstColumnCell(ViewerCell cell) {
        return true;
    }
}

