/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.goodies.core.mac;

import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.refresh.IRefreshMonitor;
import org.eclipse.core.resources.refresh.IRefreshResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.objectstyle.wolips.goodies.core.mac.jna.CoreFoundation;
import org.objectstyle.wolips.goodies.core.mac.jna.CoreServices;

public class MacRefreshMonitor
extends Job
implements IRefreshMonitor {
    final Map<IPath, MonitoredResource> _resources;
    CoreServices coreServices;
    CoreFoundation coreFoundation;
    long currentEvent = -1L;
    private MonitorRefreshThread monitorThread;

    public MacRefreshMonitor() {
        super("MacRefreshMonitor");
        this.setPriority(50);
        this.setSystem(true);
        this._resources = new ConcurrentHashMap<IPath, MonitoredResource>();
        this.coreServices = CoreServices.CoreServicesWrapper.defaultInstance();
        this.coreFoundation = CoreFoundation.CoreFoundationWrapper.defaultInstance();
        this.currentEvent = this.coreServices.FSEventsGetCurrentEventId();
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.closeStream();
        this.monitorThread = new MonitorRefreshThread();
        this.monitorThread.start();
        return Status.OK_STATUS;
    }

    public void monitor(IResource resource, IRefreshResult refreshResult) {
        if (resource != null && refreshResult != null) {
            MonitoredResource monitoredResource = new MonitoredResource(resource, refreshResult);
            this._resources.put(MacRefreshMonitor.canonicalPath(resource.getLocation()), monitoredResource);
            this.schedule();
        }
    }

    public void unmonitor(IResource resource) {
        if (resource != null) {
            this._resources.remove(resource.getLocation());
            this.schedule();
        }
    }

    public synchronized void dispose() {
        this.closeStream();
        this.currentEvent = -1L;
        this.coreFoundation = null;
        this.coreServices = null;
    }

    private void closeStream() {
        if (this.monitorThread != null) {
            this.monitorThread.cancel();
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public static IPath canonicalPath(IPath path) {
        if (path == null) {
            return null;
        }
        try {
            String pathString = path.toOSString();
            String canonicalPath = new File(pathString).getCanonicalPath();
            if (canonicalPath.equals(pathString)) {
                return path;
            }
            return new Path(canonicalPath);
        }
        catch (IOException e) {
            return path;
        }
    }

    MonitoredResource monitoredResourceForPath(IPath path) {
        IPath aPath = path;
        MonitoredResource resource = this._resources.get(aPath);
        while (resource == null && !path.isRoot() && !"/".equals(aPath.toPortableString())) {
            aPath = aPath.removeLastSegments(1);
            resource = this._resources.get(aPath);
        }
        return resource;
    }

    private class MonitorRefreshThread
    extends Thread {
        private Pointer runLoop;
        private Pointer streamRef;
        private StreamEventCallback callBack;
        private CountDownLatch started;

        public MonitorRefreshThread() {
            super("MacRefreshMonitor");
            this.callBack = new StreamEventCallback();
            this.started = new CountDownLatch(1);
        }

        public void run() {
            Pointer runLoopMode = NativeLibrary.getInstance((String)"CoreFoundation").getGlobalVariableAddress("kCFRunLoopDefaultMode").getPointer(0L);
            try {
                if (MacRefreshMonitor.this._resources.size() == 0) {
                    return;
                }
                Pointer monitorPaths = MacRefreshMonitor.this.coreFoundation.CFArrayCreate(this.resourcePaths());
                this.streamRef = MacRefreshMonitor.this.coreServices.FSEventStreamCreate(null, this.callBack, null, monitorPaths, MacRefreshMonitor.this.currentEvent, 1.0, 2);
                this.runLoop = MacRefreshMonitor.this.coreFoundation.CFRunLoopGetCurrent();
                MacRefreshMonitor.this.coreServices.FSEventStreamScheduleWithRunLoop(this.streamRef, this.runLoop, runLoopMode);
                MacRefreshMonitor.this.coreServices.FSEventStreamStart(this.streamRef);
            }
            finally {
                this.started.countDown();
            }
            MacRefreshMonitor.this.coreFoundation.CFRunLoopRun();
        }

        private String[] resourcePaths() {
            LinkedList<String> result = new LinkedList<String>();
            IPath[] paths = MacRefreshMonitor.this._resources.keySet().toArray(new IPath[MacRefreshMonitor.this._resources.size()]);
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i] == null) continue;
                result.add(paths[i].toOSString());
            }
            return result.toArray(new String[result.size()]);
        }

        synchronized void cancel() {
            try {
                this.started.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.runLoop != null) {
                MacRefreshMonitor.this.coreFoundation.CFRunLoopStop(this.runLoop);
                this.runLoop = null;
            }
            if (this.streamRef != null) {
                MacRefreshMonitor.this.coreServices.FSEventStreamStop(this.streamRef);
                MacRefreshMonitor.this.coreServices.FSEventStreamInvalidate(this.streamRef);
                MacRefreshMonitor.this.coreServices.FSEventStreamRelease(this.streamRef);
                this.streamRef = null;
            }
        }
    }

    class StreamEventCallback
    implements CoreServices.FSEventStreamCallback {
        StreamEventCallback() {
        }

        public void callback(Pointer streamRef, Pointer clientCallbackInfo, int numEvents, Pointer eventPaths, Pointer eventFlags, Pointer eventIds) {
            Pointer[] myPaths = eventPaths.getPointerArray(0L, numEvents);
            long[] myEvents = eventIds.getLongArray(0L, numEvents);
            for (int i = 0; i < numEvents; ++i) {
                IPath path = MacRefreshMonitor.canonicalPath((IPath)new Path(myPaths[i].getString(0L)));
                MonitoredResource resource = MacRefreshMonitor.this.monitoredResourceForPath(path);
                if (resource != null) {
                    resource.pathChanged(path);
                }
                if ((MacRefreshMonitor.this.currentEvent <= 0L || MacRefreshMonitor.this.currentEvent >= myEvents[i]) && (MacRefreshMonitor.this.currentEvent >= 0L || MacRefreshMonitor.this.currentEvent <= myEvents[i])) continue;
                MacRefreshMonitor.this.currentEvent = myEvents[i];
            }
        }
    }

    protected static class MonitoredResource {
        public final IResource _resource;
        public final IRefreshResult _result;

        public MonitoredResource(IResource resource, IRefreshResult result) {
            this._resource = resource;
            this._result = result;
        }

        public IResource getResource() {
            return this._resource;
        }

        public IRefreshResult getResult() {
            return this._result;
        }

        protected void refresh(IResource resource) {
            if (resource != null && resource.isTeamPrivateMember()) {
                IContainer refreshResource;
                for (refreshResource = resource.getParent(); refreshResource != null && refreshResource.isTeamPrivateMember(); refreshResource = refreshResource.getParent()) {
                }
                if (refreshResource != null && !resource.isSynchronized(1)) {
                    this._result.refresh((IResource)refreshResource);
                }
            } else if (resource != null && !resource.isSynchronized(1)) {
                this._result.refresh(resource);
            }
        }

        protected void pathChanged(IPath location) {
            IContainer matchingContainer = this._resource.getWorkspace().getRoot().getContainerForLocation(location);
            if (matchingContainer != null) {
                this.refresh((IResource)matchingContainer);
            } else {
                IContainer[] matchingContainers = this._resource.getWorkspace().getRoot().findContainersForLocationURI(URIUtil.toURI((IPath)location.makeAbsolute()));
                if (matchingContainers != null) {
                    for (IContainer container : matchingContainers) {
                        this.refresh((IResource)container);
                    }
                }
            }
        }
    }
}

