/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.htmlpreview.editor;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.RenderContext;
import jp.aonir.fuzzyxml.internal.RenderDelegate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.objectstyle.wolips.bindings.api.ApiCache;
import org.objectstyle.wolips.bindings.api.ApiUtils;
import org.objectstyle.wolips.bindings.api.Wo;
import org.objectstyle.wolips.bindings.utils.BindingReflectionUtils;
import org.objectstyle.wolips.bindings.wod.IWodBinding;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.TypeCache;
import org.objectstyle.wolips.htmlpreview.editor.TagDelegate;
import org.objectstyle.wolips.htmlpreview.editor.tags.DefaultTagDelegate;
import org.objectstyle.wolips.htmlpreview.editor.tags.ERXStyleSheetTagDelegate;
import org.objectstyle.wolips.htmlpreview.editor.tags.WOBrowserTagDelegate;
import org.objectstyle.wolips.htmlpreview.editor.tags.WOCheckBoxTagDelegate;
import org.objectstyle.wolips.htmlpreview.editor.tags.WOComponentContentTagDelegate;
import org.objectstyle.wolips.htmlpreview.editor.tags.WOConditionalTagDelegate;
import org.objectstyle.wolips.htmlpreview.editor.tags.WOGenericContainerTagDelegate;
import org.objectstyle.wolips.htmlpreview.editor.tags.WOGenericElementTagDelegate;
import org.objectstyle.wolips.htmlpreview.editor.tags.WOHyperlinkTagDelegate;
import org.objectstyle.wolips.htmlpreview.editor.tags.WOImageTagDelegate;
import org.objectstyle.wolips.htmlpreview.editor.tags.WOPopUpButtonTagDelegate;
import org.objectstyle.wolips.htmlpreview.editor.tags.WORepetitionTagDelegate;
import org.objectstyle.wolips.htmlpreview.editor.tags.WOStringTagDelegate;
import org.objectstyle.wolips.htmlpreview.editor.tags.WOSubmitButtonTagDelegate;
import org.objectstyle.wolips.htmlpreview.editor.tags.WOTextFieldTagDelegate;
import org.objectstyle.wolips.htmlpreview.editor.tags.WOTextTagDelegate;
import org.objectstyle.wolips.locate.LocatePlugin;
import org.objectstyle.wolips.locate.result.LocalizedComponentsLocateResult;
import org.objectstyle.wolips.variables.BuildProperties;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.util.WodHtmlUtils;

public class PreviewRenderDelegate
implements RenderDelegate {
    private static final String DEFAULT = "__default";
    private Map<String, TagDelegate> _tagDelegates;
    private Stack<WodParserCache> _caches = new Stack();
    private Stack<FuzzyXMLNode> _nodes = new Stack();
    private StringBuffer _cssBuffer;
    private boolean _previewStyleRendered;

    public PreviewRenderDelegate(WodParserCache cache) {
        this._caches.push(cache);
        this._cssBuffer = new StringBuffer();
        this._tagDelegates = new HashMap<String, TagDelegate>();
        this._tagDelegates.put("WOString", new WOStringTagDelegate());
        this._tagDelegates.put("ERXLocalizedString", new WOStringTagDelegate());
        this._tagDelegates.put("WOConditional", new WOConditionalTagDelegate());
        this._tagDelegates.put("WOComponentContent", new WOComponentContentTagDelegate());
        this._tagDelegates.put("WORepetition", new WORepetitionTagDelegate());
        this._tagDelegates.put("WOGenericContainer", new WOGenericContainerTagDelegate());
        this._tagDelegates.put("WOGenericElement", new WOGenericElementTagDelegate());
        this._tagDelegates.put("WOTextField", new WOTextFieldTagDelegate());
        this._tagDelegates.put("FocusTextField", new WOTextFieldTagDelegate());
        this._tagDelegates.put("WOCheckBox", new WOCheckBoxTagDelegate());
        this._tagDelegates.put("WOPopUpButton", new WOPopUpButtonTagDelegate());
        this._tagDelegates.put("WOText", new WOTextTagDelegate());
        this._tagDelegates.put("FocusText", new WOTextTagDelegate());
        this._tagDelegates.put("WOSubmitButton", new WOSubmitButtonTagDelegate());
        this._tagDelegates.put("WOHyperlink", new WOHyperlinkTagDelegate());
        this._tagDelegates.put("WOImage", new WOImageTagDelegate());
        this._tagDelegates.put("WOBrowser", new WOBrowserTagDelegate());
        this._tagDelegates.put("ERXStyleSheet", new ERXStyleSheetTagDelegate());
        this._tagDelegates.put(DEFAULT, new DefaultTagDelegate());
    }

    public void beforeRender(RenderContext renderContext, StringBuffer xmlBuffer) {
        this._previewStyleRendered = false;
        this._cssBuffer = new StringBuffer();
    }

    public void afterRender(RenderContext renderContext, StringBuffer xmlBuffer) {
        if (!this._previewStyleRendered) {
            this.renderPreviewStyle(xmlBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renderNode(FuzzyXMLNode node, RenderContext renderContext, StringBuffer xmlBuffer) {
        block16: {
            if (node instanceof FuzzyXMLElement) {
                FuzzyXMLElement element = (FuzzyXMLElement)node;
                String tagName = element.getName();
                if (WodHtmlUtils.isWOTag((String)tagName)) {
                    try {
                        WodParserCache cache = this._caches.peek();
                        BuildProperties buildProperties = (BuildProperties)cache.getProject().getAdapter(BuildProperties.class);
                        IWodElement wodElement = WodHtmlUtils.getWodElement((FuzzyXMLElement)element, (BuildProperties)buildProperties, (boolean)true, (WodParserCache)cache);
                        if (wodElement == null) {
                            return true;
                        }
                        String elementTypeName = wodElement.getElementType();
                        TagDelegate tagDelegate = this._tagDelegates.get(elementTypeName);
                        if (tagDelegate != null) {
                            tagDelegate.renderNode(wodElement, element, renderContext, xmlBuffer, this._cssBuffer, this._caches, this._nodes);
                            break block16;
                        }
                        IType type = BindingReflectionUtils.findElementType((IJavaProject)cache.getJavaProject(), (String)elementTypeName, (boolean)false, (TypeCache)WodParserCache.getTypeCache());
                        LocalizedComponentsLocateResult componentsLocateResults = LocatePlugin.getDefault().getLocalizedComponentsLocateResult(type.getJavaProject().getProject(), wodElement.getElementType());
                        IFile htmlFile = componentsLocateResults.getFirstHtmlFile();
                        if (htmlFile != null) {
                            String preview;
                            WodParserCache nestedCache = WodParserCache.parser((IResource)htmlFile);
                            if (nestedCache == null) break block16;
                            Wo apiModel = ApiUtils.findApiModelWo((IType)type, (ApiCache)WodParserCache.getTypeCache().getApiCache(cache.getJavaProject()));
                            if (apiModel != null && (preview = apiModel.getPreview()) != null) {
                                StringBuffer previewBuffer = new StringBuffer();
                                Pattern bindingPattern = Pattern.compile("\\$([a-zA-Z0-9_]+)");
                                Matcher matcher = bindingPattern.matcher(preview);
                                while (matcher.find()) {
                                    String bindingName = matcher.group(1);
                                    IWodBinding binding = wodElement.getBindingNamed(bindingName);
                                    if (binding == null) {
                                        matcher.appendReplacement(previewBuffer, "");
                                        continue;
                                    }
                                    matcher.appendReplacement(previewBuffer, binding.getValue());
                                }
                                matcher.appendTail(previewBuffer);
                                nestedCache = nestedCache.cloneCache();
                                nestedCache.getHtmlEntry().setContents("<span>" + previewBuffer.toString() + "</span>");
                            }
                            this._caches.push(nestedCache);
                            this._nodes.push(node);
                            try {
                                FuzzyXMLDocument nestedDocument = (FuzzyXMLDocument)nestedCache.getHtmlEntry().getModel();
                                if (nestedDocument != null) {
                                    nestedDocument.getDocumentElement().toXMLString(renderContext, xmlBuffer);
                                }
                                break block16;
                            }
                            finally {
                                this._nodes.pop();
                                this._caches.pop();
                            }
                        }
                        tagDelegate = this._tagDelegates.get(DEFAULT);
                        tagDelegate.renderNode(wodElement, element, renderContext, xmlBuffer, this._cssBuffer, this._caches, this._nodes);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    node.toXMLString(renderContext, xmlBuffer);
                }
            } else {
                node.toXMLString(renderContext, xmlBuffer);
            }
        }
        return false;
    }

    public boolean beforeOpenTag(FuzzyXMLNode node, RenderContext renderContext, StringBuffer xmlBuffer) {
        boolean renderSurroundingTags = true;
        if (node instanceof FuzzyXMLElement) {
            FuzzyXMLElement element = (FuzzyXMLElement)node;
            String tagName = element.getName();
            if (WodHtmlUtils.isWOTag((String)tagName)) {
                renderSurroundingTags = false;
            } else if ("document".equals(tagName)) {
                renderSurroundingTags = false;
            }
        }
        return renderSurroundingTags;
    }

    public void afterOpenTag(FuzzyXMLNode node, RenderContext renderContext, StringBuffer xmlBuffer) {
    }

    public void beforeCloseTag(FuzzyXMLNode node, RenderContext renderContext, StringBuffer xmlBuffer) {
    }

    public void afterCloseTag(FuzzyXMLNode node, RenderContext renderContext, StringBuffer xmlBuffer) {
    }

    protected void renderPreviewStyle(StringBuffer xmlBuffer) {
        xmlBuffer.append("<style>");
        xmlBuffer.append("span.wodclipse_block {");
        xmlBuffer.append("  display: block;");
        xmlBuffer.append("  padding: 3px;");
        xmlBuffer.append("}");
        xmlBuffer.append("span.wodclipse_block:hover {");
        xmlBuffer.append("  background-color: rgba(220, 220, 255, 0.50);");
        xmlBuffer.append("}");
        xmlBuffer.append("span.wodclipse_block span.wodclipse_tag {");
        xmlBuffer.append("}");
        xmlBuffer.append(this._cssBuffer);
        xmlBuffer.append("</style>");
        this._previewStyleRendered = true;
    }
}

