/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.objectstyle.wolips.templateengine.TemplateDefinition;
import org.objectstyle.wolips.templateengine.TemplateEngine;
import org.objectstyle.wolips.wizards.AbstractProjectWizard;
import org.objectstyle.wolips.wizards.D2WApplicationConfigurationPage;
import org.objectstyle.wolips.wizards.Messages;
import org.objectstyle.wolips.wizards.NewWOProjectWizard;

public class D2WApplicationWizard
extends AbstractProjectWizard {
    protected NewWOProjectWizard.WizardType getWizardType() {
        return NewWOProjectWizard.WizardType.D2W_APPLICATION_WIZARD;
    }

    public String getWindowTitle() {
        return Messages.getString("D2WApplicationWizard.title");
    }

    public String pathForTemplateLook(D2WApplicationConfigurationPage.D2WLook look) {
        if (look == D2WApplicationConfigurationPage.D2WLook.BASIC54) {
            return D2WApplicationConfigurationPage.D2WLook.BASIC54.getTemplatePath();
        }
        if (look == D2WApplicationConfigurationPage.D2WLook.NEUTRAL54) {
            return D2WApplicationConfigurationPage.D2WLook.NEUTRAL54.getTemplatePath();
        }
        if (look == D2WApplicationConfigurationPage.D2WLook.WEBOBJECTS54) {
            return D2WApplicationConfigurationPage.D2WLook.WEBOBJECTS54.getTemplatePath();
        }
        if (look == D2WApplicationConfigurationPage.D2WLook.BASIC52) {
            return D2WApplicationConfigurationPage.D2WLook.BASIC52.getTemplatePath();
        }
        if (look == D2WApplicationConfigurationPage.D2WLook.NEUTRAL52) {
            return D2WApplicationConfigurationPage.D2WLook.NEUTRAL52.getTemplatePath();
        }
        if (look == D2WApplicationConfigurationPage.D2WLook.WEBOBJECTS52) {
            return D2WApplicationConfigurationPage.D2WLook.WEBOBJECTS52.getTemplatePath();
        }
        if (look == D2WApplicationConfigurationPage.D2WLook.WONDER) {
            return D2WApplicationConfigurationPage.D2WLook.WONDER.getTemplatePath();
        }
        return D2WApplicationConfigurationPage.D2WLook.BASIC54.getTemplatePath();
    }

    protected void postInstallTemplate(IProject project, IProgressMonitor progressMonitor) throws Exception {
        String pathRoot = this.pathForTemplateLook(this.currentD2WLook());
        String projectName = project.getName();
        String path = project.getLocation().toOSString();
        String packagePath = "";
        String packageName = "";
        String fullSrcPath = path + File.separator + "src";
        if (this._packagePage != null) {
            packageName = this._packagePage.getPackageName();
            packagePath = this._packagePage.getConvertedPath();
            fullSrcPath = fullSrcPath + File.separator + packagePath;
        }
        this.createJavaPackageSupport(project, packagePath);
        File bin = new File(path + File.separator + "bin");
        bin.mkdirs();
        TemplateEngine templateEngine = new TemplateEngine();
        templateEngine.init();
        templateEngine.getWolipsContext().setProjectName(projectName);
        templateEngine.getWolipsContext().setPackageName(packageName);
        this.addMavenComponentDefinition(pathRoot, templateEngine, path, "Main", packagePath);
        this.addMavenComponentDefinition(pathRoot, templateEngine, path, "MenuHeader", packagePath);
        this.addMavenComponentDefinition(pathRoot, templateEngine, path, "PageWrapper", packagePath);
        templateEngine.addTemplate(new TemplateDefinition(pathRoot + "/Application.java.vm", fullSrcPath, "Application.java", "Application.java"));
        templateEngine.addTemplate(new TemplateDefinition(pathRoot + "/DirectAction.java.vm", fullSrcPath, "DirectAction.java", "DirectAction.java"));
        templateEngine.addTemplate(new TemplateDefinition(pathRoot + "/Session.java.vm", fullSrcPath, "Session.java", "Session.java"));
        templateEngine.addTemplate(new TemplateDefinition(pathRoot + "/.classpath.vm", path, ".classpath", ".classpath"));
        templateEngine.addTemplate(new TemplateDefinition(pathRoot + "/.project.vm", path, ".project", ".project"));
        templateEngine.addTemplate(new TemplateDefinition(pathRoot + "/build.xml.vm", path, "build.xml", "build.xml"));
        templateEngine.addTemplate(new TemplateDefinition(pathRoot + "/build.properties.vm", path, "build.properties", "build.properties"));
        templateEngine.addTemplate(new TemplateDefinition(pathRoot + "/Properties.vm", path, "Properties", "Properties"));
        templateEngine.addTemplate(new TemplateDefinition(pathRoot + "/user.d2wmodel.vm", path, "user.d2wmodel", "user.d2wmodel"));
        this.createWebServicesSupport(project, templateEngine);
        templateEngine.run(progressMonitor);
    }
}

