/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards;

import java.io.File;
import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.objectstyle.wolips.wizards.Messages;
import org.objectstyle.wolips.wizards.WizardsPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EOModelResourceImportPage
extends WizardDataTransferPage {
    HashMap<String, String> _modelPaths = new HashMap();
    Table _table = null;
    static Image _eomodelIcon;
    static boolean _requiresModel;

    public EOModelResourceImportPage(String name) {
        this(name, false);
    }

    public EOModelResourceImportPage(String name, boolean requiresModel) {
        super(name);
        ImageDescriptor id = WizardsPlugin.EOMODEL_ICON();
        _eomodelIcon = id.createImage();
        _requiresModel = requiresModel;
    }

    public HashMap<String, String> getModelPaths() {
        return this._modelPaths;
    }

    protected void createSourceGroup(Composite parent) {
        this._table = new Table(parent, 268503042);
        this._table.setFont(parent.getFont());
        this._table.setHeaderVisible(true);
        this._table.setLinesVisible(true);
        GridLayout tablelayout = new GridLayout();
        tablelayout.numColumns = 1;
        this._table.setLayout((Layout)tablelayout);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        this._table.setLayoutData((Object)data);
        Composite containerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout((Layout)layout);
        containerGroup.setLayoutData((Object)new GridData(768));
        containerGroup.setFont(parent.getFont());
        Button browseButton = new Button(containerGroup, 8);
        browseButton.setText("Browse...");
        browseButton.setLayoutData((Object)new GridData(256));
        browseButton.addSelectionListener((SelectionListener)new EOModelSelectionListener());
        browseButton.setFont(parent.getFont());
        this.setButtonLayoutData(browseButton);
        Button tableRemoveButton = new Button(containerGroup, 8);
        tableRemoveButton.setText("Delete");
        tableRemoveButton.setLayoutData((Object)new GridData(256));
        tableRemoveButton.addSelectionListener((SelectionListener)new TableRemoveSelectionListener());
        tableRemoveButton.setFont(parent.getFont());
        this.setButtonLayoutData(tableRemoveButton);
    }

    protected void createOptionsGroup(Composite parent) {
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.createSourceGroup(composite);
        this.createOptionsGroup(composite);
        if (_requiresModel) {
            this.setPageComplete(false);
        }
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setTitle(Messages.getString("EOModelResourceImportPage.title"));
        this.setMessage(Messages.getString("EOModelResourceImportPage.description"));
        this.setErrorMessage(null);
        this.setControl((Control)composite);
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider();
    }

    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider();
    }

    public void updatePageComplete() {
        if (_requiresModel && this.getModelPaths().size() > 1) {
            this.setMessage(null);
            this.setErrorMessage("EOModel not selected");
            this.setPageComplete(false);
        }
        this.setPageComplete(true);
        this.setMessage(Messages.getString("EOModelResourceImportPage.description"));
        this.setErrorMessage(null);
    }

    protected boolean allowNewContainerName() {
        return false;
    }

    public void handleEvent(Event arg0) {
    }

    class TableRemoveSelectionListener
    extends SelectionAdapter {
        TableRemoveSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (EOModelResourceImportPage.this._table != null) {
                int[] selectedIndexes;
                for (int anIndex : selectedIndexes = EOModelResourceImportPage.this._table.getSelectionIndices()) {
                    TableItem anItem = EOModelResourceImportPage.this._table.getItem(anIndex);
                    String key = anItem.getText().substring(anItem.getText().lastIndexOf(File.separator) + 1);
                    EOModelResourceImportPage.this._modelPaths.remove(key);
                }
                EOModelResourceImportPage.this._table.remove(selectedIndexes);
            }
        }
    }

    class EOModelSelectionListener
    extends SelectionAdapter {
        EOModelSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            DirectoryDialog ddialog = new DirectoryDialog(EOModelResourceImportPage.this.getShell(), 4098);
            ddialog.setMessage("Select EOModel bundle");
            ddialog.open();
            String rootPath = ddialog.getFilterPath();
            System.out.println("rootPath: " + rootPath);
            if (!rootPath.endsWith(".eomodeld")) {
                EOModelResourceImportPage.this.displayErrorDialog(rootPath + " is not an EOModel file and will not be copied");
            } else if (!EOModelResourceImportPage.this._modelPaths.values().contains(rootPath)) {
                EOModelResourceImportPage.this._modelPaths.put(rootPath.substring(rootPath.lastIndexOf(File.separator)), rootPath);
                EOModelResourceImportPage.this.updatePageComplete();
                if (EOModelResourceImportPage.this._table != null) {
                    TableItem item = new TableItem(EOModelResourceImportPage.this._table, 8);
                    item.setImage(_eomodelIcon);
                    item.setText(rootPath);
                }
            }
        }
    }
}

