/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.objectstyle.wolips.templateengine.TemplateDefinition;
import org.objectstyle.wolips.templateengine.TemplateEngine;
import org.objectstyle.wolips.wizards.AbstractProjectWizard;
import org.objectstyle.wolips.wizards.Messages;
import org.objectstyle.wolips.wizards.NewWOProjectWizard;

public class JarProjectWizard
extends AbstractProjectWizard {
    protected NewWOProjectWizard.WizardType getWizardType() {
        return NewWOProjectWizard.WizardType.JARPROJECT_WIZARD;
    }

    public String getWindowTitle() {
        return Messages.getString("JarProjectCreationWizard.title");
    }

    protected void postInstallTemplate(IProject project, IProgressMonitor progressMonitor) throws Exception {
        String projectName = project.getName();
        String path = project.getLocation().toOSString();
        File src = new File(path + File.separator + "src");
        src.mkdirs();
        File bin = new File(path + File.separator + "bin");
        bin.mkdirs();
        TemplateEngine templateEngine = new TemplateEngine();
        templateEngine.init();
        templateEngine.getWolipsContext().setProjectName(projectName);
        templateEngine.addTemplate(new TemplateDefinition("jarproject/.classpath.vm", path, ".classpath", ".classpath"));
        templateEngine.addTemplate(new TemplateDefinition("jarproject/.project.vm", path, ".project", ".project"));
        templateEngine.addTemplate(new TemplateDefinition("jarproject/build.xml.vm", path, "build.xml", "build.xml"));
        templateEngine.addTemplate(new TemplateDefinition("jarproject/build.properties.vm", path, "build.properties", "build.properties"));
        templateEngine.run(progressMonitor);
    }
}

