/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.objectstyle.wolips.jdt.ProjectFrameworkAdapter;
import org.objectstyle.wolips.jdt.classpath.model.IEclipseFramework;
import org.objectstyle.wolips.templateengine.InstallTemplateOperation;
import org.objectstyle.wolips.templateengine.ProjectTemplate;
import org.objectstyle.wolips.templateengine.TemplateDefinition;
import org.objectstyle.wolips.templateengine.TemplateEngine;
import org.objectstyle.wolips.wizards.D2WApplicationConfigurationPage;
import org.objectstyle.wolips.wizards.EOModelResourceImportPage;
import org.objectstyle.wolips.wizards.Messages;
import org.objectstyle.wolips.wizards.PackageSpecifierWizardPage;
import org.objectstyle.wolips.wizards.WOFrameworkSupportPage;
import org.objectstyle.wolips.wizards.WOWebServicesWizardPage;
import org.objectstyle.wolips.wizards.WizardsPlugin;
import org.objectstyle.wolips.wizards.actions.EOModelImportWorkspaceJob;
import org.objectstyle.wolips.wizards.template.TemplateInputsWizardPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NewWOProjectWizard
extends BasicNewResourceWizard
implements IExecutableExtension {
    private static String WINDOW_PROBLEMS_TITLE = ResourceMessages.NewProject_errorOpeningWindow;
    private static final String FINAL_PERSPECTIVE = "finalPerspective";
    private static final String PREFERRED_PERSPECTIVES = "preferredPerspectives";
    protected static final int NEWPROJECT_TEMPLATE_WIZARD = 0;
    private WizardNewProjectCreationPage _mainPage;
    private WizardNewProjectReferencePage _referencePage;
    protected EOModelResourceImportPage _eomodelImportPage;
    protected D2WApplicationConfigurationPage _d2wConfigurationPage;
    protected PackageSpecifierWizardPage _packagePage;
    protected WOWebServicesWizardPage _webservicesSupportPage;
    protected WOFrameworkSupportPage _frameworkSupportPage;
    protected TemplateInputsWizardPage _templateInputsWizardPage;
    private ProjectTemplate _projectTemplate;
    private IProject _newProject;
    private IConfigurationElement _configElement;

    public NewWOProjectWizard() {
        IDialogSettings workbenchSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("BasicNewProjectResourceWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("BasicNewProjectResourceWizard");
        }
        this.setDialogSettings(section);
    }

    public NewWOProjectWizard(String projectTemplateName) {
        this();
        this._projectTemplate = ProjectTemplate.loadProjectTemplateNamed((String)"Project Templates", (String)projectTemplateName);
        if (this._projectTemplate == null) {
            throw new IllegalArgumentException("There was no project template with the name '" + projectTemplateName + "'.");
        }
        this._templateInputsWizardPage = new TemplateInputsWizardPage();
        this._templateInputsWizardPage.setProjectTemplate(this._projectTemplate);
    }

    public void setProjectTemplate(ProjectTemplate projectTemplate) {
        this._projectTemplate = projectTemplate;
    }

    public ProjectTemplate getProjectTemplate() {
        return this._projectTemplate;
    }

    protected abstract WizardType getWizardType();

    public void addPages() {
        super.addPages();
        WizardType wizardType = this.getWizardType();
        this._mainPage = this.createMainPage();
        this.addPage((IWizardPage)this._mainPage);
        if (wizardType == WizardType.D2W_APPLICATION_WIZARD || wizardType == WizardType.D2WS_APPLICATION_WIZARD) {
            this._packagePage = this.createPackageSpecifierWizardPage();
            if (this._packagePage != null) {
                this.addPage((IWizardPage)this._packagePage);
            }
        }
        if (this._templateInputsWizardPage != null && this._projectTemplate.getInputs().size() > 0) {
            this.addPage((IWizardPage)this._templateInputsWizardPage);
        }
        this._referencePage = this.createReferencePage();
        if (this._referencePage != null) {
            this.addPage((IWizardPage)this._referencePage);
        }
        this._eomodelImportPage = this.createEOModelImportResourcePage();
        if (this._eomodelImportPage != null) {
            this.addPage((IWizardPage)this._eomodelImportPage);
        }
        if (wizardType == WizardType.D2W_APPLICATION_WIZARD) {
            this._d2wConfigurationPage = this.createD2WConfigurationPage();
            if (this._d2wConfigurationPage != null) {
                this.addPage((IWizardPage)this._d2wConfigurationPage);
            }
        }
        if (wizardType == WizardType.D2W_APPLICATION_WIZARD || wizardType == WizardType.WO_APPLICATION_WIZARD || wizardType == WizardType.ERREST_APPLICATION_WIZARD || wizardType == WizardType.D2WS_APPLICATION_WIZARD || wizardType == WizardType.WO_FRAMEWORK_WIZARD) {
            this._frameworkSupportPage = this.createFrameworkSupportPage();
            if (this._frameworkSupportPage != null) {
                this.addPage((IWizardPage)this._frameworkSupportPage);
            }
        }
        if (wizardType == WizardType.WO_APPLICATION_WIZARD || wizardType == WizardType.ERREST_APPLICATION_WIZARD || wizardType == WizardType.D2W_APPLICATION_WIZARD || wizardType == WizardType.WO_FRAMEWORK_WIZARD) {
            this._webservicesSupportPage = this.createWebServicesSupportPage();
            if (this._webservicesSupportPage != null) {
                this.addPage((IWizardPage)this._webservicesSupportPage);
            }
        }
    }

    protected String getPageDescription() {
        String description = ResourceMessages.NewProject_description;
        if (this.getWizardType() == WizardType.D2W_APPLICATION_WIZARD) {
            description = Messages.getString("D2WApplicationWizard.description");
        }
        return description;
    }

    protected WizardNewProjectCreationPage createMainPage() {
        WizardNewProjectCreationPage mainPage = new WizardNewProjectCreationPage("basicNewProjectPage");
        mainPage.setTitle(ResourceMessages.NewProject_title);
        mainPage.setDescription(this.getPageDescription());
        return mainPage;
    }

    protected WizardNewProjectReferencePage createReferencePage() {
        WizardNewProjectReferencePage referencePage = null;
        if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length > 0) {
            referencePage = new WizardNewProjectReferencePage("basicReferenceProjectPage");
            referencePage.setTitle(ResourceMessages.NewProject_referenceTitle);
            referencePage.setDescription(ResourceMessages.NewProject_referenceDescription);
        }
        return referencePage;
    }

    protected EOModelResourceImportPage createEOModelImportResourcePage() {
        EOModelResourceImportPage importResourcePage = new EOModelResourceImportPage("EOModelImportWizpardPage");
        importResourcePage.setTitle(Messages.getString("EOModelResourceImportPage.title"));
        importResourcePage.setDescription(Messages.getString("EOModelResourceImportPage.description"));
        importResourcePage.setMessage(Messages.getString("EOModelResourceImportPage.message"));
        return importResourcePage;
    }

    protected D2WApplicationConfigurationPage createD2WConfigurationPage() {
        D2WApplicationConfigurationPage d2wConfigPage = new D2WApplicationConfigurationPage("d2WAppConfigurationWizardPage", 0);
        d2wConfigPage.setTitle(Messages.getString("D2WApplicationConfigurationPage.title"));
        d2wConfigPage.setDescription(Messages.getString("D2WApplicationConfigurationPage.description"));
        return d2wConfigPage;
    }

    protected PackageSpecifierWizardPage createPackageSpecifierWizardPage() {
        PackageSpecifierWizardPage packagePage = new PackageSpecifierWizardPage("packageSpecifierWizardPage", 0);
        packagePage.setTitle("Specify package: ");
        packagePage.setMessage("Default package for all Java source generated for project");
        packagePage.setDescription("Default package for all Java source generated for project");
        return packagePage;
    }

    protected WOWebServicesWizardPage createWebServicesSupportPage() {
        WOWebServicesWizardPage webservicesPage = null;
        if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length > 0) {
            webservicesPage = new WOWebServicesWizardPage("webservicesSupportWizardPage", 0);
            webservicesPage.setTitle(Messages.getString("WOWebServicesWizardPage.title"));
            webservicesPage.setDescription(Messages.getString("WOWebServicesWizardPage.description"));
        }
        return webservicesPage;
    }

    protected WOFrameworkSupportPage createFrameworkSupportPage() {
        WOFrameworkSupportPage frameworkPage = null;
        if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length > 0) {
            frameworkPage = new WOFrameworkSupportPage("frameworkSupportWizardPage", 0);
            frameworkPage.setTitle(Messages.getString("WOFrameworkSupportPage.title"));
            frameworkPage.setDescription(Messages.getString("WOFrameworkSupportPage.description"));
        }
        return frameworkPage;
    }

    protected void setMainPage(WizardNewProjectCreationPage mainPage) {
        this._mainPage = mainPage;
    }

    protected void setReferencePage(WizardNewProjectReferencePage referencePage) {
        this._referencePage = referencePage;
    }

    protected IProject createNewProject() {
        if (this._newProject != null) {
            return this._newProject;
        }
        IProject newProjectHandle = this._mainPage.getProjectHandle();
        URI location = null;
        if (!this._mainPage.useDefaults()) {
            location = this._mainPage.getLocationURI();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocationURI(location);
        IProject[] refProjects = this._referencePage != null ? this._referencePage.getReferencedProjects() : null;
        try {
            WorkspaceModifyOperation op = this.createProjectTemplateOperation(this._projectTemplate, newProjectHandle, description, refProjects);
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, (String)NLS.bind((String)ResourceMessages.NewProject_caseVariantExistsError, (Object)newProjectHandle.getName()));
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                IDEWorkbenchPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.ide", 0, t.toString(), t));
                MessageDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, (String)NLS.bind((String)ResourceMessages.NewProject_internalError, (Object)t.getMessage()));
            }
            return null;
        }
        this._newProject = newProjectHandle;
        return this._newProject;
    }

    protected WorkspaceModifyOperation createProjectTemplateOperation(ProjectTemplate template, IProject project, IProjectDescription projectDescription, IProject[] refProjects) {
        InstallProjectTemplateOperation op = new InstallProjectTemplateOperation(template, project, (IContainer)project, projectDescription, refProjects);
        return op;
    }

    protected abstract void postInstallTemplate(IProject var1, IProgressMonitor var2) throws Exception;

    public IProject getNewProject() {
        return this._newProject;
    }

    public String getWindowTitle() {
        return "New WOLips Project";
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(this.getWindowTitle());
    }

    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(WizardsPlugin.WOPROJECT_WIZARD_BANNER());
    }

    private static void openInNewWindow(IPerspectiveDescriptor desc) {
        block2: {
            try {
                PlatformUI.getWorkbench().openWorkbenchWindow(desc.getId(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot());
            }
            catch (WorkbenchException e) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) break block2;
                ErrorDialog.openError((Shell)window.getShell(), (String)WINDOW_PROBLEMS_TITLE, (String)e.getMessage(), (IStatus)e.getStatus());
            }
        }
    }

    public boolean performFinish() {
        this.createNewProject();
        if (this._newProject == null) {
            return false;
        }
        this.updatePerspective();
        this.selectAndReveal((IResource)this._newProject);
        return true;
    }

    private static void replaceCurrentPerspective(IPerspectiveDescriptor persp) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        page.setPerspective(persp);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this._configElement = cfig;
    }

    protected void updatePerspective() {
        NewWOProjectWizard.updatePerspective(this._configElement);
    }

    public static void updatePerspective(IConfigurationElement configElement) {
        int workbenchPerspectiveSetting;
        IWorkbenchWindow window;
        if (configElement == null) {
            return;
        }
        String perspSetting = PrefUtil.getAPIPreferenceStore().getString("PROJECT_OPEN_NEW_PERSPECTIVE");
        String promptSetting = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!promptSetting.equals("prompt") && perspSetting.equals("NO_NEW_PERSPECTIVE")) {
            return;
        }
        String finalPerspId = configElement.getAttribute(FINAL_PERSPECTIVE);
        if (finalPerspId == null) {
            return;
        }
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor finalPersp = reg.findPerspectiveWithId(finalPerspId);
        if (finalPersp != null && finalPersp instanceof IPluginContribution) {
            HashSet enabledIds;
            IWorkbenchActivitySupport workbenchActivitySupport;
            IActivityManager activityManager;
            IIdentifier identifier;
            Set idActivities;
            IPluginContribution contribution = (IPluginContribution)finalPersp;
            if (contribution.getPluginId() != null && !(idActivities = (identifier = (activityManager = (workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport()).getActivityManager()).getIdentifier(WorkbenchActivityHelper.createUnifiedId((IPluginContribution)contribution))).getActivityIds()).isEmpty() && (enabledIds = new HashSet(activityManager.getEnabledActivityIds())).addAll(idActivities)) {
                workbenchActivitySupport.setEnabledActivityIds(enabledIds);
            }
        } else {
            IDEWorkbenchPlugin.log((String)("Unable to find persective " + finalPerspId + " in BasicNewProjectResourceWizard.updatePerspective"));
            return;
        }
        ArrayList<String> preferredPerspIds = new ArrayList<String>();
        NewWOProjectWizard.addPerspectiveAndDescendants(preferredPerspIds, finalPerspId);
        String preferred = configElement.getAttribute(PREFERRED_PERSPECTIVES);
        if (preferred != null) {
            StringTokenizer tok = new StringTokenizer(preferred, " \t\n\r\f,");
            while (tok.hasMoreTokens()) {
                NewWOProjectWizard.addPerspectiveAndDescendants(preferredPerspIds, tok.nextToken());
            }
        }
        if ((window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            IPerspectiveDescriptor currentPersp;
            IWorkbenchPage page = window.getActivePage();
            if (page != null && (currentPersp = page.getPerspective()) != null && preferredPerspIds.contains(currentPersp.getId())) {
                return;
            }
            if (!NewWOProjectWizard.confirmPerspectiveSwitch(window, finalPersp)) {
                return;
            }
        }
        if ((workbenchPerspectiveSetting = WorkbenchPlugin.getDefault().getPreferenceStore().getInt("OPEN_PERSPECTIVE_MODE")) == 2) {
            NewWOProjectWizard.openInNewWindow(finalPersp);
            return;
        }
        NewWOProjectWizard.replaceCurrentPerspective(finalPersp);
    }

    private static void addPerspectiveAndDescendants(List<String> perspectiveIds, String id) {
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] perspectives = registry.getPerspectives();
        for (int i = 0; i < perspectives.length; ++i) {
            PerspectiveDescriptor descriptor = (PerspectiveDescriptor)perspectives[i];
            if (!descriptor.getOriginalId().equals(id)) continue;
            perspectiveIds.add(descriptor.getId());
        }
    }

    private static boolean confirmPerspectiveSwitch(IWorkbenchWindow window, IPerspectiveDescriptor finalPersp) {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String pspm = store.getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!"prompt".equals(pspm)) {
            return "always".equals(pspm);
        }
        String desc = finalPersp.getDescription();
        String message = desc == null || desc.length() == 0 ? NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessage, (Object)finalPersp.getLabel()) : NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessageWithDesc, (Object[])new String[]{finalPersp.getLabel(), desc});
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)ResourceMessages.NewProject_perspSwitchTitle, (String)message, null, (boolean)false, (IPreferenceStore)store, (String)"SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        int result = dialog.getReturnCode();
        if (dialog.getToggleState()) {
            String preferenceValue = result == 2 ? "OPEN_PERSPECTIVE_REPLACE" : "NO_NEW_PERSPECTIVE";
            PrefUtil.getAPIPreferenceStore().setValue("PROJECT_OPEN_NEW_PERSPECTIVE", preferenceValue);
        }
        return result == 2;
    }

    protected void addComponentDefinition(String templateFolder, TemplateEngine engine, String path, String name) {
        this.addMavenComponentDefinition(templateFolder, engine, path, name, "");
    }

    protected void addMavenComponentDefinition(String templateFolder, TemplateEngine engine, String rootPath, String name, String packagePath) {
        String componentPath = rootPath + File.separator + name + ".wo";
        File wo = new File(componentPath);
        wo.mkdirs();
        String fullPackagePath = packagePath != null && packagePath.length() > 0 ? rootPath + File.separator + "src" + File.separator + packagePath : rootPath + File.separator + "src";
        File srcPath = new File(fullPackagePath);
        srcPath.mkdirs();
        engine.addTemplate(new TemplateDefinition(templateFolder + "/" + name + ".html.vm", componentPath, name + ".html", name + ".html"));
        engine.addTemplate(new TemplateDefinition(templateFolder + "/" + name + ".wod.vm", componentPath, name + ".wod", name + ".wod"));
        engine.addTemplate(new TemplateDefinition(templateFolder + "/" + name + ".woo.vm", componentPath, name + ".woo", name + ".woo"));
        engine.addTemplate(new TemplateDefinition(templateFolder + "/" + name + ".api.vm", rootPath, name + ".api", name + ".api"));
        engine.addTemplate(new TemplateDefinition(templateFolder + "/" + name + ".java.vm", fullPackagePath, name + ".java", name + ".java"));
    }

    protected D2WApplicationConfigurationPage.D2WLook currentD2WLook() {
        if (this._d2wConfigurationPage == null) {
            return D2WApplicationConfigurationPage.D2WLook.BASIC54;
        }
        return this._d2wConfigurationPage.currentLook();
    }

    public void createWebServicesSupport(IProject project, TemplateEngine engine) {
        String path = null;
        path = this.getWizardType() == WizardType.WOMAVENPROJECT ? project.getLocation().append("src/main/resources").toOSString() : project.getLocation().toOSString();
        if (this._webservicesSupportPage != null) {
            if (this._webservicesSupportPage.getClientSupport()) {
                engine.addTemplate(new TemplateDefinition("wowebservices/client.wsdd.vm", path, "client.wsdd", "client.wsdd"));
            }
            if (this._webservicesSupportPage.getServerSupport()) {
                engine.addTemplate(new TemplateDefinition("wowebservices/server.wsdd.vm", path, "server.wsdd", "server.wsdd"));
            }
        }
    }

    public void createJavaPackageSupport(IProject project, String packagePath) {
        String fullPath = project.getLocation().toOSString() + File.separator + "src";
        if (packagePath.length() > 0) {
            fullPath = fullPath + File.separator + packagePath;
        }
        File pFile = new File(fullPath);
        pFile.mkdirs();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InstallProjectTemplateOperation
    extends InstallTemplateOperation {
        private IProjectDescription _projectDescription;
        private IProject[] _refProjects;

        public InstallProjectTemplateOperation(ProjectTemplate template, IProject project, IContainer targetContainer, IProjectDescription projectDescription, IProject[] refProjects) {
            super(template, project, targetContainer);
            this._projectDescription = projectDescription;
            this._refProjects = refProjects;
        }

        public InstallProjectTemplateOperation(ProjectTemplate template, IProject project, IContainer targetContainer, ISchedulingRule rule, IProjectDescription projectDescription, IProject[] refProjects) {
            super(template, project, targetContainer, rule);
            this._projectDescription = projectDescription;
            this._refProjects = refProjects;
        }

        protected void preInstallTemplate(IProgressMonitor monitor) throws Exception {
            IProject project = this.getProject();
            project.create(this._projectDescription, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }

        protected void postInstallTemplate(IProgressMonitor monitor) throws Exception {
            NewWOProjectWizard.this.postInstallTemplate(this.getProject(), monitor);
        }

        protected void finishInstallTemplate(IProgressMonitor monitor) throws Exception {
            IProject project = this.getProject();
            project.close((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            this.createEOModelSupport();
            this.createFrameworksSupport();
            this.addWebServiceFrameworks();
            if (this._refProjects != null && this._refProjects.length > 0) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                LinkedList<IClasspathEntry> classpathEntries = new LinkedList<IClasspathEntry>();
                for (IClasspathEntry iClasspathEntry : javaProject.getRawClasspath()) {
                    classpathEntries.add(iClasspathEntry);
                }
                for (IClasspathEntry iClasspathEntry : this._refProjects) {
                    IEclipseFramework.Utility.addProjectToProject((IProject)iClasspathEntry, (IJavaProject)javaProject, classpathEntries);
                }
                javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), monitor);
            }
        }

        protected HashMap<String, String> getEOModelPaths() {
            if (NewWOProjectWizard.this._eomodelImportPage == null) {
                return new HashMap<String, String>();
            }
            return NewWOProjectWizard.this._eomodelImportPage.getModelPaths();
        }

        protected void createEOModelSupport() {
            if (NewWOProjectWizard.this.getWizardType() != WizardType.WOMAVENPROJECT) {
                HashMap<String, String> paths = this.getEOModelPaths();
                EOModelImportWorkspaceJob job = new EOModelImportWorkspaceJob("eomodel import", paths, this.getProject(), null);
                job.schedule();
            } else {
                HashMap<String, String> paths = this.getEOModelPaths();
                EOModelImportWorkspaceJob job = new EOModelImportWorkspaceJob("eomodel import", paths, this.getProject(), this.getProject().getLocation().append("src/main/resources").toOSString());
                job.schedule();
            }
        }

        protected void createFrameworksSupport() {
            if (NewWOProjectWizard.this.getWizardType() != WizardType.WOMAVENPROJECT) {
                try {
                    LinkedList<String> newFrameworks = new LinkedList<String>();
                    if (NewWOProjectWizard.this._frameworkSupportPage != null) {
                        if (NewWOProjectWizard.this._frameworkSupportPage.getJNDISupport()) {
                            newFrameworks.add("JavaJNDIAdaptor");
                        }
                        if (NewWOProjectWizard.this._frameworkSupportPage.getJ2EESupport()) {
                            newFrameworks.add("JavaWOJSPServlet");
                        }
                    }
                    ((ProjectFrameworkAdapter)this.getProject().getAdapter(ProjectFrameworkAdapter.class)).addFrameworksNamed(newFrameworks);
                }
                catch (Exception e) {
                    WizardsPlugin.getDefault().log(e);
                    ErrorDialog.openError((Shell)NewWOProjectWizard.this.getShell(), (String)Messages.getString("NewWOProjectWizard.errorMessage.classpath.title"), (String)Messages.getString("NewWOProjectWizard.errorMessage.classpath.message"), (IStatus)new Status(2, "org.objectstyle.wolips.wizards", Messages.getString("NewWOProjectWizard.errorMessage.classpath.message")));
                }
            }
        }

        protected void addWebServiceFrameworks() {
            if (NewWOProjectWizard.this.getWizardType() != WizardType.WOMAVENPROJECT) {
                try {
                    LinkedList<String> newFrameworks = new LinkedList<String>();
                    if (NewWOProjectWizard.this._webservicesSupportPage != null) {
                        if (NewWOProjectWizard.this._webservicesSupportPage.getClientSupport()) {
                            newFrameworks.add("JavaWebServicesClient");
                        }
                        if (NewWOProjectWizard.this._webservicesSupportPage.getServerSupport()) {
                            newFrameworks.add("JavaWebServicesGeneration");
                        }
                        if (NewWOProjectWizard.this._webservicesSupportPage.getServerSupport() || NewWOProjectWizard.this._webservicesSupportPage.getClientSupport()) {
                            newFrameworks.add("JavaWebServicesSupport");
                        }
                    }
                    ((ProjectFrameworkAdapter)this.getProject().getAdapter(ProjectFrameworkAdapter.class)).addFrameworksNamed(newFrameworks);
                }
                catch (Exception e) {
                    WizardsPlugin.getDefault().log(e);
                    ErrorDialog.openError((Shell)NewWOProjectWizard.this.getShell(), (String)Messages.getString("NewWOProjectWizard.errorMessage.classpath.title"), (String)Messages.getString("NewWOProjectWizard.errorMessage.classpath.message"), (IStatus)new Status(2, "org.objectstyle.wolips.wizards", Messages.getString("NewWOProjectWizard.errorMessage.classpath.message")));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WizardType {
        WO_APPLICATION_WIZARD,
        D2W_APPLICATION_WIZARD,
        D2JC_APPLICATION_WIZARD,
        D2WS_APPLICATION_WIZARD,
        JARPROJECT_WIZARD,
        WO_FRAMEWORK_WIZARD,
        WONDER_APPLICATION_WIZARD,
        WONDER_D2W_APPLICATION_WIZARD,
        WONDER_FRAMEWORK_WIZARD,
        NEWPROJ_TEMPLATE_WIZARD,
        WOMAVENPROJECT,
        ERREST_APPLICATION_WIZARD;

    }
}

