/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashMap;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EOModelImportSupport {
    public static void importEOModelsToProject(HashMap<String, String> paths, IProject project) throws IOException {
        File path = project.getLocation().toFile();
        File resourcesPath = new File(path, "Resources");
        if (resourcesPath.exists()) {
            path = resourcesPath;
        }
        File destFile = null;
        for (String aFileName : paths.keySet()) {
            File aFile = new File(paths.get(aFileName.trim()));
            destFile = new File(path, aFileName);
            IFolder existingModelFolder = project.getFolder((IPath)new Path(destFile.getAbsolutePath()));
            if (existingModelFolder.exists()) {
                ErrorDialog.openError((Shell)new Shell(), (String)"EOModel Exists", (String)(existingModelFolder.getFullPath().toOSString() + " already exists."), (IStatus)new Status(4, "org.objectstyle.wolips.wizards", existingModelFolder.getFullPath().toOSString() + " already exists."));
                continue;
            }
            if (!aFile.exists()) continue;
            destFile.mkdirs();
            EOModelImportSupport.copyDirectoryFilesToDirectory(aFile, destFile, project);
        }
    }

    public static void importEOModelsToProject(HashMap<String, String> paths, IProject project, String dstPath) throws IOException {
        File path = null;
        if (dstPath == null) {
            path = project.getLocation().toFile();
            File resourcesPath = new File(path, "Resources");
            if (resourcesPath.exists()) {
                path = resourcesPath;
            }
        } else {
            path = new File(dstPath);
        }
        File destFile = null;
        for (String aFileName : paths.keySet()) {
            File aFile = new File(paths.get(aFileName.trim()));
            destFile = new File(path, aFileName);
            IFolder existingModelFolder = project.getFolder((IPath)new Path(destFile.getAbsolutePath()));
            if (existingModelFolder.exists()) {
                ErrorDialog.openError((Shell)new Shell(), (String)"EOModel Exists", (String)(existingModelFolder.getFullPath().toOSString() + " already exists."), (IStatus)new Status(4, "org.objectstyle.wolips.wizards", existingModelFolder.getFullPath().toOSString() + " already exists."));
                continue;
            }
            if (!aFile.exists()) continue;
            destFile.mkdirs();
            EOModelImportSupport.copyDirectoryFilesToDirectory(aFile, destFile, project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst, IProject project) throws IOException {
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        ByteBuffer buffer = null;
        try {
            in = new FileInputStream(src).getChannel();
            try {
                out = new FileOutputStream(dst).getChannel();
                buffer = ByteBuffer.allocate(1024);
                while (in.read(buffer) != -1) {
                    buffer.flip();
                    ((FileChannel)out).write(buffer);
                    buffer.clear();
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            project.getFile(dst.getCanonicalPath());
        }
    }

    public static void copyDirectoryFilesToDirectory(File srcRootFile, File dstRootFile, IProject project) throws IOException {
        File[] children;
        for (File child : children = srcRootFile.listFiles()) {
            if (!child.isFile()) continue;
            EOModelImportSupport.copyFile(child, new File(dstRootFile, child.getName()), project);
            project.getFolder(new File(dstRootFile, child.getName()).getCanonicalPath());
        }
    }
}

