/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.ant;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.objectstyle.wolips.ant.antlaunchers.IAntlauncher;
import org.objectstyle.wolips.ant.antlaunchers.internal.AntlauncherWrapper;
import org.objectstyle.wolips.baseforplugins.AbstractBaseActivator;
import org.osgi.framework.BundleContext;

public class AntPlugin
extends AbstractBaseActivator
implements IAntlauncher {
    private static AntPlugin plugin;
    private AntlauncherWrapper[] antlauncherWrapper;
    private static final String EXTENSION_POINT_ID = "org.objectstyle.wolips.ant.antlaunchers";

    public AntPlugin() {
        plugin = this;
    }

    public static AntPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    private void loadAntlauncherExtensionPoint() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        ArrayList<AntlauncherWrapper> arrayList = new ArrayList<AntlauncherWrapper>();
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement[] configurationElements = extensions[i].getConfigurationElements();
            for (int j = 0; j < configurationElements.length; ++j) {
                IConfigurationElement configurationElement = configurationElements[j];
                IAntlauncher currentAntlauncher = null;
                try {
                    currentAntlauncher = (IAntlauncher)configurationElement.createExecutableExtension("class");
                    String name = configurationElement.getAttribute("name");
                    arrayList.add(new AntlauncherWrapper(currentAntlauncher, name));
                    continue;
                }
                catch (CoreException e) {
                    this.log("Could not create executable from configuration element: " + configurationElement, e);
                }
            }
        }
        this.antlauncherWrapper = arrayList.toArray(new AntlauncherWrapper[arrayList.size()]);
    }

    public AntlauncherWrapper[] getAntlauncherWrapper() {
        if (this.antlauncherWrapper == null) {
            this.loadAntlauncherExtensionPoint();
        }
        ArrayList<AntlauncherWrapper> antlauncherWrapperList = new ArrayList<AntlauncherWrapper>();
        for (int i = 0; i < this.antlauncherWrapper.length; ++i) {
            AntlauncherWrapper currentAntlauncherWrapper = this.antlauncherWrapper[i];
            antlauncherWrapperList.add(currentAntlauncherWrapper);
        }
        return antlauncherWrapperList.toArray(new AntlauncherWrapper[antlauncherWrapperList.size()]);
    }

    public void launchAntInExternalVM(IFile buildFile, IProgressMonitor monitor, boolean captureOutput, String targets) throws CoreException {
        this.getAntlauncherWrapper()[0].getAntlauncher().launchAntInExternalVM(buildFile, monitor, captureOutput, targets);
    }
}

