/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.resources.internal.build;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.objectstyle.wolips.core.CorePlugin;
import org.objectstyle.wolips.core.resources.builder.AbstractOldBuilder;
import org.objectstyle.wolips.core.resources.internal.build.BuilderWrapper;
import org.objectstyle.wolips.core.resources.internal.build.FullBuildDeltaVisitor;
import org.objectstyle.wolips.core.resources.internal.build.IncrementalBuildDeltaVisitor;
import org.objectstyle.wolips.core.resources.types.folder.IBuildAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IProductAdapter;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;

public abstract class Builder
extends IncrementalProjectBuilder {
    protected static final String INCREMENTAL_BUILDER_ID = "org.objectstyle.wolips.incrementalbuilder";
    protected static final String ANT_BUILDER_ID = "org.objectstyle.wolips.antbuilder";
    private BuilderWrapper[] builderWrappers = CorePlugin.getDefault().getBuilderWrapper(this.getContextName());

    public abstract String getContextName();

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IBuildAdapter buildAdapter;
        IProject project = this.getProject();
        ProjectAdapter projectAdapter = (ProjectAdapter)project.getAdapter(ProjectAdapter.class);
        if (projectAdapter != null && (buildAdapter = projectAdapter.getBuildAdapter()) != null) {
            buildAdapter.clean(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProductAdapter productAdapter;
        IProject project = this.getProject();
        ProjectAdapter projectAdapter = (ProjectAdapter)project.getAdapter(ProjectAdapter.class);
        IBuildAdapter buildAdapter = null;
        if (projectAdapter != null) {
            buildAdapter = projectAdapter.getBuildAdapter();
        }
        if (kind == 6) {
            this.clean(monitor);
        }
        HashMap buildCache = new HashMap();
        FullBuildDeltaVisitor fullBuildDeltaVisitor = null;
        IncrementalBuildDeltaVisitor deltaVisitor = null;
        if (kind == 6) {
            fullBuildDeltaVisitor = new FullBuildDeltaVisitor(this.builderWrappers, monitor, buildCache);
        } else {
            deltaVisitor = new IncrementalBuildDeltaVisitor(this.builderWrappers, monitor, buildCache);
        }
        IResourceDelta projectDelta = this.getDelta(project);
        try {
            this.invokeOldBuilder(kind, args, monitor, projectDelta);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.objectstyle.wolips.core", e.getMessage(), (Throwable)e));
        }
        boolean fullBuild = this.notifyBuilderBuildStarted(kind, args, monitor, buildCache);
        if (fullBuild && kind != 6 && kind != 15) {
            System.out.println("Builder.build: this should trigger a full build at some point");
            project.build(6, null);
        }
        try {
            if (fullBuildDeltaVisitor != null) {
                fullBuildDeltaVisitor.buildStarted(project);
                project.accept((IResourceVisitor)fullBuildDeltaVisitor);
            }
            if (deltaVisitor != null && projectDelta != null) {
                deltaVisitor.buildStarted(project);
                projectDelta.accept((IResourceDeltaVisitor)deltaVisitor);
            }
        }
        finally {
            this.notifyBuildPreparationDone(kind, args, monitor, buildCache);
            if (fullBuildDeltaVisitor != null) {
                fullBuildDeltaVisitor.visitingDone();
            }
            if (deltaVisitor != null) {
                deltaVisitor.visitingDone();
            }
        }
        if (buildAdapter != null) {
            buildAdapter.markAsDerivated(monitor);
        } else if (projectAdapter != null && (productAdapter = projectAdapter.getProductAdapter()) != null) {
            productAdapter.markAsDerivated(monitor);
        }
        final IProject workspaceRunnableProject = project;
        IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor runInWorkspaceMonitor) throws CoreException {
                workspaceRunnableProject.refreshLocal(1, runInWorkspaceMonitor);
                IFolder buildFolder = workspaceRunnableProject.getFolder("build");
                if (buildFolder.exists()) {
                    buildFolder.refreshLocal(1, runInWorkspaceMonitor);
                    try {
                        IFile buildVersion = buildFolder.getFile(".version");
                        ByteArrayInputStream versionInputStream = new ByteArrayInputStream(String.valueOf(System.currentTimeMillis()).getBytes());
                        if (buildVersion.exists()) {
                            buildVersion.setContents((InputStream)versionInputStream, 1025, runInWorkspaceMonitor);
                        } else {
                            buildVersion.create((InputStream)versionInputStream, 1025, runInWorkspaceMonitor);
                        }
                    }
                    catch (Throwable t) {
                        CorePlugin.getDefault().log(t);
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(workspaceRunnable, (ISchedulingRule)workspaceRunnableProject, 0, (IProgressMonitor)null);
        return null;
    }

    private void invokeOldBuilder(int kind, Map args, IProgressMonitor monitor, IResourceDelta delta) throws Exception {
        for (int i = 0; i < this.builderWrappers.length; ++i) {
            boolean isOldBuilder;
            if (!this.builderWrappers[i].getBuilder().isEnabled() || !(isOldBuilder = this.builderWrappers[i].isOldBuilder())) continue;
            AbstractOldBuilder abstractOldBuilder = (AbstractOldBuilder)this.builderWrappers[i].getBuilder();
            abstractOldBuilder.setProject(this.getProject());
            abstractOldBuilder.invokeOldBuilder(kind, args, monitor, delta);
        }
    }

    private boolean notifyBuilderBuildStarted(int kind, Map args, IProgressMonitor monitor, Map buildCache) {
        boolean fullBuild = false;
        for (int i = 0; i < this.builderWrappers.length; ++i) {
            if (!this.builderWrappers[i].getBuilder().isEnabled()) continue;
            fullBuild |= this.builderWrappers[i].getBuilder().buildStarted(kind, args, monitor, this.getProject(), buildCache);
        }
        return fullBuild;
    }

    private void notifyBuildPreparationDone(int kind, Map args, IProgressMonitor monitor, Map buildCache) {
        for (int i = 0; i < this.builderWrappers.length; ++i) {
            if (!this.builderWrappers[i].getBuilder().isEnabled()) continue;
            this.builderWrappers[i].getBuilder().buildPreparationDone(kind, args, monitor, this.getProject(), buildCache);
        }
    }
}

