/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.resources.internal.types.folder;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.objectstyle.wolips.core.CorePlugin;
import org.objectstyle.wolips.core.resources.internal.types.AbstractResourceAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IFolderAdapter;

public abstract class AbstractFolderAdapter
extends AbstractResourceAdapter
implements IFolderAdapter {
    private IFolder folder;

    public AbstractFolderAdapter(IFolder folder) {
        super((IResource)folder);
        this.folder = folder;
    }

    public IFolder getUnderlyingFolder() {
        return this.folder;
    }

    private void createFolder(IFolder f, IProgressMonitor m) throws CoreException {
        if (f.exists()) {
            return;
        }
        IContainer parent = f.getParent();
        if (!f.getParent().exists() && parent instanceof IFolder) {
            this.createFolder((IFolder)parent, m);
        }
        f.create(true, true, m);
    }

    public IResource copy(IResource resource) throws CoreException {
        IPath projectRelativePath = resource.getProjectRelativePath();
        IPath thisPath = this.getUnderlyingFolder().getFullPath();
        IPath destination = thisPath.append(projectRelativePath);
        IFile returnValue = null;
        if (resource.getType() == 1) {
            returnValue = ResourcesPlugin.getWorkspace().getRoot().getFile(destination);
            this.createFolder((IFolder)returnValue.getParent(), null);
        } else {
            returnValue = ResourcesPlugin.getWorkspace().getRoot().getFolder(destination);
            ((IFolder)returnValue).create(true, true, null);
            this.createFolder((IFolder)returnValue, null);
        }
        resource.copy(destination, true, null);
        return ResourcesPlugin.getWorkspace().getRoot().findMember(destination);
    }

    public void deleteCopy(IResource resource) throws CoreException {
        IPath projectRelativePath = resource.getProjectRelativePath();
        IPath thisPath = this.getUnderlyingFolder().getFullPath();
        IPath destination = thisPath.append(projectRelativePath);
        IResource deleteResource = ResourcesPlugin.getWorkspace().getRoot().findMember(destination);
        if (deleteResource != null && deleteResource.exists()) {
            deleteResource.delete(true, null);
        }
    }

    public void markAsDerivated(IProgressMonitor monitor) {
        try {
            this.markAsDerivated(this.getUnderlyingFolder(), monitor);
        }
        catch (CoreException e) {
            CorePlugin.getDefault().log(e);
        }
    }

    public void markAsDerivated(IFolder folderToMarkAsDerivated, IProgressMonitor monitor) throws CoreException {
        if (!folderToMarkAsDerivated.exists()) {
            return;
        }
        folderToMarkAsDerivated.setDerived(true);
        IResource[] members = folderToMarkAsDerivated.members();
        for (int i = 0; i < members.length; ++i) {
            IResource member = members[i];
            if (member instanceof IFolder) {
                this.markAsDerivated((IFolder)member, monitor);
                continue;
            }
            if (!member.exists()) continue;
            member.setDerived(true);
        }
    }
}

