/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.resources.internal.types.folder;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.objectstyle.wolips.baseforplugins.util.WOLipsNatureUtils;
import org.objectstyle.wolips.core.resources.internal.types.AbstractResourceAdapterFactory;
import org.objectstyle.wolips.core.resources.internal.types.folder.BuildAdapter;
import org.objectstyle.wolips.core.resources.internal.types.folder.ContentsAdapter;
import org.objectstyle.wolips.core.resources.internal.types.folder.DotApplicationAdapter;
import org.objectstyle.wolips.core.resources.internal.types.folder.DotEOModeldAdapter;
import org.objectstyle.wolips.core.resources.internal.types.folder.DotFrameworkAdapter;
import org.objectstyle.wolips.core.resources.internal.types.folder.DotLprojAdapter;
import org.objectstyle.wolips.core.resources.internal.types.folder.DotSubprojAdapter;
import org.objectstyle.wolips.core.resources.internal.types.folder.DotWoAdapter;
import org.objectstyle.wolips.core.resources.internal.types.folder.ResourcesAdapter;
import org.objectstyle.wolips.core.resources.internal.types.folder.WebServerResourcesAdapter;
import org.objectstyle.wolips.core.resources.internal.types.folder.WoprojectAdapter;
import org.objectstyle.wolips.core.resources.types.IResourceType;
import org.objectstyle.wolips.core.resources.types.folder.IBuildAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IContentsAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IDotApplicationAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IDotEOModeldAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IDotFrameworkAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IDotLprojAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IDotSubprojAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IDotWoAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IResourcesAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IWebServerResourcesAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IWoprojectAdapter;

public class FolderAdapterFactory
extends AbstractResourceAdapterFactory {
    private Class[] adapterList = new Class[]{IDotApplicationAdapter.class, IDotFrameworkAdapter.class, IDotLprojAdapter.class, IDotSubprojAdapter.class, IDotWoAdapter.class, IWoprojectAdapter.class};

    public Class[] getAdapterList() {
        return this.adapterList;
    }

    public boolean isSupported(Object adaptableObject, Class adapterType) {
        if (!(adaptableObject instanceof IFolder)) {
            return false;
        }
        if (adapterType == IBuildAdapter.class) {
            return true;
        }
        if (adapterType == IContentsAdapter.class) {
            return true;
        }
        if (adapterType == IResourcesAdapter.class) {
            return true;
        }
        if (adapterType == IWebServerResourcesAdapter.class) {
            return true;
        }
        if (adapterType == IDotApplicationAdapter.class) {
            return true;
        }
        if (adapterType == IDotFrameworkAdapter.class) {
            return true;
        }
        if (adapterType == IDotLprojAdapter.class) {
            return true;
        }
        if (adapterType == IDotSubprojAdapter.class) {
            return true;
        }
        if (adapterType == IDotWoAdapter.class) {
            return true;
        }
        if (adapterType == IDotEOModeldAdapter.class) {
            return true;
        }
        return adapterType == IWoprojectAdapter.class;
    }

    public IResourceType createAdapter(Object adaptableObject, Class adapterType) {
        IFolder folder = (IFolder)adaptableObject;
        IProject project = folder.getProject();
        if (!WOLipsNatureUtils.isWOLipsNature((IProject)project)) {
            return null;
        }
        if (adapterType == IBuildAdapter.class) {
            if (folder.getName() != null && ("build".equals(folder.getName()) || "dist".equals(folder.getName()))) {
                return new BuildAdapter(folder);
            }
        } else if (adapterType == IContentsAdapter.class) {
            if (folder.getName() != null && "Contents".equals(folder.getName())) {
                return new ContentsAdapter(folder);
            }
        } else if (adapterType == IResourcesAdapter.class) {
            if (folder.getName() != null && "Resources".equals(folder.getName())) {
                return new ResourcesAdapter(folder);
            }
        } else if (adapterType == IWebServerResourcesAdapter.class) {
            if (folder.getName() != null && "WebServerResources".equals(folder.getName())) {
                return new WebServerResourcesAdapter(folder);
            }
        } else if (adapterType == IDotApplicationAdapter.class) {
            if (folder.getFileExtension() != null && "woa".equals(folder.getFileExtension())) {
                return new DotApplicationAdapter(folder);
            }
        } else if (adapterType == IDotFrameworkAdapter.class) {
            if (folder.getFileExtension() != null && "framework".equals(folder.getFileExtension())) {
                return new DotFrameworkAdapter(folder);
            }
        } else if (adapterType == IDotSubprojAdapter.class) {
            if (folder.getFileExtension() != null && "subproj".equals(folder.getFileExtension())) {
                return new DotSubprojAdapter(folder);
            }
        } else if (adapterType == IDotLprojAdapter.class) {
            if (folder.getFileExtension() != null && "lproj".equals(folder.getFileExtension())) {
                return new DotLprojAdapter(folder);
            }
        } else if (adapterType == IDotWoAdapter.class) {
            if (folder.getFileExtension() != null && "wo".equals(folder.getFileExtension())) {
                return new DotWoAdapter(folder);
            }
        } else if (adapterType == IDotEOModeldAdapter.class) {
            if (folder.getFileExtension() != null && "eomodeld".equals(folder.getFileExtension())) {
                return new DotEOModeldAdapter(folder);
            }
        } else if (adapterType == IWoprojectAdapter.class && folder.getFileExtension() == null && folder.getName() != null && folder.getParent() != null && folder.getParent().getType() == 4 && ("woproject".equals(folder.getName()) || "ant".equals(folder.getName()))) {
            return new WoprojectAdapter(folder);
        }
        return null;
    }
}

