/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.builder.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.objectstyle.wolips.builder.internal.DefaultDeltaVisitor;
import org.objectstyle.wolips.core.resources.types.project.IProjectPatternsets;

public class PatternsetDeltaVisitor
extends DefaultDeltaVisitor {
    private boolean _fullBuildRequired;
    private boolean _needsFurtherInvestigation = true;

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (!this._needsFurtherInvestigation) {
            return false;
        }
        if (!super.visit(delta)) {
            return false;
        }
        IResource resource = delta.getResource();
        if (resource.getType() == 4) {
            return true;
        }
        if (resource.getType() == 2 && "woproject".equals(resource.getName())) {
            return true;
        }
        if ("patternset".equals(resource.getFileExtension())) {
            IProject iProject = resource.getProject();
            IProjectPatternsets project = (IProjectPatternsets)iProject.getAdapter(IProjectPatternsets.class);
            project.releasePatternsetCache();
            this._needsFurtherInvestigation = false;
            this._fullBuildRequired = true;
            return false;
        }
        return false;
    }

    public boolean isFullBuildRequired() {
        return this._fullBuildRequired;
    }

    public void reset() {
        this._needsFurtherInvestigation = true;
        this._fullBuildRequired = false;
    }
}

