/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.builder.internal;

import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.objectstyle.wolips.baseforplugins.AbstractBaseActivator;
import org.objectstyle.wolips.builder.BuilderPlugin;
import org.objectstyle.wolips.builder.internal.AbstractIncrementalProjectBuilder;
import org.objectstyle.wolips.builder.internal.BuildVisitor;
import org.objectstyle.wolips.builder.internal.JarBuilder;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;
import org.objectstyle.wolips.preferences.Preferences;
import org.objectstyle.wolips.templateengine.ProjectInput;
import org.objectstyle.wolips.templateengine.ProjectTemplate;
import org.objectstyle.wolips.variables.BuildProperties;

public class WOIncrementalBuilder
extends AbstractIncrementalProjectBuilder {
    private BuildVisitor _buildVisitor;
    private JarBuilder _jarBuilder;

    public boolean isEnabled() {
        return true;
    }

    private String getArg(Map values, String key, String defVal) {
        String result = null;
        try {
            result = (String)values.get(key);
        }
        catch (Exception up) {
            this.getLogger().log((Throwable)up);
        }
        if (null == result) {
            result = defVal;
        }
        return result;
    }

    public void invokeOldBuilder(int kind, Map args, IProgressMonitor progressMonitor, IResourceDelta resourceDelta) throws Exception {
        if (!Preferences.mockBundleEnabled()) {
            return;
        }
        Object subProgressMonitor = null;
        subProgressMonitor = null == progressMonitor ? new NullProgressMonitor() : new SubProgressMonitor(progressMonitor, 100000);
        IResourceDelta delta = resourceDelta;
        if (kind != 6 && kind != 15 && !this.projectNeedsAnUpdate(delta)) {
            subProgressMonitor.done();
            return;
        }
        this.getLogger().debug((Object)"<incremental build>");
        subProgressMonitor.beginTask("building WebObjects layout ...", 100);
        try {
            BuildProperties buildProperties;
            String principalClass;
            ProjectAdapter project = (ProjectAdapter)this.getProject().getAdapter(ProjectAdapter.class);
            boolean fullBuild = kind == 6 || kind == 15 || this.patternsetDeltaVisitor().isFullBuildRequired();
            String oldPrincipalClass = this.getArg(args, "nsprincipalclass", "");
            if (oldPrincipalClass.length() == 0) {
                oldPrincipalClass = null;
            }
            if ((principalClass = (buildProperties = project.getBuildProperties()).getPrincipalClass(true)) == null && oldPrincipalClass != null) {
                principalClass = oldPrincipalClass;
                buildProperties.setPrincipalClass(principalClass);
            }
            if (buildProperties.getWOVersion().isAtLeastVersion(5, 6)) {
                IFolder infoPListContainer = this.getProject().getFolder("woproject");
                this.createInfoPlist((IContainer)infoPListContainer);
            } else {
                long t0;
                if (this._buildVisitor == null) {
                    this._buildVisitor = new BuildVisitor();
                }
                this._buildVisitor.reinitForNextBuild(this.getProject());
                if (!fullBuild) {
                    subProgressMonitor.subTask("checking directory structure ...");
                    if (!this._buildVisitor._checkDirs()) {
                        delta = null;
                        subProgressMonitor.worked(5);
                    }
                } else {
                    delta = null;
                    long t02 = System.currentTimeMillis();
                    IFolder buildFolder = this.getProject().getFolder("build");
                    subProgressMonitor.subTask("scrubbing build folder ...");
                    buildFolder.refreshLocal(2, null);
                    subProgressMonitor.worked(1);
                    this.getLogger().debug((Object)("refresh build folder took: " + (System.currentTimeMillis() - t02) + " ms"));
                    t02 = System.currentTimeMillis();
                    buildFolder.delete(true, false, null);
                    subProgressMonitor.worked(2);
                    this.getLogger().debug((Object)("scrubbing build folder took: " + (System.currentTimeMillis() - t02) + " ms"));
                    t02 = System.currentTimeMillis();
                    buildFolder.refreshLocal(2, null);
                    subProgressMonitor.subTask("re-creating structure ...");
                    this._buildVisitor._checkDirs();
                    subProgressMonitor.worked(2);
                    this.getLogger().debug((Object)("re-creating build folder took: " + (System.currentTimeMillis() - t02) + " ms"));
                }
                subProgressMonitor.subTask("creating Info.plist");
                IFolder infoPListContainer = this.getProject().getWorkspace().getRoot().getFolder(this._buildVisitor.getInfoPath());
                this.createInfoPlist((IContainer)infoPListContainer);
                subProgressMonitor.worked(1);
                if (null != delta) {
                    this.getLogger().debug((Object)"<partial build>");
                    subProgressMonitor.subTask("preparing partial build");
                    t0 = System.currentTimeMillis();
                    this._buildVisitor.resetCount();
                    delta.accept((IResourceDeltaVisitor)this._buildVisitor, 31);
                    this.getLogger().debug((Object)("delta.accept with " + this._buildVisitor.getCount() + " delta nodes took: " + (System.currentTimeMillis() - t0) + " ms"));
                    this.getLogger().debug((Object)"</partial build>");
                    subProgressMonitor.worked(12);
                } else {
                    this.getLogger().debug((Object)"<full build>");
                    subProgressMonitor.subTask("preparing full build");
                    t0 = System.currentTimeMillis();
                    t0 = System.currentTimeMillis();
                    this._buildVisitor.resetCount();
                    this.getProject().accept((IResourceVisitor)this._buildVisitor);
                    this.getLogger().debug((Object)("preparing with " + this._buildVisitor.getCount() + " project nodes took: " + (System.currentTimeMillis() - t0) + " ms"));
                    this.getLogger().debug((Object)"</full build>");
                    subProgressMonitor.worked(12);
                }
                t0 = System.currentTimeMillis();
                this._buildVisitor.executeTasks((IProgressMonitor)subProgressMonitor);
                this.getLogger().debug((Object)("building structure took: " + (System.currentTimeMillis() - t0) + " ms"));
                t0 = System.currentTimeMillis();
                subProgressMonitor.subTask("copying classes");
                this.jarBuild(delta, (IProgressMonitor)subProgressMonitor, this.getProject());
                this.getLogger().debug((Object)("copying classes took: " + (System.currentTimeMillis() - t0) + " ms"));
                subProgressMonitor.done();
            }
        }
        catch (Exception up) {
            this.getLogger().log((Throwable)up);
            throw up;
        }
        this.getLogger().debug((Object)"</incremental build>");
    }

    protected void createInfoPlist(IContainer targetContainer) throws Exception {
        IProject project = this.getProject();
        ProjectAdapter projectAdapter = (ProjectAdapter)project.getAdapter(ProjectAdapter.class);
        ProjectTemplate infoPListTemplate = projectAdapter.isFramework() ? ProjectTemplate.loadProjectTemplateNamed((String)"MiscTemplates", (String)"FrameworkInfoPList") : ProjectTemplate.loadProjectTemplateNamed((String)"MiscTemplates", (String)"ApplicationInfoPList");
        infoPListTemplate.addInput(new ProjectInput("buildProperties", (Object)projectAdapter.getBuildProperties()));
        targetContainer.refreshLocal(0, null);
        infoPListTemplate.createProjectContents(project, targetContainer, (IProgressMonitor)new NullProgressMonitor());
        IFile infoPList = targetContainer.getFile((IPath)new Path("Info.plist"));
        infoPList.refreshLocal(0, null);
        infoPList.setDerived(true, null);
    }

    private AbstractBaseActivator getLogger() {
        return BuilderPlugin.getDefault();
    }

    private void jarBuild(IResourceDelta delta, IProgressMonitor monitor, IProject project) throws CoreException {
        this.getLogger().debug((Object)"<jar build>");
        if (this._jarBuilder == null) {
            this._jarBuilder = new JarBuilder();
        }
        this._jarBuilder.reinitForNextBuild(project);
        long t0 = System.currentTimeMillis();
        if (null != delta) {
            delta.accept((IResourceDeltaVisitor)this._jarBuilder, 31);
        } else {
            IPath outPath = this.getJavaProject().getOutputLocation();
            IProject output = this.getProject();
            if (!outPath.segment(0).equals(this.getProject().getName())) {
                output = this.getProject().getParent().getFolder(outPath);
            }
            output.accept((IResourceVisitor)this._jarBuilder);
        }
        this.getLogger().debug((Object)("prepare jar copy took " + (System.currentTimeMillis() - t0) + " ms"));
        monitor.worked(10);
        t0 = System.currentTimeMillis();
        this._jarBuilder.executeTasks(monitor);
        this.getLogger().debug((Object)("executing jar copy took " + (System.currentTimeMillis() - t0) + " ms"));
        this.getLogger().debug((Object)"</jar build>");
    }

    private IJavaProject getJavaProject() {
        try {
            return (IJavaProject)this.getProject().getNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException up) {
            this.getLogger().log((Throwable)up);
            return null;
        }
    }

    protected void startupOnInitialize() {
    }
}

