/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import java.math.BigDecimal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXValueUtilities {
    public static boolean isNull(Object obj) {
        return obj == null;
    }

    public static boolean booleanValue(Object obj) {
        return ERXValueUtilities.booleanValueWithDefault(obj, false);
    }

    public static boolean booleanValueWithDefault(Object obj, boolean def) {
        return ERXValueUtilities.isNull(obj) ? def : ERXValueUtilities.BooleanValueWithDefault(obj, def);
    }

    public static Boolean BooleanValueWithDefault(Object obj, Boolean def) {
        Boolean flag = def;
        if (!ERXValueUtilities.isNull(obj)) {
            if (obj instanceof Number) {
                flag = ((Number)obj).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
            } else if (obj instanceof String) {
                String strValue = ((String)obj).trim();
                if (strValue.length() > 0) {
                    if (strValue.equalsIgnoreCase("no") || strValue.equalsIgnoreCase("false") || strValue.equalsIgnoreCase("n")) {
                        flag = Boolean.FALSE;
                    } else if (strValue.equalsIgnoreCase("yes") || strValue.equalsIgnoreCase("true") || strValue.equalsIgnoreCase("y")) {
                        flag = Boolean.TRUE;
                    } else {
                        try {
                            if (Integer.parseInt(strValue) == 0) {
                                flag = Boolean.FALSE;
                            }
                            flag = Boolean.TRUE;
                        }
                        catch (NumberFormatException numberformatexception) {
                            throw new IllegalArgumentException("Failed to parse a boolean from the value '" + strValue + "'.");
                        }
                    }
                }
            } else if (obj instanceof Boolean) {
                flag = (Boolean)obj;
            } else {
                throw new IllegalArgumentException("Failed to parse a boolean from the value '" + obj + "'.");
            }
        }
        return flag;
    }

    public static int intValue(Object obj) {
        return ERXValueUtilities.intValueWithDefault(obj, 0);
    }

    public static int intValueWithDefault(Object obj, int def) {
        return ERXValueUtilities.isNull(obj) ? def : ERXValueUtilities.IntegerValueWithDefault(obj, def);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Integer IntegerValueWithDefault(Object obj, Integer def) {
        Integer value = def;
        if (ERXValueUtilities.isNull(obj)) return def;
        if (obj instanceof Integer) {
            return (int)((Integer)obj);
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof String) {
            try {
                String strValue = ((String)obj).trim();
                if (strValue.length() <= 0) return value;
                return Integer.valueOf(strValue);
            }
            catch (NumberFormatException numberformatexception) {
                throw new IllegalArgumentException("Failed to parse an integer from the value '" + obj + "'.", numberformatexception);
            }
        }
        if (!(obj instanceof Boolean)) return value;
        return (Boolean)obj != false ? Integer.valueOf(1) : def;
    }

    public static float floatValue(Object obj) {
        return ERXValueUtilities.floatValueWithDefault(obj, 0.0f);
    }

    public static float floatValueWithDefault(Object obj, float def) {
        return ERXValueUtilities.isNull(obj) ? def : ERXValueUtilities.FloatValueWithDefault(obj, Float.valueOf(def)).floatValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Float FloatValueWithDefault(Object obj, Float def) {
        Float value = def;
        if (ERXValueUtilities.isNull(obj)) return def;
        if (obj instanceof Float) {
            return (Float)obj;
        }
        if (obj instanceof Number) {
            return Float.valueOf(((Number)obj).floatValue());
        }
        if (obj instanceof String) {
            try {
                String strValue = ((String)obj).trim();
                if (strValue.length() <= 0) return value;
                return Float.valueOf(strValue);
            }
            catch (NumberFormatException numberformatexception) {
                throw new IllegalArgumentException("Failed to parse a float from the value '" + obj + "'.", numberformatexception);
            }
        }
        if (!(obj instanceof Boolean)) return value;
        return (Boolean)obj != false ? Float.valueOf(1.0f) : def;
    }

    public static double doubleValue(Object obj) {
        return ERXValueUtilities.doubleValueWithDefault(obj, 0.0);
    }

    public static double doubleValueWithDefault(Object obj, double def) {
        return ERXValueUtilities.isNull(obj) ? def : ERXValueUtilities.DoubleValueWithDefault(obj, def);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Double DoubleValueWithDefault(Object obj, Double def) {
        Double value = def;
        if (ERXValueUtilities.isNull(obj)) return def;
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof String) {
            try {
                String strValue = ((String)obj).trim();
                if (strValue.length() <= 0) return value;
                return Double.valueOf(strValue);
            }
            catch (NumberFormatException numberformatexception) {
                throw new IllegalArgumentException("Failed to parse a double from the value '" + obj + "'.", numberformatexception);
            }
        }
        if (!(obj instanceof Boolean)) return value;
        return (Boolean)obj != false ? Double.valueOf(1.0) : def;
    }

    public static long longValue(Object obj) {
        return ERXValueUtilities.longValueWithDefault(obj, 0L);
    }

    public static long longValueWithDefault(Object obj, long def) {
        return ERXValueUtilities.isNull(obj) ? def : ERXValueUtilities.LongValueWithDefault(obj, def);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Long LongValueWithDefault(Object obj, Long def) {
        Long value = def;
        if (ERXValueUtilities.isNull(obj)) return def;
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            try {
                String strValue = ((String)obj).trim();
                if (strValue.length() <= 0) return value;
                return Long.valueOf(strValue);
            }
            catch (NumberFormatException numberformatexception) {
                throw new IllegalArgumentException("Failed to parse a long from the value '" + obj + "'.", numberformatexception);
            }
        }
        if (!(obj instanceof Boolean)) return value;
        return (Boolean)obj != false ? Long.valueOf(1L) : def;
    }

    public static BigDecimal bigDecimalValue(Object obj) {
        return ERXValueUtilities.bigDecimalValueWithDefault(obj, null);
    }

    public static BigDecimal bigDecimalValueWithDefault(Object obj, BigDecimal def) {
        BigDecimal value = def;
        if (!ERXValueUtilities.isNull(obj)) {
            if (obj instanceof BigDecimal) {
                value = (BigDecimal)obj;
            } else if (obj instanceof String) {
                String strValue = ((String)obj).trim();
                if (strValue.length() > 0) {
                    value = new BigDecimal(strValue);
                }
            } else if (obj instanceof Integer) {
                value = new BigDecimal((Integer)obj);
            } else if (obj instanceof Long) {
                value = new BigDecimal((Long)obj);
            } else if (obj instanceof Float) {
                value = new BigDecimal(((Float)obj).floatValue());
            } else if (obj instanceof Double) {
                value = new BigDecimal((Double)obj);
            } else if (obj instanceof Number) {
                value = new BigDecimal(((Number)obj).doubleValue());
            } else if (obj instanceof Boolean) {
                value = new BigDecimal((Boolean)obj != false ? 1 : 0);
            } else {
                throw new IllegalArgumentException("Failed to parse a BigDecimal from the value '" + obj + "'.");
            }
        }
        return value;
    }

    public static int compare(int int1, int int2) {
        return int1 > int2 ? 1 : (int1 < int2 ? -1 : 0);
    }

    public static <T extends Enum<T>> T enumValue(Object obj, Class<T> enumType) {
        return ERXValueUtilities.enumValueWithDefault(obj, enumType, null);
    }

    public static <T extends Enum<T>> T enumValueWithRequiredDefault(Object obj, T def) {
        return (T)ERXValueUtilities.enumValueWithDefault(obj, def.getClass(), def);
    }

    public static <T extends Enum<T>> T enumValueWithDefault(Object obj, Class<T> enumType, T def) {
        Object result = def;
        if (!ERXValueUtilities.isNull(obj)) {
            if (obj instanceof Enum) {
                result = (Enum)obj;
            } else if (obj instanceof String) {
                result = Enum.valueOf(enumType, (String)obj);
            } else {
                throw new IllegalArgumentException("Failed to parse an enum from the value '" + obj + "'.");
            }
        }
        return result;
    }
}

