/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.variables;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.objectstyle.woenvironment.frameworks.Root;
import org.objectstyle.woenvironment.frameworks.Version;
import org.objectstyle.woenvironment.plist.ToHellWithProperties;
import org.objectstyle.wolips.variables.BuildPropertiesAdapterFactory;
import org.objectstyle.wolips.variables.VariablesPlugin;

public class BuildProperties {
    private IProject _project;
    private Properties _properties;
    private boolean _dirty;
    private long _version;
    private boolean _defaultsInitialized;
    private Version _woVersionDefault;
    private Version _versionDefault;
    private String _inlineBindingPrefixDefault;
    private String _inlineBindingSuffixDefault;
    private boolean _wellFormedTemplateRequiredDefault;

    public BuildProperties(IProject project) {
        this._project = project;
        this._version = -1L;
        this.load();
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public IProject getProject() {
        return this._project;
    }

    public IFile getBuildPropertiesEclipseFile() {
        IFile file = this._project.getFile("build.properties");
        return file;
    }

    public File getBuildPropertiesFile() {
        File file = this.getBuildPropertiesEclipseFile().getLocation().toFile();
        return file;
    }

    public long getModificationStamp() {
        File file = this.getBuildPropertiesFile();
        if (this._version == -1L && file.exists()) {
            this._version = file.lastModified();
        }
        return this._version;
    }

    public synchronized void setProperties(Properties properties) {
        if (!this._properties.equals(properties)) {
            this._properties = properties;
            this._dirty = true;
        }
    }

    public synchronized Properties getProperties() {
        Properties cloneProperties = new Properties();
        cloneProperties.putAll((Map<?, ?>)this._properties);
        return cloneProperties;
    }

    public synchronized boolean getBoolean(String key, boolean defaultValue) {
        String strValue = this.get(key);
        boolean value = strValue == null ? defaultValue : "true".equalsIgnoreCase(strValue);
        return value;
    }

    public synchronized String get(String key) {
        return this.get(key, null);
    }

    public synchronized String get(String key, String defaultValue) {
        String value = this._properties.getProperty(key, defaultValue);
        return value;
    }

    public synchronized void remove(String key) {
        this.put(key, null);
    }

    public synchronized void put(String key, boolean value) {
        this.put(key, Boolean.valueOf(value).toString());
    }

    public synchronized void put(String key, String value) {
        if (value == null) {
            if (this._properties.containsKey(key)) {
                this._properties.remove(key);
                this._dirty = true;
            }
        } else {
            String oldValue = this.get(key);
            if (!value.equals(oldValue)) {
                this._properties.setProperty(key, value);
                this._dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() {
        try {
            boolean dirty;
            Properties properties = new Properties();
            File file = this.getBuildPropertiesFile();
            if (file.exists()) {
                FileInputStream inputStream = new FileInputStream(file);
                try {
                    properties.load(inputStream);
                }
                finally {
                    ((InputStream)inputStream).close();
                }
                dirty = false;
            } else {
                dirty = true;
            }
            BuildProperties buildProperties = this;
            synchronized (buildProperties) {
                this._dirty = dirty;
                this._properties = properties;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load the build properties for the project '" + this._project + "'.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() throws CoreException, IOException {
        ToHellWithProperties properties = new ToHellWithProperties();
        properties.putAll((Map<?, ?>)this._properties);
        if (!this._dirty) {
            return;
        }
        File file = this.getBuildPropertiesFile();
        FileOutputStream fos = new FileOutputStream(file);
        try {
            properties.store(fos, null);
        }
        finally {
            fos.close();
        }
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                BuildProperties.this.getBuildPropertiesEclipseFile().refreshLocal(1, monitor);
            }
        }, null);
        this._dirty = false;
    }

    public String getName() {
        String projectName = this.get("project.name");
        if (projectName == null || projectName.length() == 0) {
            projectName = this.get("framework.name");
        }
        if (projectName == null || projectName.length() == 0) {
            projectName = this._project.getName();
        }
        return projectName;
    }

    public void setName(String name) {
        this.put("project.name", name);
        this.put("project.name.lowercase", name.toLowerCase());
    }

    public boolean getWebXML() {
        return this.getBoolean("webXML", false);
    }

    public void setWebXML(boolean webXML) {
        this.put("webXML", webXML);
    }

    public boolean isServletDeployment() {
        return this.getBoolean("servletDeployment", false);
    }

    public void setServletDeployment(boolean servletDeployment) {
        if (servletDeployment) {
            this.put("servletDeployment", servletDeployment);
        } else {
            this.remove("servletDeployment");
        }
    }

    public String getWebXML_CustomContent(boolean convertNullValueToEmptyString) {
        return this.get("webXML_CustomContent", convertNullValueToEmptyString ? "" : null);
    }

    public void setWebXML_CustomContent(String webXML_CustomContent) {
        this.put("webXML_CustomContent", webXML_CustomContent);
    }

    public String getEOGeneratorArgs(boolean convertNullValueToEmptyString) {
        return this.get("eogeneratorArgs", convertNullValueToEmptyString ? "" : null);
    }

    public void setEOGeneratorArgs(String eogeneratorArgs) {
        this.put("eogeneratorArgs", eogeneratorArgs);
    }

    public String getPrincipalClass() {
        return this.getPrincipalClass(false);
    }

    public String getPrincipalClass(boolean convertNullValueToEmptyString) {
        return this.get("principalClass", convertNullValueToEmptyString ? "" : null);
    }

    public void setPrincipalClass(String principalClass) {
        this.put("principalClass", principalClass == null ? "" : principalClass);
    }

    public boolean isEmbed(Root root) {
        String shortName = root.getShortName();
        return this.getBoolean("embed." + shortName, false);
    }

    public void setEmbed(Root root, boolean embed) {
        String shortName = root.getShortName();
        if (!embed) {
            this.remove("embed." + shortName);
        } else {
            this.put("embed." + shortName, embed);
        }
    }

    public String getCustomInfoPListContent() {
        return this.getCustomInfoPListContent(false);
    }

    public String getCustomInfoPListContent(boolean convertNullValueToEmptyString) {
        return this.get("customInfoPListContent", convertNullValueToEmptyString ? "" : null);
    }

    public void setCustomInfoPListContent(String customInfoPListContent) {
        this.put("customInfoPListContent", customInfoPListContent == null ? "" : customInfoPListContent);
    }

    public String getEOAdaptorClassName() {
        return this.getEOAdaptorClassName(false);
    }

    public String getEOAdaptorClassName(boolean convertNullValueToEmptyString) {
        return this.get("eoAdaptorClassName", convertNullValueToEmptyString ? "" : null);
    }

    public void setEOAdaptorClassName(String eoAdaptorClassName) {
        this.put("eoAdaptorClassName", eoAdaptorClassName == null ? "" : eoAdaptorClassName);
    }

    public String getProjectFrameworkFolder() {
        return this.get("projectFrameworkFolder");
    }

    public void setProjectFrameworkFolder(String projectFrameworkFolder) {
        this.put("projectFrameworkFolder", projectFrameworkFolder);
    }

    public void setJavaClient(boolean javaClient) {
        if (javaClient) {
            this.put("javaClient", javaClient);
        } else {
            this.remove("javaClient");
        }
    }

    public boolean isJavaClient() {
        return this.getBoolean("javaClient", false);
    }

    public void setJavaWebStart(boolean javaWebStart) {
        if (javaWebStart) {
            this.put("javaWebStart", javaWebStart);
        } else {
            this.remove("javaWebStart");
        }
    }

    public boolean isJavaWebStart() {
        return this.getBoolean("javaWebStart", false);
    }

    public boolean hasValidProjectType() {
        String projectType = this.get("project.type");
        return "application".equals(projectType) || "framework".equals(projectType);
    }

    public boolean isFramework() {
        boolean isFramework = false;
        String projectType = this.get("project.type");
        if (projectType != null) {
            isFramework = "framework".equals(projectType);
        } else {
            String frameworkName = this.get("framework.name");
            if (frameworkName != null) {
                isFramework = true;
            }
        }
        return isFramework;
    }

    public void setFramework(boolean framework) {
        if (framework) {
            this.put("project.type", "framework");
        } else {
            this.put("project.type", "application");
        }
    }

    public String getBundleType() {
        return this.isFramework() ? "FMWK" : "APPL";
    }

    public void _copyDefaultsFrom(BuildProperties props) {
        if (props._defaultsInitialized) {
            this._woVersionDefault = props._woVersionDefault;
            this._inlineBindingPrefixDefault = props._inlineBindingPrefixDefault;
            this._inlineBindingSuffixDefault = props._inlineBindingSuffixDefault;
            this._wellFormedTemplateRequiredDefault = props._wellFormedTemplateRequiredDefault;
            this._defaultsInitialized = true;
        }
    }

    protected synchronized void ensureDefaultsInitialized() {
        if (!this._defaultsInitialized) {
            this._defaultsInitialized = true;
            this._woVersionDefault = new Version(VariablesPlugin.getDefault().getGlobalVariables().getString("wo.version", "5.3.3"));
            this._inlineBindingPrefixDefault = VariablesPlugin.getDefault().getGlobalVariables().getString("component.inlineBindingPrefix", "[");
            this._inlineBindingSuffixDefault = VariablesPlugin.getDefault().getGlobalVariables().getString("component.inlineBindingSuffix", "]");
            this._wellFormedTemplateRequiredDefault = VariablesPlugin.getDefault().getGlobalVariables().getBoolean("component.wellFormedTemplateRequired", "yes".equals(Platform.getPreferencesService().getString("org.objectstyle.wolips.bindings", "WellFormedTemplate", null, null)));
            BuildPropertiesAdapterFactory.initializeBuildPropertiesDefaults(this);
        }
    }

    public void setWOVersionDefault(Version woVersionDefault) {
        this._woVersionDefault = woVersionDefault;
    }

    public Version getWOVersionDefault() {
        this.ensureDefaultsInitialized();
        return this._woVersionDefault;
    }

    public void setVersionDefault(Version versionDefault) {
        this._versionDefault = versionDefault;
    }

    public Version getVersionDefault() {
        this.ensureDefaultsInitialized();
        return this._versionDefault;
    }

    public void setVersion(Version version) {
        if (version != null) {
            this.put("version", version.getVersionStr());
        } else {
            this.remove("version");
        }
    }

    public Version getVersion() {
        Version versionDefault = this.getVersionDefault();
        return new Version(this.get("version", versionDefault == null ? null : versionDefault.getVersionStr()));
    }

    public void setWOVersion(Version woVersion) {
        if (woVersion != null) {
            this.put("wo.version", woVersion.getVersionStr());
        } else {
            this.remove("wo.version");
        }
    }

    public Version getWOVersion() {
        Version woVersionDefault = this.getWOVersionDefault();
        return new Version(this.get("wo.version", woVersionDefault == null ? null : woVersionDefault.getVersionStr()));
    }

    public void setInlineBindingPrefixDefault(String inlineBindingPrefixDefault) {
        this._inlineBindingPrefixDefault = inlineBindingPrefixDefault;
    }

    public String getInlineBindingPrefixDefault() {
        this.ensureDefaultsInitialized();
        return this._inlineBindingPrefixDefault;
    }

    public void setInlineBindingPrefix(String inlineBindingPrefix) {
        if (inlineBindingPrefix != null) {
            this.put("component.inlineBindingPrefix", inlineBindingPrefix);
        } else {
            this.remove("component.inlineBindingPrefix");
        }
    }

    public String getInlineBindingPrefix() {
        return this.get("component.inlineBindingPrefix", this.getInlineBindingPrefixDefault());
    }

    public void setInlineBindingSuffixDefault(String inlineBindingSuffixDefault) {
        this._inlineBindingSuffixDefault = inlineBindingSuffixDefault;
    }

    public String getInlineBindingSuffixDefault() {
        this.ensureDefaultsInitialized();
        return this._inlineBindingSuffixDefault;
    }

    public void setInlineBindingSuffix(String inlineBindingSuffix) {
        if (inlineBindingSuffix != null) {
            this.put("component.inlineBindingSuffix", inlineBindingSuffix);
        } else {
            this.remove("component.inlineBindingSuffix");
        }
    }

    public String getInlineBindingSuffix() {
        return this.get("component.inlineBindingSuffix", this.getInlineBindingSuffixDefault());
    }

    public void setWellFormedTemplateRequiredDefault(boolean wellFormedTemplateRequiredDefault) {
        this._wellFormedTemplateRequiredDefault = wellFormedTemplateRequiredDefault;
    }

    public boolean getWellFormedTemplateRequiredDefault() {
        this.ensureDefaultsInitialized();
        return this._wellFormedTemplateRequiredDefault;
    }

    public void setWellFormedTemplateRequired(Boolean wellFormedTemplateRequired) {
        if (wellFormedTemplateRequired == null) {
            this.remove("component.wellFormedTemplateRequired");
        } else {
            this.put("component.wellFormedTemplateRequired", wellFormedTemplateRequired);
        }
    }

    public boolean isWellFormedTemplateRequired() {
        boolean wellFormedTemplateRequired = this.getBoolean("component.wellFormedTemplateRequired", this.getWellFormedTemplateRequiredDefault());
        return wellFormedTemplateRequired;
    }

    public boolean isBuildFolderRequired() {
        return this.getWOVersion().isAtLeastVersion(5, 6);
    }
}

