/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.env;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.objectstyle.woenvironment.plist.ToHellWithProperties;
import org.objectstyle.woenvironment.util.FileStringScanner;

public class WOVariables {
    public static final String USER_ROOT = "wo.user.root";
    public static final String USER_FRAMEWORKS = "wo.user.frameworks";
    public static final String LOCAL_ROOT = "wo.local.root";
    public static final String LOCAL_FRAMEWORKS = "wo.local.frameworks";
    public static final String SYSTEM_ROOT = "wo.system.root";
    public static final String SYSTEM_FRAMEWORKS = "wo.system.frameworks";
    public static final String NETWORK_ROOT = "wo.network.root";
    public static final String NETWORK_FRAMEWORKS = "wo.network.frameworks";
    public static final String EXTERNAL_BUILD_ROOT = "wo.external.root";
    public static final String EXTERNAL_BUILD_FRAMEWORKS = "wo.external.frameworks";
    public static final String APPS_ROOT = "wo.apps.root";
    public static final String API_ROOT_KEY = "wo.api.root";
    public static final String BOOTSTRAP_JAR_KEY = "wo.bootstrapjar";
    public static final String WEBOBJECTS_EXTENSIONS = "wo.extensions";
    public static final String WOLIPS_PROPERTIES = "wolips.properties";
    private static Map<File, CachedProperties> _cachedProperties = new HashMap<File, CachedProperties>();
    private Properties _wolipsPropertiesDefaults;
    private Properties _wolipsProperties;
    private File _wolipsPropertiesFile;

    public WOVariables(WOVariables variables, Map<?, ?> existingProperties) {
        this.init(variables, existingProperties);
    }

    public WOVariables(Map<?, ?> existingProperties) {
        this.init(null, existingProperties);
    }

    public File getWOLipsPropertiesFile() {
        return this._wolipsPropertiesFile;
    }

    protected File getWOLipsPropertiesFile(String name) {
        File wolipsPropertiesFile = new File(name);
        if (!wolipsPropertiesFile.isAbsolute()) {
            wolipsPropertiesFile = WOVariables.isWindows() ? new File(System.getenv("APPDATA") + "\\WOLips\\" + name) : new File(this.userHomeFolder(), "Library/Application Support/WOLips/" + name);
        }
        return wolipsPropertiesFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(WOVariables variables, Map<?, ?> existingProperties) {
        this._wolipsPropertiesDefaults = new Properties();
        if (variables == null) {
            Object woVersion;
            String wolipsPropertiesPath;
            this._wolipsProperties = new ToHellWithProperties();
            if (existingProperties != null) {
                wolipsPropertiesPath = (String)existingProperties.get(WOLIPS_PROPERTIES);
                if (wolipsPropertiesPath == null) {
                    wolipsPropertiesPath = (String)existingProperties.get("wolips.global.properties");
                }
            } else {
                wolipsPropertiesPath = System.getProperty(WOLIPS_PROPERTIES);
            }
            if (wolipsPropertiesPath == null) {
                wolipsPropertiesPath = System.getenv(WOLIPS_PROPERTIES);
            }
            File wolipsPropertiesFile = null;
            if (wolipsPropertiesPath != null) {
                wolipsPropertiesFile = this.getWOLipsPropertiesFile(wolipsPropertiesPath);
                if (!this.isValidWOlipsPropertiesFile(wolipsPropertiesFile)) {
                    wolipsPropertiesFile = null;
                }
            } else {
                String environmentName = null;
                woVersion = null;
                if (existingProperties != null) {
                    environmentName = (String)existingProperties.get("wolips.environment");
                    woVersion = (String)existingProperties.get("wo.version");
                }
                if (woVersion != null && !this.isValidWOlipsPropertiesFile(wolipsPropertiesFile = this.getWOLipsPropertiesFile(wolipsPropertiesPath = environmentName != null ? "wolips." + environmentName + "." + (String)woVersion + ".properties" : "wolips." + (String)woVersion + ".properties"))) {
                    wolipsPropertiesFile = null;
                }
                if (wolipsPropertiesFile == null) {
                    if (environmentName != null) {
                        wolipsPropertiesPath = "wolips." + environmentName + ".properties";
                        wolipsPropertiesFile = this.getWOLipsPropertiesFile(wolipsPropertiesPath);
                        if (!this.isValidWOlipsPropertiesFile(wolipsPropertiesFile)) {
                            wolipsPropertiesPath = WOLIPS_PROPERTIES;
                            wolipsPropertiesFile = this.getWOLipsPropertiesFile(wolipsPropertiesPath);
                        }
                    } else {
                        wolipsPropertiesPath = WOLIPS_PROPERTIES;
                        wolipsPropertiesFile = this.getWOLipsPropertiesFile(wolipsPropertiesPath);
                    }
                }
            }
            this._wolipsPropertiesFile = wolipsPropertiesFile;
            if (this.isValidWOlipsPropertiesFile(this._wolipsPropertiesFile)) {
                Properties backingProperties;
                CachedProperties cachedProperties;
                woVersion = _cachedProperties;
                synchronized (woVersion) {
                    cachedProperties = _cachedProperties.get(this._wolipsPropertiesFile);
                    if (cachedProperties == null) {
                        cachedProperties = new CachedProperties(this._wolipsPropertiesFile);
                        _cachedProperties.put(this._wolipsPropertiesFile, cachedProperties);
                    }
                }
                cachedProperties.reloadIfNecessary();
                this._wolipsProperties = new ToHellWithProperties();
                Properties properties = backingProperties = cachedProperties.properties();
                synchronized (properties) {
                    this._wolipsProperties.putAll((Map<?, ?>)backingProperties);
                }
            }
            if (this._wolipsProperties == null || this._wolipsProperties.isEmpty()) {
                this.createDefaultProperties();
                if (wolipsPropertiesPath != null) {
                    this._wolipsPropertiesFile = this.getWOLipsPropertiesFile(wolipsPropertiesPath);
                }
                this.save();
            }
        } else {
            this._wolipsProperties = new ToHellWithProperties();
            this._wolipsProperties.putAll((Map<?, ?>)variables._wolipsProperties);
        }
        if (existingProperties != null) {
            for (Map.Entry<?, ?> entry : existingProperties.entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                this._wolipsProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.setDefaults();
    }

    public void setDefaults() {
        this.setDefaults(this._wolipsPropertiesDefaults);
    }

    protected void setDefaults(Properties properties) {
        String nextRoot = System.getenv("NEXT_ROOT");
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            userHome = ".";
        }
        if (WOVariables.isWindows()) {
            properties.setProperty(API_ROOT_KEY, "/Developer/ADC%20Reference%20Library/documentation/WebObjects/Reference/API/");
            if (nextRoot != null) {
                properties.setProperty(APPS_ROOT, nextRoot + "\\Applications");
                properties.setProperty(BOOTSTRAP_JAR_KEY, nextRoot + "\\Library\\Application\\wotaskd.woa\\WOBootstrap.jar");
                properties.setProperty(LOCAL_ROOT, nextRoot + "\\Local");
                properties.setProperty(LOCAL_FRAMEWORKS, nextRoot + "\\Local\\Library\\Frameworks");
                properties.setProperty(SYSTEM_ROOT, nextRoot);
                properties.setProperty(SYSTEM_FRAMEWORKS, nextRoot + "\\Library\\Frameworks");
                properties.setProperty(NETWORK_ROOT, nextRoot + "\\Network");
                properties.setProperty(NETWORK_FRAMEWORKS, nextRoot + "\\Network\\Library\\Frameworks");
                properties.setProperty(WEBOBJECTS_EXTENSIONS, nextRoot + "\\Extensions");
            }
            properties.setProperty(USER_ROOT, userHome);
            properties.setProperty(USER_FRAMEWORKS, userHome + "\\Library\\Frameworks");
        } else {
            properties.setProperty(API_ROOT_KEY, "/Developer/Documentation/DocSets/com.apple.ADC_Reference_Library.WebObjectsReference.docset/Contents/Resources/Documents/documentation/InternetWeb/Reference/WO542Reference");
            properties.setProperty(APPS_ROOT, "/Library/WebObjects/Applications");
            properties.setProperty(BOOTSTRAP_JAR_KEY, "/System/Library/WebObjects/JavaApplications/wotaskd.woa/WOBootstrap.jar");
            properties.setProperty(LOCAL_ROOT, "/");
            properties.setProperty(LOCAL_FRAMEWORKS, "/Library/Frameworks");
            properties.setProperty(SYSTEM_ROOT, "/System");
            properties.setProperty(SYSTEM_FRAMEWORKS, "/System/Library/Frameworks");
            properties.setProperty(NETWORK_ROOT, "/Network");
            properties.setProperty(NETWORK_FRAMEWORKS, "/Network/Library/Frameworks");
            properties.setProperty(USER_ROOT, userHome);
            properties.setProperty(USER_FRAMEWORKS, userHome + "/Library/Frameworks");
            properties.setProperty(WEBOBJECTS_EXTENSIONS, "/Library/WebObjects/Extensions");
        }
    }

    public void createDefaultProperties() {
        this._wolipsProperties = new ToHellWithProperties();
        this.setDefaults(this._wolipsProperties);
    }

    public boolean isValidWOlipsPropertiesFile(File wolipsPropertiesFile) {
        return wolipsPropertiesFile != null && wolipsPropertiesFile.exists() && !wolipsPropertiesFile.isDirectory();
    }

    public File wolipsPropertiesFile() {
        return this._wolipsPropertiesFile;
    }

    public String externalBuildRoot() {
        return this.resolvedPath(this._wolipsProperties.getProperty(EXTERNAL_BUILD_ROOT));
    }

    public String externalBuildFrameworkPath() {
        String externalBuildRoot;
        String externalBuildFrameworkPath = this._wolipsProperties.getProperty(EXTERNAL_BUILD_FRAMEWORKS);
        if (externalBuildFrameworkPath == null && (externalBuildRoot = this.externalBuildRoot()) != null) {
            externalBuildFrameworkPath = new File(new File(externalBuildRoot, "Library"), "Frameworks").toString();
        }
        return this.resolvedPath(externalBuildFrameworkPath);
    }

    public String localRoot() {
        return this.resolvedPath(this._wolipsProperties.getProperty(LOCAL_ROOT));
    }

    public String localFrameworkPath() {
        String localRoot;
        String localFrameworkPath = this._wolipsProperties.getProperty(LOCAL_FRAMEWORKS);
        if (localFrameworkPath == null && (localRoot = this.localRoot()) != null) {
            localFrameworkPath = new File(new File(localRoot, "Library"), "Frameworks").toString();
        }
        return this.resolvedPath(localFrameworkPath);
    }

    public String systemRoot() {
        return this.resolvedPath(this._wolipsProperties.getProperty(SYSTEM_ROOT));
    }

    public String systemFrameworkPath() {
        String systemRoot;
        String systemFrameworkPath = this._wolipsProperties.getProperty(SYSTEM_FRAMEWORKS);
        if (systemFrameworkPath == null && (systemRoot = this.systemRoot()) != null) {
            systemFrameworkPath = new File(new File(systemRoot, "Library"), "Frameworks").toString();
        }
        return this.resolvedPath(systemFrameworkPath);
    }

    public String networkRoot() {
        return this.resolvedPath(this._wolipsProperties.getProperty(NETWORK_ROOT));
    }

    public String networkFrameworkPath() {
        String networkRoot;
        String networkFrameworkPath = this._wolipsProperties.getProperty(NETWORK_FRAMEWORKS);
        if (networkFrameworkPath == null && (networkRoot = this.networkRoot()) != null) {
            networkFrameworkPath = new File(new File(networkRoot, "Library"), "Frameworks").toString();
        }
        return this.resolvedPath(networkFrameworkPath);
    }

    public String appsRoot() {
        return this.resolvedPath(this._wolipsProperties.getProperty(APPS_ROOT));
    }

    public String boostrapJar() {
        return this.resolvedPath(this._wolipsProperties.getProperty(BOOTSTRAP_JAR_KEY));
    }

    public String referenceApi() {
        return this.resolvedPath(this._wolipsProperties.getProperty(API_ROOT_KEY));
    }

    public String userHomeFolder() {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            userHome = System.getenv("USERPROFILE");
        }
        if (userHome == null) {
            System.out.println("WOVariables.userHome: No user home directory found.");
        }
        return userHome;
    }

    public String userRoot() {
        return this.resolvedPath(this._wolipsProperties.getProperty(USER_ROOT));
    }

    public String userFrameworkPath() {
        return this.resolvedPath(this._wolipsProperties.getProperty(USER_FRAMEWORKS));
    }

    public static String woProjectFileName() {
        return "PB.project";
    }

    public static String webServerResourcesDirName() {
        return "WebServerResources";
    }

    public String encodePathForFile(File aFile) {
        return this.encodePath(aFile.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encodePath(String path) {
        String userHome = null;
        String systemRoot = null;
        String localRoot = null;
        String aPath = null;
        try {
            boolean otherRoot;
            localRoot = this.localRoot();
            userHome = this.userRoot();
            systemRoot = this.systemRoot();
            int localRootLength = 0;
            int userHomeLength = 0;
            int systemRootLength = 0;
            if (localRoot != null) {
                localRootLength = localRoot.length();
            }
            if (userHome != null) {
                userHomeLength = userHome.length();
            }
            if (systemRoot != null) {
                systemRootLength = systemRoot.length();
            }
            aPath = this.convertWindowsPath(path);
            if (localRoot != null && aPath.startsWith(localRoot)) {
                otherRoot = false;
                if (localRootLength < userHomeLength && aPath.startsWith(userHome)) {
                    otherRoot = true;
                }
                if (localRootLength < systemRootLength && aPath.startsWith(systemRoot)) {
                    otherRoot = true;
                }
                if (!otherRoot) {
                    if (localRootLength == 1) {
                        String string = "LOCALROOT" + aPath;
                        return string;
                    }
                    String string = "LOCALROOT" + aPath.substring(localRootLength);
                    return string;
                }
            }
            if (userHome != null && aPath.startsWith(userHome)) {
                otherRoot = false;
                if (userHomeLength < systemRootLength && aPath.startsWith(systemRoot)) {
                    otherRoot = true;
                }
                if (!otherRoot) {
                    String string = "HOMEROOT" + aPath.substring(userHomeLength);
                    return string;
                }
            }
            if (systemRoot != null && aPath.startsWith(systemRoot)) {
                String string = "WOROOT" + aPath.substring(systemRootLength);
                return string;
            }
            String string = aPath;
            return string;
        }
        catch (Exception anException) {
            System.out.println("Exception occurred during encoding of the path " + anException);
        }
        finally {
            localRoot = null;
            userHome = null;
            systemRoot = null;
            aPath = null;
        }
        return null;
    }

    private String convertWindowsPath(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        return FileStringScanner.replace(path, "\\", "/");
    }

    private String resolvedPath(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        File filepath = new File(path);
        if (!filepath.isAbsolute()) {
            filepath = new File(this._wolipsPropertiesFile.getParentFile(), path);
        }
        return this.convertWindowsPath(filepath.toString());
    }

    public String getProperty(String aKey) {
        String value;
        String string = value = this._wolipsProperties != null ? this._wolipsProperties.getProperty(aKey) : null;
        if (value == null) {
            value = this.getDefault(aKey);
        }
        return value;
    }

    public void setProperty(String key, String value) {
        if (WOLIPS_PROPERTIES.equals(key)) {
            File wolipsPropertiesFile = new File(value);
            this._wolipsPropertiesFile = wolipsPropertiesFile.isAbsolute() ? wolipsPropertiesFile : this.getWOLipsPropertiesFile(value);
        } else {
            this._wolipsProperties.setProperty(key, value);
        }
    }

    public void setDefault(String key, String value) {
        this._wolipsPropertiesDefaults.setProperty(key, value);
    }

    public String getDefault(String key) {
        return this._wolipsPropertiesDefaults.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        block13: {
            if (this._wolipsPropertiesFile == null) {
                System.out.println("WOVariables.save: There is no wolips properties file set, skipping save.");
            } else {
                try {
                    File wolipsPropertiesFolder = this._wolipsPropertiesFile.getParentFile();
                    if (!wolipsPropertiesFolder.exists() && !wolipsPropertiesFolder.mkdirs()) {
                        throw new IOException("Failed to create the folder '" + wolipsPropertiesFolder + "'.");
                    }
                    if (wolipsPropertiesFolder.canWrite()) {
                        try (FileOutputStream wolipsPropertiesStream = new FileOutputStream(this._wolipsPropertiesFile);){
                            this._wolipsProperties.store(wolipsPropertiesStream, null);
                        }
                        Map<File, CachedProperties> map = _cachedProperties;
                        synchronized (map) {
                            _cachedProperties.remove(this._wolipsPropertiesFile);
                            break block13;
                        }
                    }
                    throw new IOException("Failed to save the properties to '" + this._wolipsPropertiesFile + "'.");
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to write " + this._wolipsPropertiesFile + ".", e);
                }
            }
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public static class CachedProperties {
        private File _propertiesFile;
        private long _lastLoaded;
        private Properties _properties;

        public CachedProperties(File propertiesFile) {
            this._propertiesFile = propertiesFile;
            this._properties = new ToHellWithProperties();
        }

        public void reloadIfNecessary() {
            long lastModified;
            if (this._propertiesFile.exists() && this._lastLoaded != (lastModified = this._propertiesFile.lastModified())) {
                this.reload();
                this._lastLoaded = lastModified;
            }
        }

        public Properties properties() {
            return this._properties;
        }

        public void reload() {
            try {
                this._properties = new ToHellWithProperties();
                this._properties.load(new FileInputStream(this._propertiesFile));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load " + this._propertiesFile + ".", e);
            }
        }
    }
}

