/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.objectstyle.woenvironment.env.WOVariables;
import org.objectstyle.woenvironment.frameworks.ExternalFolderFramework;
import org.objectstyle.woenvironment.frameworks.ExternalFolderRoot;
import org.objectstyle.woenvironment.frameworks.ExternalFrameworkModel;
import org.objectstyle.woenvironment.frameworks.FrameworkLibrary;
import org.objectstyle.woenvironment.frameworks.IFramework;
import org.objectstyle.woenvironment.frameworks.Root;
import org.objectstyle.woproject.ant.AntDependency;
import org.objectstyle.woproject.ant.AntDependencyOrdering;
import org.objectstyle.woproject.ant.FileUtil;
import org.w3c.dom.Node;

public class FrameworkSet
extends FileSet {
    private Root<IFramework> root;
    private ExternalFrameworkModel frameworkModel;
    private boolean eclipse;
    private boolean embed;
    private boolean hasBundles;
    private boolean frameworkIncludesCreated;
    private File deploymentDir;
    private String ifCondition = "";

    public void setEclipse(boolean eclipse) {
        this.eclipse = eclipse;
    }

    public boolean getEclipse() {
        return this.eclipse;
    }

    public void setFrameworkModel(ExternalFrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    public ExternalFrameworkModel getFrameworkModel() {
        if (this.frameworkModel == null) {
            this.frameworkModel = new ExternalFrameworkModel(this.getProject().getProperties());
        }
        return this.frameworkModel;
    }

    public void setDeploymentDir(File root) {
        this.deploymentDir = root;
    }

    public void setBundles(String value) {
        String[] bundles = value.split("/");
        PatternSet ps = this.createPatternSet();
        for (int i = 0; i < bundles.length; ++i) {
            String framework = bundles[i];
            if (framework.trim().length() <= 0) continue;
            this.hasBundles = true;
            framework = framework + ".framework";
            ps.createInclude().setName(framework);
        }
    }

    protected File getDeployedFile(File file) {
        File result = file;
        if (this.deploymentDir != null && !this.getEmbed()) {
            String oldPath = file.getPath();
            String newRoot = this.deploymentDir.getPath();
            String newPath = oldPath.replaceFirst("(.*?)(/\\w+\\.framework/)", newRoot + "$2");
            result = new File(newPath);
        }
        return result;
    }

    protected void setFrameworkRoot(ExternalFolderRoot root) {
        this.root = root;
    }

    protected Root<IFramework> getFrameworkRoot() {
        if (this.root == null) {
            ExternalFrameworkModel currentFrameworkModel = this.getFrameworkModel();
            try {
                this.root = currentFrameworkModel.getRootForFolder(this.getDir());
            }
            catch (IOException e) {
                throw new BuildException("There was no matching framework root found for the folder '" + this.getDir() + "'.  The known framework roots are " + currentFrameworkModel.getRoots() + ".", (Throwable)e);
            }
        }
        return this.root;
    }

    public void setRoot(String rootName) throws BuildException {
        ExternalFrameworkModel currentFrameworkModel = this.getFrameworkModel();
        this.root = currentFrameworkModel.getRootWithShortName(rootName);
        if (this.root == null) {
            throw new BuildException("There is no root named '" + rootName + "' in " + currentFrameworkModel.getRoots() + ".");
        }
        File rootFolder = ((ExternalFolderRoot)this.root).getFrameworksFolder();
        this.setDir(rootFolder);
    }

    protected List<ExternalFolderFramework> getEclipseFrameworks() {
        try {
            LinkedList<ExternalFolderFramework> frameworks = new LinkedList<ExternalFolderFramework>();
            List<Node> conEntries = FileUtil.getClasspathEntriesOfKind(this.getProject().getBaseDir(), "con");
            for (Node conEntry : conEntries) {
                Node pathAttribute = conEntry.getAttributes().getNamedItem("path");
                String path = pathAttribute.getTextContent();
                if (path == null || !path.startsWith("WOFramework/")) continue;
                int slashIndex = path.indexOf("/");
                String frameworkName = path.substring(slashIndex + 1);
                Object framework = this.frameworkModel.getFrameworkWithName(frameworkName);
                if (framework == null) {
                    throw new BuildException("The framework name '" + frameworkName + "' does not exist.");
                }
                if (!(framework instanceof ExternalFolderFramework) || framework.getRoot() != this.root) continue;
                ExternalFolderFramework externalFolderFramework = (ExternalFolderFramework)framework;
                frameworks.add(externalFolderFramework);
            }
            return frameworks;
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new BuildException("Failed to process eclipse frameworks: " + t.getMessage(), t);
        }
    }

    public synchronized void setupDirectoryScanner(FileScanner ds, Project p) {
        if (this.eclipse && !this.frameworkIncludesCreated) {
            try {
                List<ExternalFolderFramework> frameworks = this.getEclipseFrameworks();
                for (ExternalFolderFramework framework : frameworks) {
                    PatternSet.NameEntry frameworkInclude = this.createInclude();
                    frameworkInclude.setName(framework.getFrameworkFolder().getName());
                }
                if (frameworks.isEmpty()) {
                    PatternSet.NameEntry nameEntry = this.createInclude();
                }
                this.frameworkIncludesCreated = true;
            }
            catch (Throwable t) {
                throw new BuildException("Failed to process eclipse frameworks: " + t.getMessage(), t);
            }
        }
        super.setupDirectoryScanner(ds, p);
    }

    public void setEmbed(boolean flag) {
        this.embed = flag;
    }

    public boolean getEmbed() {
        if (this.isReference() && this.getProject() != null) {
            return ((FrameworkSet)this.getRef(this.getProject())).getEmbed();
        }
        return this.embed;
    }

    public void setIf(String string) {
        this.ifCondition = string == null ? "" : string;
    }

    protected Path getJarsPath() {
        List<ExternalFolderFramework> frameworks;
        Path frameworkPath = new Path(this.getProject());
        if (this.getEclipse()) {
            frameworks = this.getEclipseFrameworks();
        } else {
            String[] includedFrameworkFolderNames;
            frameworks = new LinkedList<ExternalFolderFramework>();
            for (String includedFrameworkFolderName : includedFrameworkFolderNames = this.getDirectoryScanner(this.getProject()).getIncludedDirectories()) {
                String frameworkName = ExternalFolderFramework.frameworkNameForFolder(new File(includedFrameworkFolderName));
                if (frameworkName != null) {
                    Object framework;
                    if (this.getDir() == null) {
                        framework = this.getFrameworkModel().getFrameworkWithName(frameworkName);
                        if (!(framework instanceof ExternalFolderFramework)) continue;
                        frameworks.add((ExternalFolderFramework)framework);
                        continue;
                    }
                    framework = new ExternalFolderFramework(this.getFrameworkRoot(), new File(this.getDir(), includedFrameworkFolderName));
                    frameworks.add((ExternalFolderFramework)framework);
                    continue;
                }
                System.out.println("FrameworkSet.getJarsPath: ILLEGAL FRAMEWORK NAMED " + frameworkName);
            }
        }
        for (IFramework iFramework : frameworks) {
            if (iFramework.getRoot() != null && !iFramework.getRoot().equals(this.getFrameworkRoot())) continue;
            for (FrameworkLibrary frameworkLibrary : iFramework.getFrameworkLibraries()) {
                File jarFile = frameworkLibrary.getLibraryFile();
                File deployedJarFile = this.getDeployedFile(jarFile);
                frameworkPath.setLocation(deployedJarFile);
            }
        }
        return frameworkPath;
    }

    public static Path jarsPathForFrameworkSets(Project project, List<FrameworkSet> frameworkSets, WOVariables variables) {
        LinkedList<AntDependency> unorderedDependencies = new LinkedList<AntDependency>();
        for (FrameworkSet frameworkSet : frameworkSets) {
            Path jarsPath = frameworkSet.getJarsPath();
            for (String jarPath : jarsPath.list()) {
                unorderedDependencies.add(new AntDependency(frameworkSet, jarPath, variables));
            }
        }
        List orderedDependencies = new AntDependencyOrdering().orderDependencies(unorderedDependencies);
        Path path = new Path(project);
        for (AntDependency dependency : orderedDependencies) {
            String jarPath = dependency.getJarPath();
            path.append(new Path(project, jarPath));
        }
        return path;
    }

    public static String jarsPathForFrameworkSets(Project project, String relativeEmbeddedFrameworksDir, List<FrameworkSet> frameworkSets, WOVariables variables) {
        LinkedList<AntDependency> unorderedDependencies = new LinkedList<AntDependency>();
        for (FrameworkSet frameworkSet : frameworkSets) {
            Path jarsPath = frameworkSet.getJarsPath();
            for (String jarPath : jarsPath.list()) {
                unorderedDependencies.add(new AntDependency(frameworkSet, jarPath, variables));
            }
        }
        StringBuffer path = new StringBuffer();
        List orderedDependencies = new AntDependencyOrdering().orderDependencies(unorderedDependencies);
        for (AntDependency dependency : orderedDependencies) {
            String jarPath = dependency.getJarPath();
            String encodedPath = variables.encodePath(jarPath);
            FrameworkSet frameworkSet = dependency.getFrameworkSet();
            if (frameworkSet.getEmbed()) {
                String prefix = frameworkSet.getDir(project).getAbsolutePath();
                prefix = variables.encodePath(prefix);
                encodedPath = frameworkSet.hasBundles() ? encodedPath.replaceFirst(".*?(\\w+.framework)", "APPROOT/" + relativeEmbeddedFrameworksDir + "/$1") : encodedPath.replaceFirst(prefix, "APPROOT/" + relativeEmbeddedFrameworksDir);
            }
            path.append(encodedPath).append(System.getProperty("line.separator"));
        }
        return path.toString();
    }

    private boolean hasBundles() {
        return this.hasBundles;
    }

    public DirectoryScanner getDirectoryScanner(Project p) {
        if (this.getDir() == null || !this.getDir().exists()) {
            DirectoryScanner scanner = new DirectoryScanner(){

                public synchronized String[] getIncludedDirectories() {
                    return new String[0];
                }

                public synchronized int getIncludedDirsCount() {
                    return 0;
                }

                public synchronized String[] getIncludedFiles() {
                    return new String[0];
                }

                public synchronized int getIncludedFilesCount() {
                    return 0;
                }
            };
            return scanner;
        }
        return super.getDirectoryScanner(p);
    }

    private static String replaceProperties(Project project, String value, Hashtable keys) throws BuildException {
        PropertyHelper ph = PropertyHelper.getPropertyHelper((Project)project);
        return ph.replaceProperties(null, value, keys);
    }

    private boolean testIfCondition() {
        if ("".equals(this.ifCondition)) {
            return true;
        }
        String string = FrameworkSet.replaceProperties(this.getProject(), this.ifCondition, this.getProject().getProperties());
        return this.getProject().getProperty(string) != null;
    }

    public String toString() {
        return "[FrameworkSet: root = " + this.getDir() + "]";
    }
}

