/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.math.BigDecimal;
import java.util.Set;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.baseforplugins.util.StringUtils;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateNameException;
import org.objectstyle.wolips.eomodeler.core.model.EODataType;
import org.objectstyle.wolips.eomodeler.core.model.EOFactoryMethodArgumentType;
import org.objectstyle.wolips.eomodeler.core.model.EOModelMap;
import org.objectstyle.wolips.eomodeler.core.model.EOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.ISortableEOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.UserInfoableEOModelObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEOArgument<T extends EOModelObject>
extends UserInfoableEOModelObject<T>
implements ISortableEOModelObject {
    public static final String ALLOWS_NULL = "allowsNull";
    public static final String NAME = "name";
    public static final String COLUMN_NAME = "columnName";
    public static final String ADAPTOR_VALUE_CONVERSION_CLASS_NAME = "adaptorValueConversionClassName";
    public static final String ADAPTOR_VALUE_CONVERSION_METHOD_NAME = "adaptorValueConversionMethodName";
    public static final String EXTERNAL_TYPE = "externalType";
    public static final String FACTORY_METHOD_ARGUMENT_TYPE = "factoryMethodArgumentType";
    public static final String PRECISION = "precision";
    public static final String SCALE = "scale";
    public static final String CLASS_NAME = "className";
    public static final String VALUE_CLASS_NAME = "valueClassName";
    public static final String VALUE_FACTORY_CLASS_NAME = "valueFactoryClassName";
    public static final String VALUE_FACTORY_METHOD_NAME = "valueFactoryMethodName";
    public static final String VALUE_TYPE = "valueType";
    public static final String DEFINITION = "definition";
    public static final String WIDTH = "width";
    public static final String DATA_TYPE = "dataType";
    public static final String SERVER_TIME_ZONE = "serverTimeZone";
    private String myName;
    private String myColumnName;
    private String myExternalType;
    private String myValueType;
    private String _className;
    protected boolean _inferredClassName;
    private String myValueClassName;
    protected boolean _inferredValueClassName;
    private String myValueFactoryClassName;
    private String myValueFactoryMethodName;
    private EOFactoryMethodArgumentType myFactoryMethodArgumentType;
    private String myAdaptorValueConversionClassName;
    private String myAdaptorValueConversionMethodName;
    private Integer myScale;
    private Integer myPrecision;
    private Integer myWidth;
    private Boolean myAllowsNull;
    private String myDefinition;
    private String myServerTimeZone;
    private EOModelMap myArgumentMap = new EOModelMap();
    private EODataType myDataType;

    public AbstractEOArgument() {
    }

    public AbstractEOArgument(String _name) {
        this();
        this.myName = _name;
    }

    public AbstractEOArgument(String _name, String _definition) {
        this(_name);
        this.myDefinition = _definition;
    }

    public void pasted() {
    }

    protected abstract AbstractEOArgument _createArgument(String var1);

    protected AbstractEOArgument _cloneArgument() {
        AbstractEOArgument argument = this._createArgument(this.myName);
        this._cloneIntoArgument(argument, false);
        this._cloneUserInfoInto(argument);
        return argument;
    }

    public void _cloneIntoArgument(AbstractEOArgument argument, boolean updatingFlattenedAttribute) {
        argument.myColumnName = updatingFlattenedAttribute ? "" : this.myColumnName;
        argument.myExternalType = this.myExternalType;
        argument.myValueType = this.myValueType;
        argument.myValueClassName = this.myValueClassName;
        argument._className = this._className;
        argument.myValueFactoryClassName = this.myValueFactoryClassName;
        argument.myValueFactoryMethodName = this.myValueFactoryMethodName;
        argument.myFactoryMethodArgumentType = this.myFactoryMethodArgumentType;
        argument.myAdaptorValueConversionClassName = this.myAdaptorValueConversionClassName;
        argument.myAdaptorValueConversionMethodName = this.myAdaptorValueConversionMethodName;
        argument.myScale = this.myScale;
        argument.myPrecision = this.myPrecision;
        argument.myServerTimeZone = this.myServerTimeZone;
        argument.myWidth = this.myWidth;
        argument.myAllowsNull = this.myAllowsNull;
        if (!updatingFlattenedAttribute) {
            argument.myDefinition = this.myDefinition;
        }
    }

    public boolean isFlattened() {
        return StringUtils.isKeyPath((String)this._getDefinition());
    }

    @Override
    public void setName(String _name) throws DuplicateNameException {
        this.setName(_name, true);
    }

    public void setName(String _name, boolean _fireEvents) throws DuplicateNameException {
        String oldName = this.getName();
        this.myName = _name;
        if (_fireEvents) {
            this.firePropertyChange(NAME, oldName, this.getName());
        }
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public Boolean getAllowsNull() {
        return this.isAllowsNull();
    }

    public Boolean isAllowsNull() {
        return this.myAllowsNull;
    }

    public void setAllowsNull(Boolean _allowsNull) {
        this._setAllowsNull(_allowsNull, true);
    }

    public void _setAllowsNull(Boolean _allowsNull, boolean _fireEvents) {
        this.setAllowsNull(_allowsNull, _fireEvents);
    }

    public void setAllowsNull(Boolean _allowsNull, boolean _fireEvents) {
        Boolean oldAllowsNull = this.getAllowsNull();
        this.myAllowsNull = _allowsNull;
        if (_fireEvents) {
            this.firePropertyChange(ALLOWS_NULL, oldAllowsNull, this.getAllowsNull());
        }
    }

    public String getColumnName() {
        return this.myColumnName;
    }

    public void setColumnName(String _columnName) {
        String oldColumnName = this.getColumnName();
        this.myColumnName = _columnName;
        this.firePropertyChange(COLUMN_NAME, oldColumnName, this.getColumnName());
    }

    public String getAdaptorValueConversionClassName() {
        return this.myAdaptorValueConversionClassName;
    }

    public void setAdaptorValueConversionClassName(String _adaptorValueConversionClassName) {
        String oldAdaptorValueConversionClassName = this.getAdaptorValueConversionClassName();
        this.myAdaptorValueConversionClassName = _adaptorValueConversionClassName;
        this.firePropertyChange(ADAPTOR_VALUE_CONVERSION_CLASS_NAME, oldAdaptorValueConversionClassName, this.getAdaptorValueConversionClassName());
    }

    public String getAdaptorValueConversionMethodName() {
        return this.myAdaptorValueConversionMethodName;
    }

    public void setAdaptorValueConversionMethodName(String _adaptorValueConversionMethodName) {
        String oldAdaptorValueConversionMethodName = this.getAdaptorValueConversionMethodName();
        this.myAdaptorValueConversionMethodName = _adaptorValueConversionMethodName;
        this.firePropertyChange(ADAPTOR_VALUE_CONVERSION_METHOD_NAME, oldAdaptorValueConversionMethodName, this.getAdaptorValueConversionMethodName());
    }

    public String getExternalType() {
        return this.myExternalType;
    }

    public void setExternalType(String _externalType) {
        String oldExternalType = this.getExternalType();
        this.myExternalType = _externalType;
        this.firePropertyChange(EXTERNAL_TYPE, oldExternalType, this.getExternalType());
    }

    public EOFactoryMethodArgumentType getFactoryMethodArgumentType() {
        return this.myFactoryMethodArgumentType;
    }

    public void setFactoryMethodArgumentType(EOFactoryMethodArgumentType _factoryMethodArgumentType) {
        EOFactoryMethodArgumentType oldFactoryMethodArgumentType = this.getFactoryMethodArgumentType();
        this.myFactoryMethodArgumentType = _factoryMethodArgumentType;
        this.firePropertyChange(FACTORY_METHOD_ARGUMENT_TYPE, oldFactoryMethodArgumentType, this.getFactoryMethodArgumentType());
    }

    public Integer getPrecision() {
        return this.myPrecision;
    }

    public void setPrecision(Integer _precision) {
        Integer oldPrecision = this.getPrecision();
        this.myPrecision = _precision;
        this.firePropertyChange(PRECISION, oldPrecision, this.getPrecision());
    }

    public Integer getScale() {
        return this.myScale;
    }

    public void setScale(Integer _scale) {
        Integer oldScale = this.getScale();
        this.myScale = _scale;
        this.firePropertyChange(SCALE, oldScale, this.getScale());
    }

    public String getServerTimeZone() {
        return this.myServerTimeZone;
    }

    public void setServerTimeZone(String _serverTimeZone) {
        String oldServerTimeZone = this.getServerTimeZone();
        this.myServerTimeZone = _serverTimeZone;
        this.firePropertyChange(SERVER_TIME_ZONE, oldServerTimeZone, this.getServerTimeZone());
    }

    public synchronized EODataType getDataType() {
        EODataType dataType = this.myDataType;
        if (dataType == null) {
            if (this.getValueFactoryMethodName() != null || this.getAdaptorValueConversionMethodName() != null) {
                dataType = EODataType.CUSTOM;
            } else {
                String className = this._convertJavaClassNameToValueClassName(this.getClassName());
                dataType = EODataType.getDataTypeByValueClassAndType(className, this.getValueType());
            }
            this.myDataType = dataType;
        }
        return dataType;
    }

    public void setDataType(EODataType _dataType) {
        EODataType oldDataType = this.getDataType();
        EODataType dataType = _dataType;
        if (dataType == null) {
            dataType = EODataType.CUSTOM;
        }
        this.setFactoryMethodArgumentType(null);
        this.setAdaptorValueConversionMethodName(null);
        this.setPrecision(null);
        this.setScale(null);
        this.setServerTimeZone(null);
        this.setValueFactoryMethodName(null);
        this.setWidth(null);
        this.setValueClassName(dataType.getValueClass(), false);
        this.setValueType(dataType.getFirstValueType(), false);
        this.myDataType = dataType;
        this.updateDataType(oldDataType);
    }

    protected void updateDataType(EODataType _oldDataType) {
        EODataType dataType = this.getDataType();
        this.firePropertyChange(DATA_TYPE, _oldDataType, dataType);
    }

    public String getJavaClassName() {
        return this.getJavaClassName(true);
    }

    protected String _convertJavaClassNameToValueClassName(String javaClassName) {
        Object className = javaClassName;
        className = className == null ? null : (((String)className).equals("java.lang.String") ? "NSString" : (((String)className).equals("java.lang.Number") || ((String)className).equals("java.lang.Integer") || ((String)className).equals("java.lang.Long") || ((String)className).equals("java.lang.Short") || ((String)className).equals("java.lang.Double") || ((String)className).equals("java.lang.Float") || ((String)className).equals("java.lang.Byte") ? "NSNumber" : (((String)className).equals("java.math.BigDecimal") ? "NSDecimalNumber" : (((String)className).equals("com.webobjects.foundation.NSTimestamp") ? "NSCalendarDate" : (((String)className).equals("com.webobjects.foundation.NSData") ? "NSData" : (((String)className).equals("") ? null : javaClassName))))));
        return className;
    }

    public String getJavaClassName(boolean shorten) {
        String className = this.getValueClassName();
        if (shorten && className != null && className.startsWith("java.lang.")) {
            className = className.substring("java.lang.".length());
        }
        if ("java.lang.Number".equals(className) || "Number".equals(className) || "NSNumber".equals(className)) {
            String valueType = this.getValueType();
            if (valueType == null || valueType.length() == 0) {
                className = Integer.class.getName();
            } else if ("B".equals(valueType)) {
                className = BigDecimal.class.getName();
            } else if ("b".equals(valueType)) {
                className = Byte.class.getName();
            } else if ("d".equals(valueType)) {
                className = Double.class.getName();
            } else if ("f".equals(valueType)) {
                className = Float.class.getName();
            } else if ("i".equals(valueType)) {
                className = Integer.class.getName();
            } else if ("l".equals(valueType)) {
                className = Long.class.getName();
            } else if ("s".equals(valueType)) {
                className = Short.class.getName();
            } else if ("c".equals(valueType)) {
                className = Boolean.class.getName();
            }
        } else if ("NSString".equals(className)) {
            className = String.class.getName();
        } else if ("NSCalendarDate".equals(className)) {
            className = shorten ? "NSTimestamp" : "com.webobjects.foundation.NSTimestamp";
        } else if ("NSDecimalNumber".equals(className)) {
            String valueType = this.getValueType();
            className = valueType == null || valueType.length() == 0 ? Integer.class.getName() : BigDecimal.class.getName();
        }
        if (shorten && className != null && className.startsWith("java.lang.")) {
            className = className.substring("java.lang.".length());
        }
        return className;
    }

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String className) {
        String oldClassName = this.getClassName();
        this._className = className;
        this._inferredClassName = false;
        this.myDataType = null;
        this.firePropertyChange(CLASS_NAME, oldClassName, this.getClassName());
    }

    public String getValueClassName() {
        return this.myValueClassName;
    }

    public void setValueClassName(String _valueClassName) {
        this.setValueClassName(_valueClassName, true);
    }

    public synchronized void setValueClassName(String _valueClassName, boolean _updateDataType) {
        EODataType oldDataType = this.getDataType();
        String oldValueClassName = this.getValueClassName();
        this.myValueClassName = _valueClassName;
        this._inferredValueClassName = false;
        this.myDataType = null;
        this.firePropertyChange(VALUE_CLASS_NAME, oldValueClassName, this.getValueClassName());
        this.setClassName(this.getJavaClassName(false));
        if (_updateDataType) {
            this.updateDataType(oldDataType);
        }
    }

    public String getValueFactoryClassName() {
        return this.myValueFactoryClassName;
    }

    public void setValueFactoryClassName(String _valueFactoryClassName) {
        String oldValueFactoryClassName = this.getValueFactoryClassName();
        this.myValueFactoryClassName = _valueFactoryClassName;
        this.firePropertyChange(VALUE_FACTORY_CLASS_NAME, oldValueFactoryClassName, this.getValueFactoryClassName());
    }

    public String getValueFactoryMethodName() {
        return this.myValueFactoryMethodName;
    }

    public void setValueFactoryMethodName(String _valueFactoryMethodName) {
        String oldValueFactoryMethodName = this.getValueFactoryMethodName();
        this.myValueFactoryMethodName = _valueFactoryMethodName;
        this.firePropertyChange(VALUE_FACTORY_METHOD_NAME, oldValueFactoryMethodName, this.getValueFactoryMethodName());
    }

    public String getValueType() {
        return this.myValueType;
    }

    public void setValueType(String _valueType) {
        this.setValueType(_valueType, false);
    }

    public synchronized void setValueType(String _valueType, boolean _updateDataType) {
        EODataType oldDataType = this.getDataType();
        String oldValueType = this.getValueType();
        this.myValueType = _valueType;
        this.myDataType = null;
        this.firePropertyChange(VALUE_TYPE, oldValueType, this.getValueType());
        if (_updateDataType) {
            this.updateDataType(oldDataType);
        }
        this.setClassName(this.getJavaClassName(false));
    }

    public Integer getWidth() {
        return this.myWidth;
    }

    public void setWidth(Integer _width) {
        Integer oldWidth = this.getWidth();
        this.myWidth = _width;
        this.firePropertyChange(WIDTH, oldWidth, this.getWidth());
    }

    public void setDefinition(String _definition) {
        String oldDefinition = this.myDefinition;
        this.myDefinition = _definition;
        this.updateDefinitionPath();
        this.firePropertyChange(DEFINITION, oldDefinition, this.getDefinition());
    }

    public String getDefinition() {
        return this._getDefinition();
    }

    protected String _getDefinition() {
        return this.myDefinition;
    }

    protected void updateDefinitionPath() {
    }

    public void loadFromMap(EOModelMap _argumentMap, Set<EOModelVerificationFailure> _failures) {
        this.myArgumentMap = _argumentMap;
        this.myName = _argumentMap.getString(NAME, true);
        this.myColumnName = _argumentMap.containsKey("externalName") ? _argumentMap.getString("externalName", true) : _argumentMap.getString(COLUMN_NAME, true);
        this.myExternalType = _argumentMap.getString(EXTERNAL_TYPE, true);
        this.myScale = _argumentMap.getInteger(SCALE);
        this.myPrecision = _argumentMap.getInteger(PRECISION);
        this.myWidth = _argumentMap.containsKey("maximumLength") ? _argumentMap.getInteger("maximumLength") : _argumentMap.getInteger(WIDTH);
        this.myValueType = _argumentMap.getString(VALUE_TYPE, true);
        this.myValueClassName = _argumentMap.getString(VALUE_CLASS_NAME, true);
        this._className = _argumentMap.getString(CLASS_NAME, true);
        if (this.myValueClassName == null) {
            this.myValueClassName = this._convertJavaClassNameToValueClassName(this._className);
            this._inferredValueClassName = true;
        }
        if (this._className == null) {
            this._className = this.getJavaClassName(false);
            this._inferredClassName = true;
        }
        this.myValueFactoryClassName = _argumentMap.getString(VALUE_FACTORY_CLASS_NAME, true);
        this.myValueFactoryMethodName = _argumentMap.getString(VALUE_FACTORY_METHOD_NAME, true);
        this.myFactoryMethodArgumentType = EOFactoryMethodArgumentType.getFactoryMethodArgumentTypeByID(_argumentMap.getString(FACTORY_METHOD_ARGUMENT_TYPE, true));
        this.myAdaptorValueConversionClassName = _argumentMap.getString(ADAPTOR_VALUE_CONVERSION_CLASS_NAME, true);
        this.myAdaptorValueConversionMethodName = _argumentMap.getString(ADAPTOR_VALUE_CONVERSION_METHOD_NAME, true);
        this.myServerTimeZone = _argumentMap.getString(SERVER_TIME_ZONE, true);
        this.myAllowsNull = _argumentMap.getBoolean(ALLOWS_NULL);
        this.myDefinition = _argumentMap.getString(DEFINITION, true);
        this.loadUserInfo(_argumentMap);
    }

    public EOModelMap toMap() {
        boolean usesClassNameProperty;
        EOModelMap argumentMap = this.myArgumentMap.cloneModelMap();
        argumentMap.setString(NAME, this.getName(), true);
        if (this.isFlattened()) {
            argumentMap.remove(COLUMN_NAME);
        } else if (this.myColumnName == null && this.getColumnName() == null) {
            argumentMap.setString(COLUMN_NAME, "", false);
        } else {
            argumentMap.setString(COLUMN_NAME, this.myColumnName, false);
        }
        argumentMap.remove("externalName");
        argumentMap.setString(EXTERNAL_TYPE, this.myExternalType, true);
        argumentMap.setInteger(SCALE, this.myScale);
        argumentMap.setInteger(PRECISION, this.myPrecision);
        argumentMap.setInteger(WIDTH, this.myWidth);
        argumentMap.setString(SERVER_TIME_ZONE, this.myServerTimeZone, true);
        argumentMap.remove("maximumLength");
        argumentMap.setString(VALUE_TYPE, this.myValueType, true);
        boolean bl = usesClassNameProperty = !ComparisonUtils.equals((Object)this.getJavaClassName(false), (Object)this.getClassName());
        if (usesClassNameProperty) {
            argumentMap.setString(CLASS_NAME, this._className, true);
            String convertedValueClassName = this._convertJavaClassNameToValueClassName(this._className);
            if (!ComparisonUtils.equals((Object)convertedValueClassName, (Object)this.myValueClassName)) {
                argumentMap.remove(VALUE_CLASS_NAME);
            }
        } else {
            argumentMap.remove(CLASS_NAME);
            argumentMap.setString(VALUE_CLASS_NAME, this.myValueClassName, true);
        }
        argumentMap.setString(VALUE_FACTORY_CLASS_NAME, this.myValueFactoryClassName, true);
        argumentMap.setString(VALUE_FACTORY_METHOD_NAME, this.myValueFactoryMethodName, true);
        if (this.myFactoryMethodArgumentType != null) {
            argumentMap.setString(FACTORY_METHOD_ARGUMENT_TYPE, this.myFactoryMethodArgumentType.getID(), true);
        } else {
            argumentMap.remove(FACTORY_METHOD_ARGUMENT_TYPE);
        }
        argumentMap.setString(ADAPTOR_VALUE_CONVERSION_CLASS_NAME, this.myAdaptorValueConversionClassName, true);
        argumentMap.setString(ADAPTOR_VALUE_CONVERSION_METHOD_NAME, this.myAdaptorValueConversionMethodName, true);
        if (this.isPrototyped()) {
            argumentMap.setBoolean(ALLOWS_NULL, this.myAllowsNull, 2);
        } else {
            argumentMap.setBoolean(ALLOWS_NULL, this.myAllowsNull, 3);
        }
        argumentMap.setString(DEFINITION, this.myDefinition, true);
        this.writeUserInfo(argumentMap);
        return argumentMap;
    }

    protected boolean isPrototyped() {
        return false;
    }

    public EOModelMap getArgumentMap() {
        return this.myArgumentMap;
    }

    public String toString() {
        return "[EOArgument: " + this.myName + "]";
    }
}

