/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.baseforplugins.util.StringUtils;
import org.objectstyle.wolips.eomodeler.core.Messages;
import org.objectstyle.wolips.eomodeler.core.model.AbstractEOAttributePath;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateNameException;
import org.objectstyle.wolips.eomodeler.core.model.EOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.EOAttributePath;
import org.objectstyle.wolips.eomodeler.core.model.EODeleteRule;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOFlattenedAttributeRelationshipReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOFlattenedRelationshipRelationshipReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOJoin;
import org.objectstyle.wolips.eomodeler.core.model.EOJoinSemantic;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOModelGroup;
import org.objectstyle.wolips.eomodeler.core.model.EOModelMap;
import org.objectstyle.wolips.eomodeler.core.model.EOModelReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.EORelationshipOptionalityMismatchFailure;
import org.objectstyle.wolips.eomodeler.core.model.EORelationshipPath;
import org.objectstyle.wolips.eomodeler.core.model.IEOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.ISortableEOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.MissingEntityFailure;
import org.objectstyle.wolips.eomodeler.core.model.PropertyListSet;
import org.objectstyle.wolips.eomodeler.core.model.UserInfoableEOModelObject;
import org.objectstyle.wolips.eomodeler.core.utils.BooleanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EORelationship
extends UserInfoableEOModelObject<EOEntity>
implements IEOAttribute,
ISortableEOModelObject {
    public static final String TO_MANY = "toMany";
    public static final String TO_ONE = "toOne";
    public static final String CLASS_PROPERTY = "classProperty";
    public static final String CLIENT_CLASS_PROPERTY = "clientClassProperty";
    public static final String COMMON_CLASS_PROPERTY = "commonClassProperty";
    public static final String NAME = "name";
    public static final String DESTINATION = "destination";
    public static final String DEFINITION = "definition";
    public static final String DELETE_RULE = "deleteRule";
    public static final String JOIN_SEMANTIC = "joinSemantic";
    public static final String OPTIONAL = "optional";
    public static final String MANDATORY = "mandatory";
    public static final String OWNS_DESTINATION = "ownsDestination";
    public static final String PROPAGATES_PRIMARY_KEY = "propagatesPrimaryKey";
    public static final String NUMBER_OF_TO_MANY_FAULTS_TO_BATCH_FETCH = "numberOfToManyFaultsToBatchFetch";
    public static final String JOINS = "joins";
    public static final String JOIN = "join";
    private EOEntity myEntity;
    private EOEntity myDestination;
    private String myName;
    private String myDefinition;
    private EORelationshipPath myDefinitionPath;
    private Boolean myMandatory;
    private Boolean myToMany;
    private Boolean myOwnsDestination;
    private Boolean myPropagatesPrimaryKey;
    private Boolean myClassProperty;
    private Boolean myClientClassProperty;
    private Boolean _commonClassProperty;
    private Integer myNumberOfToManyFaultsToBatchFetch;
    private EODeleteRule myDeleteRule;
    private EOJoinSemantic myJoinSemantic;
    private List<EOJoin> myJoins = new LinkedList<EOJoin>();
    private EOModelMap myRelationshipMap = new EOModelMap();
    private EOEntity myEntityBeforeCloning;

    public EORelationship() {
        this.myDeleteRule = EODeleteRule.getDeleteRuleByID(null);
        this.myJoinSemantic = EOJoinSemantic.getJoinSemanticByID(null);
    }

    public EORelationship(String _name) {
        this();
        this.myName = _name;
    }

    public EORelationship(String _name, String _definition) {
        this(_name);
        this.myDefinition = _definition;
    }

    @Override
    public Set<EOModelReferenceFailure> getReferenceFailures() {
        HashSet<EOModelReferenceFailure> referenceFailures = new HashSet<EOModelReferenceFailure>();
        for (EORelationship referencingRelationship : this.getReferencingFlattenedRelationships()) {
            referenceFailures.add(new EOFlattenedRelationshipRelationshipReferenceFailure(referencingRelationship, this));
        }
        for (EOAttribute referencingAttributes : this.getReferencingFlattenedAttributes()) {
            referenceFailures.add(new EOFlattenedAttributeRelationshipReferenceFailure(referencingAttributes, this));
        }
        return referenceFailures;
    }

    public List<EOAttribute> getReferencingFlattenedAttributes() {
        LinkedList<EOAttribute> referencingFlattenedAttributes = new LinkedList<EOAttribute>();
        if (this.myEntity != null) {
            for (EOModel model : this.getEntity().getModel().getModelGroup().getModels()) {
                for (EOEntity entity : model.getEntities()) {
                    for (EOAttribute attribute : entity.getAttributes()) {
                        EOAttributePath attributePath;
                        if (!attribute.isFlattened() || (attributePath = attribute.getDefinitionPath()) == null || !attributePath.isRelatedTo(this)) continue;
                        referencingFlattenedAttributes.add(attribute);
                    }
                }
            }
        }
        return referencingFlattenedAttributes;
    }

    public List<EORelationship> getReferencingFlattenedRelationships() {
        LinkedList<EORelationship> referencingFlattenedRelationships = new LinkedList<EORelationship>();
        if (this.myEntity != null) {
            for (EOModel model : this.getEntity().getModel().getModelGroup().getModels()) {
                for (EOEntity entity : model.getEntities()) {
                    for (EORelationship relationship : entity.getRelationships()) {
                        EORelationshipPath relationshipPath;
                        if (!relationship.isFlattened() || (relationshipPath = relationship.getDefinitionPath()) == null || !relationshipPath.isRelatedTo(this)) continue;
                        referencingFlattenedRelationships.add(relationship);
                    }
                }
            }
        }
        return referencingFlattenedRelationships;
    }

    public void pasted() throws DuplicateNameException {
        if (this.myEntityBeforeCloning != null) {
            if (this.myDestination == this.myEntityBeforeCloning) {
                this.myDestination = this.myEntity;
            } else if (this.myDestination != null) {
                EOModel model = this.myEntity.getModel();
                EOModelGroup modelGroup = model.getModelGroup();
                this.myDestination = modelGroup.getEntityNamed(this.myDestination.getName());
            }
            for (EOJoin join : this.myJoins) {
                join.pasted();
            }
            this.myEntityBeforeCloning = null;
        }
    }

    protected void _joinChanged(EOJoin _join, String _propertyName, Object _oldValue, Object _newValue) {
        this.firePropertyChange(JOIN, null, _join);
    }

    @Override
    protected void _propertyChanged(String _propertyName, Object _oldValue, Object _newValue) {
        if (this.myEntity != null) {
            this.myEntity._relationshipChanged(this, _propertyName, _oldValue, _newValue);
        }
    }

    public boolean isInverseRelationship(EORelationship _relationship) {
        boolean isInverse;
        if (_relationship == null) {
            isInverse = false;
        } else {
            LinkedList<EOJoin> inverseJoins = new LinkedList<EOJoin>(_relationship.getJoins());
            if (inverseJoins.size() != this.myJoins.size()) {
                isInverse = false;
            } else {
                Iterator<EOJoin> joinsIter = this.myJoins.iterator();
                isInverse = true;
                while (isInverse && joinsIter.hasNext()) {
                    EOJoin join = joinsIter.next();
                    EOJoin inverseJoin = null;
                    int inverseJoinsSize = inverseJoins.size();
                    int inverseJoinNum = 0;
                    while (inverseJoin == null && inverseJoinNum < inverseJoinsSize) {
                        EOJoin potentialInverseJoin = (EOJoin)inverseJoins.get(inverseJoinNum);
                        if (potentialInverseJoin.isInverseJoin(join)) {
                            inverseJoin = potentialInverseJoin;
                        }
                        ++inverseJoinNum;
                    }
                    if (inverseJoin != null) continue;
                    isInverse = false;
                }
            }
        }
        return isInverse;
    }

    public EORelationship getInverseRelationship() {
        EORelationship inverseRelationship = null;
        if (this.myDestination != null) {
            Iterator<EORelationship> relationshipsIter = this.myDestination.getRelationships().iterator();
            while (inverseRelationship == null && relationshipsIter.hasNext()) {
                EORelationship potentialInverseRelationship = relationshipsIter.next();
                if (!potentialInverseRelationship.isInverseRelationship(this)) continue;
                inverseRelationship = potentialInverseRelationship;
            }
        }
        return inverseRelationship;
    }

    public EORelationship createInverseRelationshipNamed(String _name, boolean _toMany) {
        EORelationship inverseRelationship = new EORelationship(this.myDestination.findUnusedRelationshipName(_name));
        inverseRelationship.setClassProperty(this.getClassProperty());
        inverseRelationship.setToMany(_toMany);
        inverseRelationship.setDestination(this.myEntity);
        for (EOJoin join : this.getJoins()) {
            join.addInverseJoinInto(inverseRelationship, false);
        }
        inverseRelationship._setEntity(this.myDestination);
        return inverseRelationship;
    }

    public boolean isRelatedTo(EOEntity _entity) {
        return _entity.equals(this.myDestination);
    }

    public boolean isRelatedTo(EOAttribute _attribute) {
        boolean isRelated = false;
        Iterator<EOJoin> joinsIter = this.myJoins.iterator();
        while (!isRelated && joinsIter.hasNext()) {
            EOJoin join = joinsIter.next();
            isRelated = join.isRelatedTo(_attribute);
        }
        return isRelated;
    }

    public Set<EOAttribute> getRelatedAttributes() {
        HashSet<EOAttribute> relatedAttributes = new HashSet<EOAttribute>();
        for (EOJoin join : this.myJoins) {
            EOAttribute destinationAttribute;
            EOAttribute sourceAttribute = join.getSourceAttribute();
            if (sourceAttribute != null) {
                relatedAttributes.add(sourceAttribute);
            }
            if ((destinationAttribute = join.getDestinationAttribute()) == null) continue;
            relatedAttributes.add(destinationAttribute);
        }
        return relatedAttributes;
    }

    public void setDefinition(String _definition) {
        String oldDefinition = this.myDefinition;
        this.myDefinition = _definition;
        this.updateDefinitionPath();
        this.firePropertyChange(DEFINITION, oldDefinition, this.myDefinition);
    }

    public String getDefinition() {
        String definition = this.isFlattened() && this.myDefinitionPath != null ? this.myDefinitionPath.toKeyPath() : this._getDefinition();
        return definition;
    }

    public EORelationshipPath getDefinitionPath() {
        if (this.myDefinitionPath == null) {
            this.updateDefinitionPath();
        }
        return this.myDefinitionPath;
    }

    public String _getDefinition() {
        return this.myDefinition;
    }

    public void updateDefinitionBecauseRelationshipNameChanged(EORelationship relationship) {
        EORelationshipPath definitionPath;
        if (this.isFlattened() && (definitionPath = this.getDefinitionPath()) != null && definitionPath.isRelatedTo(relationship)) {
            this.setDefinition(definitionPath.toKeyPath());
        }
    }

    protected void updateDefinitionPath() {
        if (this.isFlattened()) {
            EOEntity entity = this.getEntity();
            if (entity != null) {
                AbstractEOAttributePath definitionPath = entity.resolveKeyPath(this._getDefinition());
                this.myDefinitionPath = definitionPath instanceof EORelationshipPath && definitionPath.isValid() ? (EORelationshipPath)definitionPath : null;
            } else {
                this.myDefinition = null;
            }
        } else {
            this.myDefinitionPath = null;
        }
    }

    @Override
    public void setClassProperty(Boolean _classProperty) {
        this.setClassProperty(_classProperty, true);
    }

    @Override
    public void setClassProperty(Boolean _classProperty, boolean _fireEvents) {
        Boolean oldClassProperty = this.myClassProperty;
        this.myClassProperty = _classProperty;
        if (_fireEvents) {
            this.firePropertyChange(CLASS_PROPERTY, oldClassProperty, this.myClassProperty);
        }
    }

    @Override
    public Boolean isClassProperty() {
        return this.myClassProperty;
    }

    @Override
    public Boolean getClassProperty() {
        return this.isClassProperty();
    }

    @Override
    public void setCommonClassProperty(Boolean commonClassProperty) {
        this.setCommonClassProperty(commonClassProperty, true);
    }

    @Override
    public void setCommonClassProperty(Boolean commonClassProperty, boolean fireEvents) {
        Boolean oldCommonClassProperty = this._commonClassProperty;
        this._commonClassProperty = commonClassProperty;
        if (fireEvents) {
            this.firePropertyChange(COMMON_CLASS_PROPERTY, oldCommonClassProperty, this._commonClassProperty);
        }
    }

    @Override
    public Boolean isCommonClassProperty() {
        return this._commonClassProperty;
    }

    @Override
    public Boolean getCommonClassProperty() {
        return this.isCommonClassProperty();
    }

    @Override
    public void setClientClassProperty(Boolean _clientClassProperty) {
        this.setClientClassProperty(_clientClassProperty, true);
    }

    @Override
    public void setClientClassProperty(Boolean _clientClassProperty, boolean _fireEvents) {
        Boolean oldClientClassProperty = this.myClientClassProperty;
        this.myClientClassProperty = _clientClassProperty;
        if (_fireEvents) {
            this.firePropertyChange(CLIENT_CLASS_PROPERTY, oldClientClassProperty, this.myClientClassProperty);
        }
    }

    @Override
    public Boolean isClientClassProperty() {
        return this.myClientClassProperty;
    }

    @Override
    public Boolean getClientClassProperty() {
        return this.isClientClassProperty();
    }

    @Override
    public boolean isFlattened() {
        return StringUtils.isKeyPath((String)this._getDefinition());
    }

    public EORelationship getParentRelationship() {
        EORelationship parentRelationship = null;
        EOEntity parent = this.myEntity.getParent();
        if (parent != null) {
            parentRelationship = parent.getRelationshipNamed(this.myName);
        }
        return parentRelationship;
    }

    @Override
    public boolean isInherited() {
        return this.getParentRelationship() != null;
    }

    public void _setEntity(EOEntity _entity) {
        this.myEntity = _entity;
    }

    @Override
    public EOEntity getEntity() {
        return this.myEntity;
    }

    @Override
    public void setName(String _name) throws DuplicateNameException {
        this.setName(_name, true);
    }

    @Override
    public void setName(String _name, boolean _fireEvents) throws DuplicateNameException {
        if (_name == null) {
            throw new NullPointerException(Messages.getString("EORelationship.noBlankRelationshipNames"));
        }
        String oldName = this.myName;
        if (this.myEntity != null) {
            this.myEntity._checkForDuplicateRelationshipName(this, _name, null);
        }
        this.myName = _name;
        if (this.myEntity != null && this.myEntity.getModel() != null) {
            EOModelGroup modelGroup = this.myEntity.getModel().getModelGroup();
            for (EOEntity entity : modelGroup.getEntities()) {
                for (EOAttribute attribute : entity.getAttributes()) {
                    attribute.updateDefinitionBecauseRelationshipNameChanged(this);
                }
                for (EORelationship relationship : entity.getRelationships()) {
                    relationship.updateDefinitionBecauseRelationshipNameChanged(this);
                }
            }
        }
        if (_fireEvents) {
            this.firePropertyChange(NAME, oldName, this.myName);
        }
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public String getUppercaseName() {
        return this.getName().toUpperCase();
    }

    public String getUppercaseUnderscoreName() {
        return StringUtils.camelCaseToUnderscore((String)this.getName()).toUpperCase();
    }

    public String getCapitalizedName() {
        String name = this.getName();
        if (name != null) {
            name = StringUtils.toUppercaseFirstLetter((String)name);
        }
        return name;
    }

    public EODeleteRule getDeleteRule() {
        return this.myDeleteRule;
    }

    public void setDeleteRule(EODeleteRule _deleteRule) {
        EODeleteRule oldDeleteRule = this.myDeleteRule;
        this.myDeleteRule = _deleteRule;
        this.firePropertyChange(DELETE_RULE, oldDeleteRule, this.myDeleteRule);
    }

    public EOEntity getActualDestination() {
        EOEntity destination = this.getDestination();
        if (destination != null && destination.isPartialEntitySet()) {
            destination = destination.getPartialEntity();
        }
        return destination;
    }

    public EOEntity getDestination() {
        AbstractEOAttributePath targetAttributePath;
        EOEntity destination = this.isFlattened() ? ((targetAttributePath = this.myEntity.resolveKeyPath(this.getDefinition())) != null && targetAttributePath.getChildIEOAttribute() != null ? ((EORelationshipPath)targetAttributePath).getChildRelationship().getDestination() : null) : this.myDestination;
        return destination;
    }

    public void setDestination(EOEntity _destination) {
        this.setDestination(_destination, true);
    }

    public void setDestination(EOEntity _destination, boolean _fireEvents) {
        EOEntity oldDestination = this.myDestination;
        this.myDestination = _destination;
        if (_fireEvents) {
            this.firePropertyChange(DESTINATION, oldDestination, this.myDestination);
        }
    }

    public EOJoinSemantic getJoinSemantic() {
        return this.myJoinSemantic;
    }

    public void setJoinSemantic(EOJoinSemantic _joinSemantic) {
        EOJoinSemantic oldJoinSemantic = this.myJoinSemantic;
        this.myJoinSemantic = _joinSemantic;
        this.firePropertyChange(JOIN_SEMANTIC, oldJoinSemantic, this.myJoinSemantic);
    }

    public Boolean getMandatory() {
        return this.isMandatory();
    }

    public Boolean isMandatory() {
        return this.myMandatory;
    }

    public void setMandatory(Boolean _mandatory) {
        EOEntity entity;
        this._setMandatory(_mandatory);
        if (BooleanUtils.isTrue(this.isToOne()) && (entity = this.getEntity()) != null && !entity.isSingleTableInheritance()) {
            for (EOJoin join : this.getJoins()) {
                EOAttribute sourceAttribute = join.getSourceAttribute();
                if (sourceAttribute == null) continue;
                sourceAttribute._setAllowsNull(BooleanUtils.negate(_mandatory), true);
            }
        }
    }

    public void _setMandatory(Boolean _mandatory) {
        Boolean oldMandatory = this.myMandatory;
        this.myMandatory = _mandatory;
        this.firePropertyChange(MANDATORY, oldMandatory, this.myMandatory);
        this.firePropertyChange(OPTIONAL, BooleanUtils.negate(oldMandatory), BooleanUtils.negate(this.myMandatory));
    }

    public void setMandatoryIfNecessary() {
        boolean mandatory = false;
        if (BooleanUtils.isTrue(this.isToOne())) {
            Iterator<EOJoin> joinsIter = this.getJoins().iterator();
            while (!mandatory && joinsIter.hasNext()) {
                EOJoin join = joinsIter.next();
                EOAttribute sourceAttribute = join.getSourceAttribute();
                if (sourceAttribute == null) continue;
                mandatory = BooleanUtils.isFalse(sourceAttribute.isAllowsNull());
            }
        }
        this.setMandatory(mandatory);
    }

    public Boolean getOptional() {
        return this.isOptional();
    }

    public Boolean isOptional() {
        return BooleanUtils.negate(this.isMandatory());
    }

    public void setOptional(Boolean _optional) {
        this.setMandatory(BooleanUtils.negate(_optional));
    }

    public Boolean getOwnsDestination() {
        return this.isOwnsDestination();
    }

    public Boolean isOwnsDestination() {
        return this.myOwnsDestination;
    }

    public void setOwnsDestination(Boolean _ownsDestination) {
        Boolean oldOwnsDestination = this.myOwnsDestination;
        this.myOwnsDestination = _ownsDestination;
        this.firePropertyChange(OWNS_DESTINATION, oldOwnsDestination, this.myOwnsDestination);
    }

    public Boolean getPropagatesPrimaryKey() {
        return this.isPropagatesPrimaryKey();
    }

    public Boolean isPropagatesPrimaryKey() {
        return this.myPropagatesPrimaryKey;
    }

    public void setPropagatesPrimaryKey(Boolean _propagatesPrimaryKey) {
        Boolean oldPropagatesPrimaryKey = this.myPropagatesPrimaryKey;
        this.myPropagatesPrimaryKey = _propagatesPrimaryKey;
        this.firePropertyChange(PROPAGATES_PRIMARY_KEY, oldPropagatesPrimaryKey, this.myPropagatesPrimaryKey);
    }

    public Boolean getToMany() {
        return this.isToMany();
    }

    @Override
    public Boolean isToMany() {
        Boolean toMany = null;
        if (this.isFlattened() && this.myEntity != null) {
            AbstractEOAttributePath targetAttributePath = this.myEntity.resolveKeyPath(this.getDefinition());
            if (targetAttributePath != null && targetAttributePath.getChildIEOAttribute() != this) {
                toMany = targetAttributePath.isToMany();
            }
        } else {
            toMany = this.myToMany;
        }
        return toMany;
    }

    public void setToMany(Boolean _toMany) {
        if (!this.isFlattened()) {
            Boolean oldToMany = this.myToMany;
            this.myToMany = _toMany;
            this.firePropertyChange(TO_MANY, oldToMany, this.myToMany);
            this.firePropertyChange(TO_ONE, BooleanUtils.negate(oldToMany), BooleanUtils.negate(this.myToMany));
        }
    }

    public Boolean getToOne() {
        return this.isToOne();
    }

    public Boolean isToOne() {
        return BooleanUtils.negate(this.isToMany());
    }

    public void setToOne(Boolean _toOne) {
        this.setToMany(BooleanUtils.negate(_toOne));
    }

    public void setNumberOfToManyFaultsToBatchFetch(Integer _numberOfToManyFaultsToBatchFetch) {
        Integer oldNumberOfToManyFaultsToBatchFetch = this.myNumberOfToManyFaultsToBatchFetch;
        this.myNumberOfToManyFaultsToBatchFetch = _numberOfToManyFaultsToBatchFetch;
        this.firePropertyChange(NUMBER_OF_TO_MANY_FAULTS_TO_BATCH_FETCH, oldNumberOfToManyFaultsToBatchFetch, this.myNumberOfToManyFaultsToBatchFetch);
    }

    public Integer getNumberOfToManyFaultsToBatchFetch() {
        return this.myNumberOfToManyFaultsToBatchFetch;
    }

    public void clearJoins() {
        this.myJoins.clear();
        this.firePropertyChange(JOINS, null, null);
    }

    public void setJoins(List<EOJoin> _joins) {
        this.myJoins.clear();
        this.myJoins.addAll(_joins);
        this.firePropertyChange(JOINS, null, null);
    }

    public void addJoin(EOJoin _join) {
        this.addJoin(_join, true);
    }

    public void addJoin(EOJoin _join, boolean _fireEvents) {
        _join._setRelationship(this);
        List<EOJoin> oldJoins = null;
        if (_fireEvents) {
            oldJoins = this.myJoins;
            LinkedList<EOJoin> newJoins = new LinkedList<EOJoin>();
            newJoins.addAll(this.myJoins);
            newJoins.add(_join);
            this.myJoins = newJoins;
            this.firePropertyChange(JOINS, oldJoins, this.myJoins);
        } else {
            this.myJoins.add(_join);
        }
    }

    public void removeAllJoins() {
        List<EOJoin> oldJoins = this.myJoins;
        LinkedList<EOJoin> newJoins = new LinkedList<EOJoin>();
        this.myJoins = newJoins;
        this.firePropertyChange(JOINS, oldJoins, newJoins);
        for (EOJoin join : oldJoins) {
            join._setRelationship(null);
        }
    }

    public void removeJoin(EOJoin _join) {
        List<EOJoin> oldJoins = this.myJoins;
        LinkedList<EOJoin> newJoins = new LinkedList<EOJoin>();
        newJoins.addAll(this.myJoins);
        newJoins.remove(_join);
        this.myJoins = newJoins;
        this.firePropertyChange(JOINS, oldJoins, newJoins);
        _join._setRelationship(null);
    }

    public List<EOJoin> getJoins() {
        return this.myJoins;
    }

    public EOJoin getFirstJoin() {
        EOJoin join = null;
        Iterator<EOJoin> joinsIter = this.myJoins.iterator();
        if (joinsIter.hasNext()) {
            join = joinsIter.next();
        }
        return join;
    }

    public void loadFromMap(EOModelMap _relationshipMap, Set<EOModelVerificationFailure> _failures) {
        this.myRelationshipMap = _relationshipMap;
        this.myDefinition = _relationshipMap.containsKey("dataPath") ? _relationshipMap.getString("dataPath", true) : _relationshipMap.getString(DEFINITION, true);
        this.myMandatory = _relationshipMap.getBoolean("isMandatory");
        this.myToMany = _relationshipMap.getBoolean("isToMany");
        String joinSemanticID = _relationshipMap.getString(JOIN_SEMANTIC, true);
        this.myJoinSemantic = EOJoinSemantic.getJoinSemanticByID(joinSemanticID);
        this.myName = _relationshipMap.getString(NAME, true);
        String deleteRuleID = _relationshipMap.getString(DELETE_RULE, true);
        this.myDeleteRule = EODeleteRule.getDeleteRuleByID(deleteRuleID);
        this.myOwnsDestination = _relationshipMap.getBoolean(OWNS_DESTINATION);
        this.myNumberOfToManyFaultsToBatchFetch = _relationshipMap.getInteger(NUMBER_OF_TO_MANY_FAULTS_TO_BATCH_FETCH);
        this.myPropagatesPrimaryKey = _relationshipMap.getBoolean(PROPAGATES_PRIMARY_KEY);
        Set joins = _relationshipMap.getSet(JOINS);
        if (joins != null) {
            for (Map originalJoinMap : joins) {
                EOModelMap joinMap = new EOModelMap(originalJoinMap);
                EOJoin join = new EOJoin();
                join.loadFromMap(joinMap, _failures);
                this.addJoin(join, false);
            }
        }
        this.loadUserInfo(_relationshipMap);
    }

    public EOModelMap toMap() {
        EOModelMap relationshipMap = this.myRelationshipMap.cloneModelMap();
        if (this.myDestination != null) {
            relationshipMap.setString(DESTINATION, this.myDestination.getName(), true);
        } else {
            relationshipMap.remove(DESTINATION);
        }
        relationshipMap.setString(DEFINITION, this.getDefinition(), true);
        relationshipMap.remove("dataPath");
        relationshipMap.setBoolean("isMandatory", this.myMandatory, 3);
        relationshipMap.setBoolean("isToMany", this.myToMany, 2);
        if (!this.isFlattened() && this.myJoinSemantic != null) {
            relationshipMap.setString(JOIN_SEMANTIC, this.myJoinSemantic.getID(), true);
        } else if (this.isFlattened() && this.myRelationshipMap.get(JOIN_SEMANTIC) != null) {
            relationshipMap.setString(JOIN_SEMANTIC, (String)this.myRelationshipMap.get(JOIN_SEMANTIC), true);
        } else {
            relationshipMap.remove(JOIN_SEMANTIC);
        }
        relationshipMap.setString(NAME, this.myName, true);
        if (this.myDeleteRule != null && this.myDeleteRule != EODeleteRule.NULLIFY) {
            relationshipMap.setString(DELETE_RULE, this.myDeleteRule.getID(), true);
        } else {
            relationshipMap.remove(DELETE_RULE);
        }
        relationshipMap.setBoolean(OWNS_DESTINATION, this.myOwnsDestination, 3);
        relationshipMap.setBoolean(PROPAGATES_PRIMARY_KEY, this.myPropagatesPrimaryKey, 3);
        relationshipMap.setInteger(NUMBER_OF_TO_MANY_FAULTS_TO_BATCH_FETCH, this.myNumberOfToManyFaultsToBatchFetch);
        PropertyListSet joins = new PropertyListSet();
        for (EOJoin join : this.myJoins) {
            EOModelMap joinMap = join.toMap();
            joins.add(joinMap);
        }
        relationshipMap.setSet(JOINS, joins, true);
        this.writeUserInfo(relationshipMap);
        if (this.isFlattened() && !ComparisonUtils.deepEquals((Object)relationshipMap, (Object)this.myRelationshipMap)) {
            relationshipMap.remove(JOIN_SEMANTIC);
        }
        return relationshipMap;
    }

    public void resolve(Set<EOModelVerificationFailure> _failures) {
        if (!this.isFlattened()) {
            String destinationName = this.myRelationshipMap.getString(DESTINATION, true);
            if (destinationName == null) {
                _failures.add(new EOModelVerificationFailure(this.myEntity.getModel(), this, "The relationship " + this.getName() + " has no destination entity.", false));
            } else {
                this.myDestination = this.myEntity.getModel().getModelGroup().getEntityNamed(destinationName);
                if (this.myDestination == null) {
                    _failures.add(new MissingEntityFailure(this.myEntity.getModel(), destinationName));
                }
            }
        } else {
            this.updateDefinitionPath();
        }
        for (EOJoin join : this.myJoins) {
            join.resolve(_failures);
        }
    }

    public void verify(Set<EOModelVerificationFailure> _failures) {
        EOEntity entity;
        String name = this.getName();
        if (name == null || name.trim().length() == 0) {
            _failures.add(new EOModelVerificationFailure(this.myEntity.getModel(), this, "The relationship " + this.getName() + " has an empty name.", false));
        } else {
            if (name.indexOf(32) != -1) {
                _failures.add(new EOModelVerificationFailure(this.myEntity.getModel(), this, "The relationship " + this.getName() + "'s name has a space in it.", false));
            }
            if (!StringUtils.isLowercaseFirstLetter((String)name)) {
                _failures.add(new EOModelVerificationFailure(this.myEntity.getModel(), this, "The relationship " + this.getName() + "'s name is capitalized, but should not be.", true));
            }
        }
        if (this.isFlattened()) {
            if (this.myEntity.resolveKeyPath(this.getDefinition()) == null) {
                _failures.add(new EOModelVerificationFailure(this.myEntity.getModel(), this, "The relationship " + this.getName() + " is flattened and either creates a loop or points to a non-existent target.", false));
            }
        } else if (this.myDestination == null) {
            _failures.add(new EOModelVerificationFailure(this.myEntity.getModel(), this, "The relationship " + this.getName() + " has no destination entity.", false));
        }
        boolean singleTableInheritance = (entity = this.getEntity()) != null && entity.isSingleTableInheritance();
        boolean mandatory = BooleanUtils.isTrue(this.isMandatory());
        boolean toOne = BooleanUtils.isTrue(this.isToOne());
        Iterator<EOJoin> joinsIter = this.myJoins.iterator();
        if (!joinsIter.hasNext() && !this.isFlattened()) {
            _failures.add(new EOModelVerificationFailure(this.myEntity.getModel(), this, "The relationship " + this.getName() + " does not have any joins.", false));
        }
        while (joinsIter.hasNext()) {
            EOJoin join = joinsIter.next();
            join.verify(_failures);
            EOAttribute sourceAttribute = join.getSourceAttribute();
            if (toOne && mandatory && !singleTableInheritance && sourceAttribute != null && BooleanUtils.isTrue(sourceAttribute.isAllowsNull())) {
                _failures.add(new EORelationshipOptionalityMismatchFailure(this.myEntity.getModel(), this, "The relationship " + this.getName() + " is mandatory but the attribute " + sourceAttribute.getName() + " allows nulls.", true));
                continue;
            }
            if (!toOne || mandatory || sourceAttribute == null || BooleanUtils.isTrue(sourceAttribute.isAllowsNull())) continue;
            _failures.add(new EORelationshipOptionalityMismatchFailure(this.myEntity.getModel(), this, "The relationship " + this.getName() + " is optional but the attribute " + sourceAttribute.getName() + " does not allow nulls.", true));
        }
    }

    @Override
    public String getFullyQualifiedName() {
        return String.valueOf(this.myEntity == null ? "?" : this.myEntity.getFullyQualifiedName()) + "/rel: " + this.getName();
    }

    public EORelationship _cloneModelObject() {
        EORelationship relationship = new EORelationship(this.myName);
        relationship.myEntityBeforeCloning = this.myEntity == null ? this.myEntityBeforeCloning : this.myEntity;
        relationship.myDestination = this.myDestination;
        relationship.myDefinition = this.myDefinition;
        relationship.myMandatory = this.myMandatory;
        relationship.myToMany = this.myToMany;
        relationship.myOwnsDestination = this.myOwnsDestination;
        relationship.myPropagatesPrimaryKey = this.myPropagatesPrimaryKey;
        relationship.myClassProperty = this.myClassProperty;
        relationship.myClientClassProperty = this.myClientClassProperty;
        relationship.myNumberOfToManyFaultsToBatchFetch = this.myNumberOfToManyFaultsToBatchFetch;
        relationship.myDeleteRule = this.myDeleteRule;
        relationship.myJoinSemantic = this.myJoinSemantic;
        for (EOJoin join : this.myJoins) {
            EOJoin newJoin = join._cloneModelObject();
            relationship.addJoin(newJoin, false);
        }
        this._cloneUserInfoInto(relationship);
        return relationship;
    }

    @Override
    public Class<EOEntity> _getModelParentType() {
        return EOEntity.class;
    }

    @Override
    public EOEntity _getModelParent() {
        return this.getEntity();
    }

    @Override
    public void _removeFromModelParent(Set<EOModelVerificationFailure> failures) {
        if (this.getEntity() != null) {
            this.getEntity().removeRelationship(this, true);
        }
    }

    @Override
    public void _addToModelParent(EOEntity modelParent, boolean findUniqueName, Set<EOModelVerificationFailure> failures) throws EOModelException {
        if (findUniqueName) {
            this.setName(modelParent.findUnusedRelationshipName(this.getName()));
        }
        modelParent.addRelationship(this);
    }

    public boolean getSqlGenerationCreateProperty() {
        return !this.isInherited() || this.getEntity().getSqlGenerationCreateInheritedProperties();
    }

    public String toString() {
        return "[EORelationship: name = " + this.myName + "; destination = " + (this.myDestination == null ? "null" : this.myDestination.getName()) + "; joins = " + this.myJoins + "]";
    }
}

