/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.objectstyle.wolips.eomodeler.core.Activator;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOModelGroup;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IEOModelGroupFactory {
    public boolean loadModelGroup(Object var1, EOModelGroup var2, Set<EOModelVerificationFailure> var3, boolean var4, IProgressMonitor var5) throws EOModelException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Utility {
        public static EOModelGroup loadModelGroup(Object modelGroupResource, Set<EOModelVerificationFailure> failures, boolean skipOnDuplicates, IProgressMonitor progressMonitor) throws EOModelException {
            EOModelGroup modelGroup = new EOModelGroup();
            Utility.loadModelGroup(modelGroupResource, modelGroup, failures, skipOnDuplicates, null, progressMonitor);
            return modelGroup;
        }

        public static EOModelGroup loadModelGroup(Object modelGroupResource, Set<EOModelVerificationFailure> failures, boolean skipOnDuplicates, URL editingModelURL, IProgressMonitor progressMonitor) throws EOModelException {
            EOModelGroup modelGroup = new EOModelGroup();
            Utility.loadModelGroup(modelGroupResource, modelGroup, failures, skipOnDuplicates, editingModelURL, progressMonitor);
            return modelGroup;
        }

        public static void loadModelGroup(Object modelGroupResource, EOModelGroup modelGroup, Set<EOModelVerificationFailure> failures, boolean skipOnDuplicates, URL editingModelURL, IProgressMonitor progressMonitor) throws EOModelException {
            modelGroup.setEditingModelURL(editingModelURL);
            List<IEOModelGroupFactory> modelGroupFactories = Utility.modelGroupFactories();
            for (IEOModelGroupFactory modelGroupFactory : modelGroupFactories) {
                boolean modelsLoaded = modelGroupFactory.loadModelGroup(modelGroupResource, modelGroup, failures, skipOnDuplicates, progressMonitor);
                if (modelsLoaded) break;
            }
            progressMonitor.setTaskName("Resolving model dependencies ...");
            modelGroup.resolve(failures);
            progressMonitor.setTaskName("Verifying model ...");
            modelGroup.verify(failures);
        }

        public static List<IEOModelGroupFactory> modelGroupFactories() {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.objectstyle.wolips.eomodeler.eomodelGroupFactory");
            IExtension[] extensions = extensionPoint.getExtensions();
            LinkedList<IEOModelGroupFactory> modelGroupFactories = new LinkedList<IEOModelGroupFactory>();
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configurationElements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configurationElements = extension.getConfigurationElements();
                int n3 = configurationElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    try {
                        IEOModelGroupFactory modelGroupFactory = (IEOModelGroupFactory)configurationElement.createExecutableExtension("class");
                        modelGroupFactories.add(modelGroupFactory);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        Activator.getDefault().log("Could not create EOModelGroup factory from configuration element: " + configurationElement, e);
                    }
                    ++n4;
                }
                ++n2;
            }
            return modelGroupFactories;
        }
    }
}

