/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.sql;

import java.util.LinkedList;
import java.util.List;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.objectstyle.wolips.eomodeler.core.Activator;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOEntityForest;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.thirdparty.velocity.WOLipsVelocityUtils;
import org.objectstyle.wolips.thirdparty.velocity.resourceloader.ResourceLoader;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationGenerator {
    public static String generate(EOModel model, List<EOEntity> entities) throws Exception {
        List<Object> generateEntities;
        if (entities == null || entities.isEmpty()) {
            generateEntities = new LinkedList();
            for (EOEntity entity : model.getEntities()) {
                if (entity.isPrototype()) continue;
                generateEntities.add(entity);
            }
        } else {
            generateEntities = entities;
        }
        EOEntityForest entityForest = new EOEntityForest();
        entityForest.add(generateEntities);
        generateEntities = entityForest.breadthFirst();
        VelocityEngine velocityEngine = WOLipsVelocityUtils.createVelocityEngine((String)"EOGenerator", (Bundle)Activator.getDefault().getBundle(), null, null, (boolean)true, ResourceLoader.class);
        VelocityContext context = new VelocityContext();
        LinkedList<String> entityMigrations = new LinkedList<String>();
        for (EOEntity eOEntity : generateEntities) {
            context.put("entity", (Object)eOEntity);
            String entityMigration = WOLipsVelocityUtils.writeTemplateToString((VelocityEngine)velocityEngine, (VelocityContext)context, (String)"EntityMigration0.java");
            entityMigrations.add(entityMigration);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (EOEntity eOEntity : generateEntities) {
            context.put("entity", (Object)eOEntity);
            String foreignKeyMigration = WOLipsVelocityUtils.writeTemplateToString((VelocityEngine)velocityEngine, (VelocityContext)context, (String)"ForeignKeyMigration0.java");
            linkedList.add(foreignKeyMigration);
        }
        context.remove((Object)"entity");
        context.put("model", (Object)model);
        context.put("entityMigrations", entityMigrations);
        context.put("foreignKeyMigrations", linkedList);
        String string = WOLipsVelocityUtils.writeTemplateToString((VelocityEngine)velocityEngine, (VelocityContext)context, (String)"Migration0.java");
        return string;
    }
}

