/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.parser;

import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.HandlerBase;
import com.steadystate.css.parser.LexicalUnitImpl;
import java.io.FileReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.helpers.ParserFactory;

public class ParseTest
extends HandlerBase {
    private static final String PARSER = "com.steadystate.css.parser.SACParser";
    private int _propertyCounter = 0;
    private int _indentSize = 0;

    public ParseTest() {
        try {
            CSSOMParser.setProperty("org.w3c.css.sac.parser", PARSER);
            ParserFactory parserFactory = new ParserFactory();
            Parser parser = parserFactory.makeParser();
            parser.setDocumentHandler(this);
            FileReader fileReader = new FileReader("c:\\working\\css2parser\\stylesheets\\page_test.css");
            InputSource inputSource = new InputSource(fileReader);
            parser.parseStyleSheet(inputSource);
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        new ParseTest();
    }

    public void startDocument(InputSource inputSource) throws CSSException {
        System.out.println("startDocument");
    }

    public void endDocument(InputSource inputSource) throws CSSException {
        System.out.println("endDocument");
    }

    public void comment(String string) throws CSSException {
    }

    public void ignorableAtRule(String string) throws CSSException {
        System.out.println(string);
    }

    public void namespaceDeclaration(String string, String string2) throws CSSException {
    }

    public void importStyle(String string, SACMediaList sACMediaList, String string2) throws CSSException {
        System.out.print("@import url(" + string + ")");
        if (sACMediaList.getLength() > 0) {
            System.out.println(" " + sACMediaList.toString() + ";");
        } else {
            System.out.println(";");
        }
    }

    public void startMedia(SACMediaList sACMediaList) throws CSSException {
        System.out.println(this.indent() + "@media " + sACMediaList.toString() + " {");
        this.incIndent();
    }

    public void endMedia(SACMediaList sACMediaList) throws CSSException {
        this.decIndent();
        System.out.println(this.indent() + "}");
    }

    public void startPage(String string, String string2) throws CSSException {
        System.out.print(this.indent() + "@page");
        if (string != null) {
            System.out.print(" " + string);
        }
        if (string2 != null) {
            System.out.println(" " + string2);
        }
        System.out.println(" {");
        this._propertyCounter = 0;
        this.incIndent();
    }

    public void endPage(String string, String string2) throws CSSException {
        System.out.println();
        this.decIndent();
        System.out.println(this.indent() + "}");
    }

    public void startFontFace() throws CSSException {
        System.out.println(this.indent() + "@font-face {");
        this._propertyCounter = 0;
        this.incIndent();
    }

    public void endFontFace() throws CSSException {
        System.out.println();
        this.decIndent();
        System.out.println(this.indent() + "}");
    }

    public void startSelector(SelectorList selectorList) throws CSSException {
        System.out.println(this.indent() + selectorList.toString() + " {");
        this._propertyCounter = 0;
        this.incIndent();
    }

    public void endSelector(SelectorList selectorList) throws CSSException {
        System.out.println();
        this.decIndent();
        System.out.println(this.indent() + "}");
    }

    public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
        if (this._propertyCounter++ > 0) {
            System.out.println(";");
        }
        System.out.print(this.indent() + string + ":");
        LexicalUnit lexicalUnit2 = lexicalUnit;
        while (lexicalUnit2 != null) {
            System.out.print(" " + ((LexicalUnitImpl)lexicalUnit2).toDebugString());
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
        }
        if (bl) {
            System.out.print(" !important");
        }
    }

    private String indent() {
        StringBuffer stringBuffer = new StringBuffer(16);
        int n = 0;
        while (n < this._indentSize) {
            stringBuffer.append(" ");
            ++n;
        }
        return stringBuffer.toString();
    }

    private void incIndent() {
        this._indentSize += 4;
    }

    private void decIndent() {
        this._indentSize -= 4;
    }
}

