/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.internal;

import java.util.HashMap;
import java.util.Map;
import jp.aonir.fuzzyxml.internal.RenderDelegate;

public class RenderContext {
    private int _indent;
    private int _indentSize = 0;
    private boolean _showNewlines = false;
    private boolean _indentTabs = false;
    private boolean _html;
    private boolean _addMissingQuotes;
    private boolean _spaceInEmptyTags;
    private boolean _spacesAroundEquals;
    private boolean _trim;
    private boolean _lowercaseTags;
    private boolean _lowercaseAttributes;
    private RenderDelegate _delegate;
    private Map<String, Object> _attributes;
    private boolean _shouldFormat;

    public RenderContext(boolean html) {
        this._html = html;
        this._shouldFormat = true;
        this._attributes = new HashMap<String, Object>();
    }

    public void setShouldFormat(boolean shouldFormat) {
        this._shouldFormat = shouldFormat;
    }

    public boolean shouldFormat() {
        return this._shouldFormat;
    }

    public void setAttribute(String key, Object value) {
        this._attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        return this._attributes.get(key);
    }

    public void setDelegate(RenderDelegate delegate) {
        this._delegate = delegate;
    }

    public RenderDelegate getDelegate() {
        return this._delegate;
    }

    public void setLowercaseTags(boolean lowercaseTags) {
        this._lowercaseTags = lowercaseTags;
    }

    public boolean isLowercaseTags() {
        return this._lowercaseTags;
    }

    public void setLowercaseAttributes(boolean lowercaseAttributes) {
        this._lowercaseAttributes = lowercaseAttributes;
    }

    public boolean isLowercaseAttributes() {
        return this._lowercaseAttributes;
    }

    public void setSpaceInEmptyTags(boolean spaceInEmptyTags) {
        this._spaceInEmptyTags = spaceInEmptyTags;
    }

    public boolean isSpaceInEmptyTags() {
        return this._spaceInEmptyTags;
    }

    public void setSpacesAroundEquals(boolean spacesAroundEquals) {
        this._spacesAroundEquals = spacesAroundEquals;
    }

    public boolean isSpacesAroundEquals() {
        return this._spacesAroundEquals;
    }

    public void setTrim(boolean trim) {
        this._trim = trim;
    }

    public boolean isTrim() {
        return this._trim;
    }

    public void setAddMissingQuotes(boolean addMissingQuotes) {
        this._addMissingQuotes = addMissingQuotes;
    }

    public boolean isAddMissingQuotes() {
        return this._addMissingQuotes;
    }

    public void setShowNewlines(boolean newlines) {
        this._showNewlines = newlines;
    }

    public boolean isShowNewlines() {
        return this._showNewlines;
    }

    public void setHtml(boolean html) {
        this._html = html;
    }

    public boolean isHtml() {
        return this._html;
    }

    public void setIndentTabs(boolean indentTabs) {
        this._indentTabs = indentTabs;
    }

    public boolean isIndentTabs() {
        return this._indentTabs;
    }

    public void setIndent(int indent) {
        this._indent = indent;
    }

    public int getIndent() {
        return this._indent;
    }

    public void appendIndent(StringBuffer sb) {
        for (int indentNum = 0; indentNum < this._indent; ++indentNum) {
            if (this._indentTabs) {
                sb.append("\t");
                continue;
            }
            for (int spaceNum = 0; spaceNum < this._indentSize; ++spaceNum) {
                sb.append(" ");
            }
        }
    }

    public void indent() {
        ++this._indent;
    }

    public void outdent() {
        --this._indent;
    }

    public int getIndentSize() {
        return this._indentSize;
    }

    public void setIndentSize(int indentSize) {
        this._indentSize = indentSize;
    }

    public RenderContext clone() {
        RenderContext clone = new RenderContext(this.isHtml());
        clone._addMissingQuotes = this._addMissingQuotes;
        clone._attributes = this._attributes;
        clone._delegate = this._delegate;
        clone._indent = this._indent;
        clone._indentSize = this._indentSize;
        clone._indentTabs = this._indentTabs;
        clone._lowercaseAttributes = this._lowercaseAttributes;
        clone._lowercaseTags = this._lowercaseTags;
        clone._shouldFormat = this._shouldFormat;
        clone._showNewlines = this._showNewlines;
        clone._spaceInEmptyTags = this._spaceInEmptyTags;
        clone._spacesAroundEquals = this._spacesAroundEquals;
        clone._trim = this._trim;
        return clone;
    }
}

