/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.gefutils;

import java.text.MessageFormat;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public abstract class AbstractDialogPropertyDescriptor
extends PropertyDescriptor {
    public AbstractDialogPropertyDescriptor(Object id, String displayName) {
        super(id, displayName);
    }

    public CellEditor createPropertyEditor(Composite parent) {
        ValueCellEditor editor = new ValueCellEditor(parent);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    protected abstract Object openDialogBox(Object var1, Control var2);

    protected class ValueCellEditor
    extends CellEditor {
        private Text _text;
        private Composite _editor;
        private Button _button;
        private boolean _isSelection;
        private boolean _isDeleteable;
        private boolean _isSelectable;
        private Object _value;

        public ValueCellEditor(Composite parent) {
            super(parent, 0);
            this._isSelection = false;
            this._isDeleteable = false;
            this._isSelectable = false;
            this._value = null;
        }

        protected Control createControl(Composite parent) {
            Font font = parent.getFont();
            Color bg = parent.getBackground();
            this._editor = new Composite(parent, this.getStyle());
            this._editor.setFont(font);
            this._editor.setBackground(bg);
            this._editor.setLayout((Layout)new DialogCellLayout());
            this._text = new Text(this._editor, 0);
            this._text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\u001b') {
                        ValueCellEditor.this.fireCancelEditor();
                    } else if (e.character == '\r') {
                        String newValue = ValueCellEditor.this._text.getText();
                        ValueCellEditor.this.updateValue(newValue);
                    }
                }

                public void keyPressed(KeyEvent e) {
                    ValueCellEditor.this.checkSelection();
                    ValueCellEditor.this.checkDeleteable();
                    ValueCellEditor.this.checkSelectable();
                }
            });
            this._text.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    ValueCellEditor.this.checkSelection();
                    ValueCellEditor.this.checkDeleteable();
                    ValueCellEditor.this.checkSelectable();
                }
            });
            this._text.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    String newValue = ValueCellEditor.this._text.getText();
                    ValueCellEditor.this.updateValue(newValue);
                }
            });
            this._text.setFont(parent.getFont());
            this._text.setBackground(parent.getBackground());
            this._button = new Button(this._editor, 1024);
            this._button.setText("...");
            this._button.setFont(font);
            this._button.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\u001b') {
                        ValueCellEditor.this.fireCancelEditor();
                    }
                }
            });
            this._button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Object newValue = ValueCellEditor.this.openDialogBox((Control)ValueCellEditor.this._editor);
                    if (newValue != null) {
                        ValueCellEditor.this.updateValue(newValue);
                    }
                }
            });
            this.setValueValid(true);
            this.updateContents(this._value);
            return this._editor;
        }

        private void updateValue(Object newValue) {
            if (newValue != null) {
                boolean newValidState = this.isCorrect(newValue);
                if (newValidState) {
                    this.markDirty();
                    this.doSetValue(newValue);
                } else {
                    this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), newValue.toString()));
                }
                this.fireApplyEditorValue();
            }
        }

        protected Object doGetValue() {
            return this._value;
        }

        protected void doSetFocus() {
            this._button.setFocus();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }

        protected void doSetValue(Object value) {
            this._value = value;
            this.updateContents(value);
        }

        private void checkDeleteable() {
            boolean oldIsDeleteable = this._isDeleteable;
            this._isDeleteable = this.isDeleteEnabled();
            if (oldIsDeleteable != this._isDeleteable) {
                this.fireEnablementChanged("delete");
            }
        }

        private void checkSelectable() {
            boolean oldIsSelectable = this._isSelectable;
            this._isSelectable = this.isSelectAllEnabled();
            if (oldIsSelectable != this._isSelectable) {
                this.fireEnablementChanged("selectall");
            }
        }

        private void checkSelection() {
            boolean oldIsSelection = this._isSelection;
            boolean bl = this._isSelection = this._text.getSelectionCount() > 0;
            if (oldIsSelection != this._isSelection) {
                this.fireEnablementChanged("copy");
                this.fireEnablementChanged("cut");
            }
        }

        public boolean isCopyEnabled() {
            if (this._text == null || this._text.isDisposed()) {
                return false;
            }
            return this._text.getSelectionCount() > 0;
        }

        public boolean isCutEnabled() {
            if (this._text == null || this._text.isDisposed()) {
                return false;
            }
            return this._text.getSelectionCount() > 0;
        }

        public boolean isDeleteEnabled() {
            if (this._text == null || this._text.isDisposed()) {
                return false;
            }
            return this._text.getSelectionCount() > 0 || this._text.getCaretPosition() < this._text.getCharCount();
        }

        public boolean isPasteEnabled() {
            return this._text != null && !this._text.isDisposed();
        }

        public boolean isSaveAllEnabled() {
            return this._text != null && !this._text.isDisposed();
        }

        public boolean isSelectAllEnabled() {
            if (this._text == null || this._text.isDisposed()) {
                return false;
            }
            return this._text.getCharCount() > 0;
        }

        public void performCopy() {
            this._text.copy();
        }

        public void performCut() {
            this._text.cut();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }

        public void performDelete() {
            if (this._text.getSelectionCount() > 0) {
                this._text.insert("");
            } else {
                int pos = this._text.getCaretPosition();
                if (pos < this._text.getCharCount()) {
                    this._text.setSelection(pos, pos + 1);
                    this._text.insert("");
                }
            }
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }

        public void performPaste() {
            this._text.paste();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }

        public void performSelectAll() {
            this._text.selectAll();
            this.checkSelection();
            this.checkDeleteable();
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            return AbstractDialogPropertyDescriptor.this.openDialogBox(this._value, cellEditorWindow);
        }

        protected void updateContents(Object value) {
            if (this._text == null) {
                return;
            }
            String text = "";
            if (value != null) {
                text = value.toString();
            }
            this._text.setText(text);
        }

        private class DialogCellLayout
        extends Layout {
            private DialogCellLayout() {
            }

            public void layout(Composite editor, boolean force) {
                Rectangle bounds = editor.getClientArea();
                Point size = ValueCellEditor.this._button.computeSize(-1, -1, force);
                if (ValueCellEditor.this._text != null) {
                    ValueCellEditor.this._text.setBounds(0, 0, bounds.width - size.x, bounds.height);
                }
                ValueCellEditor.this._button.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
            }

            public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
                if (wHint != -1 && hHint != -1) {
                    return new Point(wHint, hHint);
                }
                Point contentsSize = ValueCellEditor.this._text.computeSize(-1, -1, force);
                Point buttonSize = ValueCellEditor.this._button.computeSize(-1, -1, force);
                Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
                return result;
            }
        }
    }
}

