/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jseditor.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.objectstyle.wolips.baseforuiplugins.utils.ListContentProvider;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;

public class JavaScriptLibraryTable {
    public static final String PREFIX = "entry:";
    private TableViewer _tableViewer;
    private List<Object> _tableModel = new ArrayList<Object>();
    private Composite _composite;
    private Button _add;
    private Button _addExternal;
    private Button _remove;
    private Button _up;
    private Button _down;

    public JavaScriptLibraryTable(final Composite parent) {
        this._composite = new Composite(parent, 0);
        this._composite.setLayout((Layout)new GridLayout(2, false));
        this._composite.setLayoutData((Object)new GridData(1808));
        this._tableViewer = new TableViewer(this._composite);
        GridData gd = new GridData(1808);
        gd.widthHint = 250;
        this._tableViewer.getTable().setLayoutData((Object)gd);
        this._tableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JavaScriptLibraryTable.this.updateButtons();
            }
        });
        this._tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                if (element instanceof File) {
                    return HTMLPlugin.getDefault().getImageRegistry().get("_icon_jar_ext");
                }
                if (element instanceof IFile) {
                    return HTMLPlugin.getDefault().getImageRegistry().get("_icon_jar");
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof File) {
                    return ((File)element).getAbsolutePath();
                }
                if (element instanceof IFile) {
                    return ((IFile)element).getFullPath().toString();
                }
                return element.toString();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this._tableViewer.setInput(this._tableModel);
        Composite buttons = new Composite(this._composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(2));
        this._add = new Button(buttons, 8);
        this._add.setText(HTMLPlugin.getResourceString("Button.Add"));
        this._add.setLayoutData((Object)JavaScriptLibraryTable.createButtonGridData());
        this._add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(parent.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle(HTMLPlugin.getResourceString("JavaScriptPropertyPage.ChooseJavaScript"));
                dialog.setMessage(HTMLPlugin.getResourceString("JavaScriptPropertyPage.ChooseJavaScript.Description"));
                dialog.setInput((Object)wsroot);
                dialog.setValidator(new ISelectionStatusValidator(){
                    private IStatus okStatus = new Status(0, HTMLPlugin.getDefault().getPluginId(), 0, "", null);
                    private IStatus ngStatus = new Status(4, HTMLPlugin.getDefault().getPluginId(), 4, "", null);

                    public IStatus validate(Object[] selection) {
                        for (int i = 0; i < selection.length; ++i) {
                            if (!(selection[i] instanceof IFile)) {
                                return this.ngStatus;
                            }
                            if (!((IFile)selection[i]).getName().endsWith(".js")) {
                                return this.ngStatus;
                            }
                            if (!JavaScriptLibraryTable.this._tableModel.contains(selection[i])) continue;
                            return this.ngStatus;
                        }
                        if (selection.length == 0) {
                            return this.ngStatus;
                        }
                        return this.okStatus;
                    }
                });
                if (dialog.open() == 0) {
                    Object[] results = dialog.getResult();
                    for (int i = 0; i < results.length; ++i) {
                        JavaScriptLibraryTable.this._tableModel.add(results[i]);
                    }
                    JavaScriptLibraryTable.this._tableViewer.refresh();
                    JavaScriptLibraryTable.this.modelChanged();
                }
            }
        });
        this._addExternal = new Button(buttons, 8);
        this._addExternal.setText(HTMLPlugin.getResourceString("Button.AddExternal"));
        this._addExternal.setLayoutData((Object)JavaScriptLibraryTable.createButtonGridData());
        this._addExternal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileDialog dialog = new FileDialog(parent.getShell(), 4098);
                dialog.setFilterExtensions(new String[]{"*.js"});
                String result = dialog.open();
                if (result != null) {
                    String dir = dialog.getFilterPath();
                    String[] fileNames = dialog.getFileNames();
                    for (int i = 0; i < fileNames.length; ++i) {
                        JavaScriptLibraryTable.this._tableModel.add(new File(dir, fileNames[i]));
                    }
                    JavaScriptLibraryTable.this._tableViewer.refresh();
                    JavaScriptLibraryTable.this.modelChanged();
                }
            }
        });
        this._remove = new Button(buttons, 8);
        this._remove.setText(HTMLPlugin.getResourceString("Button.Remove"));
        this._remove.setLayoutData((Object)JavaScriptLibraryTable.createButtonGridData());
        this._remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IStructuredSelection sel = (IStructuredSelection)JavaScriptLibraryTable.this._tableViewer.getSelection();
                JavaScriptLibraryTable.this._tableModel.removeAll(sel.toList());
                JavaScriptLibraryTable.this.updateButtons();
                JavaScriptLibraryTable.this._tableViewer.refresh();
                JavaScriptLibraryTable.this.modelChanged();
            }
        });
        this._up = new Button(buttons, 8);
        this._up.setText(HTMLPlugin.getResourceString("Button.Up"));
        this._up.setLayoutData((Object)JavaScriptLibraryTable.createButtonGridData());
        this._up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int index = JavaScriptLibraryTable.this._tableViewer.getTable().getSelectionIndex();
                if (index > 0) {
                    JavaScriptLibraryTable.this._tableModel.add(index, JavaScriptLibraryTable.this._tableModel.remove(index - 1));
                    JavaScriptLibraryTable.this._tableViewer.refresh();
                    JavaScriptLibraryTable.this.modelChanged();
                    JavaScriptLibraryTable.this.updateButtons();
                }
            }
        });
        this._down = new Button(buttons, 8);
        this._down.setText(HTMLPlugin.getResourceString("Button.Down"));
        this._down.setLayoutData((Object)JavaScriptLibraryTable.createButtonGridData());
        this._down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int index = JavaScriptLibraryTable.this._tableViewer.getTable().getSelectionIndex();
                if (index < JavaScriptLibraryTable.this._tableModel.size() - 1) {
                    JavaScriptLibraryTable.this._tableModel.add(index, JavaScriptLibraryTable.this._tableModel.remove(index + 1));
                    JavaScriptLibraryTable.this._tableViewer.refresh();
                    JavaScriptLibraryTable.this.modelChanged();
                    JavaScriptLibraryTable.this.updateButtons();
                }
            }
        });
        this.updateButtons();
    }

    protected void updateButtons() {
        this._remove.setEnabled(this._tableViewer.getTable().getSelectionCount() != 0);
        this._up.setEnabled(this._tableViewer.getTable().getSelectionCount() == 1 && this._tableViewer.getTable().getSelectionIndex() > 0);
        this._down.setEnabled(this._tableViewer.getTable().getSelectionCount() == 1 && this._tableViewer.getTable().getSelectionIndex() < this._tableModel.size() - 1);
    }

    protected void modelChanged() {
    }

    public Control getControl() {
        return this._composite;
    }

    public List getModel() {
        return this._tableModel;
    }

    public void refresh() {
        this._tableViewer.refresh();
    }

    private static GridData createButtonGridData() {
        GridData gd = new GridData(768);
        gd.widthHint = 100;
        return gd;
    }
}

