/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jseditor.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.jseditor.launch.JavaScriptLibraryTable;

public class JavaScriptMainTab
extends AbstractLaunchConfigurationTab {
    private JavaScriptLibraryTable tableViewer;
    private Text file;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.createFileGroup(composite);
        this.createIncludeGroup(composite);
        this.setControl((Control)composite);
    }

    private void createFileGroup(Composite composite) {
        Group fileGroup = new Group(composite, 0);
        fileGroup.setText(HTMLPlugin.getResourceString("Launcher.JavaScript.Label.ScriptFile"));
        fileGroup.setLayout((Layout)new GridLayout(2, false));
        fileGroup.setLayoutData((Object)new GridData(768));
        this.file = new Text((Composite)fileGroup, 2048);
        this.file.setLayoutData((Object)new GridData(768));
        this.file.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaScriptMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browseFile = new Button((Composite)fileGroup, 8);
        browseFile.setText(HTMLPlugin.getResourceString("Button.Browse"));
        browseFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String text = JavaScriptMainTab.browseJavaScriptFile();
                if (text != null) {
                    JavaScriptMainTab.this.file.setText(text);
                    JavaScriptMainTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
    }

    private void createIncludeGroup(Composite composite) {
        Group includeGroup = new Group(composite, 0);
        includeGroup.setText(HTMLPlugin.getResourceString("Launcher.JavaScript.Label.IncludeFiles"));
        includeGroup.setLayout((Layout)new GridLayout(2, false));
        includeGroup.setLayoutData((Object)new GridData(768));
        this.tableViewer = new JavaScriptLibraryTable((Composite)includeGroup){

            @Override
            protected void modelChanged() {
                JavaScriptMainTab.this.updateLaunchConfigurationDialog();
            }
        };
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String scriptFile = configuration.getAttribute("javascript.file", "");
            this.file.setText(scriptFile);
            List includes = configuration.getAttribute("javascript.includes", Collections.EMPTY_LIST);
            List tableModel = this.tableViewer.getModel();
            tableModel.clear();
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            for (int i = 0; i < includes.size(); ++i) {
                String path = (String)includes.get(i);
                if (path.startsWith("entry:")) {
                    IResource resource = wsroot.findMember(path.substring("entry:".length()));
                    if (resource == null || !(resource instanceof IFile) || !resource.exists()) continue;
                    tableModel.add(resource);
                    continue;
                }
                tableModel.add(new File(path));
            }
            this.tableViewer.refresh();
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("javascript.file", this.file.getText());
        List tableModel = this.tableViewer.getModel();
        ArrayList<String> includeFiles = new ArrayList<String>();
        for (int i = 0; i < tableModel.size(); ++i) {
            Object obj = tableModel.get(i);
            if (obj instanceof File) {
                includeFiles.add(((File)obj).getAbsolutePath());
                continue;
            }
            if (!(obj instanceof IFile)) continue;
            includeFiles.add("entry:" + ((IFile)obj).getFullPath().toString());
        }
        configuration.setAttribute("javascript.includes", includeFiles);
    }

    public String getName() {
        return HTMLPlugin.getResourceString("Launcher.JavaScript.Tabs.Main");
    }

    public Image getImage() {
        return HTMLPlugin.getDefault().getImageRegistry().get("_icon_javascript");
    }

    private static String browseJavaScriptFile() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject || element instanceof IFolder) {
                    return true;
                }
                return element instanceof IFile && ((IFile)element).getName().endsWith(".js");
            }
        });
        dialog.setAllowMultiple(false);
        dialog.setTitle(HTMLPlugin.getResourceString("Launcher.JavaScript.Dialog.SelectFile"));
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            return file.getLocation().toString();
        }
        return null;
    }
}

