/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import tk.eclipse.plugin.htmleditor.ColorProvider;
import tk.eclipse.plugin.htmleditor.HTMLHyperlinkDetector;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.IHyperlinkProvider;
import tk.eclipse.plugin.htmleditor.assist.HTMLAssistProcessor;
import tk.eclipse.plugin.htmleditor.editors.HTMLAutoEditStrategy;
import tk.eclipse.plugin.htmleditor.editors.HTMLConfiguration;
import tk.eclipse.plugin.jspeditor.editors.JSPAssistProcessor;
import tk.eclipse.plugin.jspeditor.editors.JSPAutoEditStrategy;
import tk.eclipse.plugin.jspeditor.editors.JSPDirectiveAssistProcessor;
import tk.eclipse.plugin.jspeditor.editors.JSPDirectiveScanner;
import tk.eclipse.plugin.jspeditor.editors.JSPHyperlinkProvider;
import tk.eclipse.plugin.jspeditor.editors.JSPScriptletAssistProcessor;
import tk.eclipse.plugin.jspeditor.editors.JSPScriptletScanner;

public class JSPConfiguration
extends HTMLConfiguration {
    private JSPScriptletScanner scriptletScanner = null;
    private JSPDirectiveScanner directiveScanner = null;
    private IContentAssistant assistant = null;
    private JSPDirectiveAssistProcessor directiveProcessor;
    private JSPScriptletAssistProcessor scriptletProcessor;

    public JSPConfiguration(ColorProvider colorProvider) {
        super(colorProvider);
    }

    @Override
    protected HTMLHyperlinkDetector createHyperlinkDetector() {
        HTMLHyperlinkDetector hyperlink = super.createHyperlinkDetector();
        hyperlink.addHyperlinkProvider(new JSPHyperlinkProvider());
        IHyperlinkProvider[] providers = HTMLPlugin.getDefault().getHyperlinkProviders();
        for (int i = 0; i < providers.length; ++i) {
            hyperlink.addHyperlinkProvider(providers[i]);
        }
        return hyperlink;
    }

    @Override
    protected HTMLAssistProcessor createAssistProcessor() {
        return new JSPAssistProcessor();
    }

    @Override
    protected RuleBasedScanner getScriptScanner() {
        if (this.scriptletScanner == null) {
            this.scriptletScanner = new JSPScriptletScanner(this.getColorProvider());
            this.scriptletScanner.setDefaultReturnToken(this.getColorProvider().getToken("__pref_color_foreground"));
        }
        return this.scriptletScanner;
    }

    @Override
    protected RuleBasedScanner getDirectiveScanner() {
        if (this.directiveScanner == null) {
            this.directiveScanner = new JSPDirectiveScanner(this.getColorProvider());
            this.directiveScanner.setDefaultReturnToken(this.getColorProvider().getToken("_pref_color_tag"));
        }
        return this.directiveScanner;
    }

    @Override
    protected HTMLAutoEditStrategy createAutoEditStrategy() {
        return new JSPAutoEditStrategy();
    }

    @Override
    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.assistant == null) {
            this.assistant = super.getContentAssistant(sourceViewer);
            this.directiveProcessor = new JSPDirectiveAssistProcessor();
            ((ContentAssistant)this.assistant).setContentAssistProcessor((IContentAssistProcessor)this.directiveProcessor, "__html_directive");
            this.scriptletProcessor = new JSPScriptletAssistProcessor();
            ((ContentAssistant)this.assistant).setContentAssistProcessor((IContentAssistProcessor)this.scriptletProcessor, "__html_script");
        }
        return this.assistant;
    }

    public JSPDirectiveAssistProcessor getDirectiveAssistProcessor() {
        return this.directiveProcessor;
    }

    public JSPScriptletAssistProcessor getScriptletAssistProcessor() {
        return this.scriptletProcessor;
    }
}

