/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.xmleditor.editors;

import org.eclipse.core.resources.IResource;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import tk.eclipse.plugin.htmleditor.HTMLUtil;

public class XMLValidationHandler
implements ErrorHandler {
    private IResource resource;

    public XMLValidationHandler(IResource resource) {
        this.resource = resource;
    }

    private void addMarker(int line, String message, int type) {
        if (message.startsWith("src-") || message.startsWith("sch-")) {
            return;
        }
        HTMLUtil.addMarker(this.resource, type, line, message);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        int line = exception.getLineNumber();
        String message = exception.getMessage();
        this.addMarker(line, message, 2);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        int line = exception.getLineNumber();
        String message = exception.getMessage();
        this.addMarker(line, message, 2);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        int line = exception.getLineNumber();
        String message = exception.getMessage();
        this.addMarker(line, message, 1);
    }
}

