/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.api;

import java.util.List;
import java.util.Map;
import org.objectstyle.wolips.bindings.api.AbstractNamedValidation;
import org.objectstyle.wolips.bindings.api.ApiModel;
import org.objectstyle.wolips.bindings.api.Binding;
import org.objectstyle.wolips.bindings.api.Validation;
import org.objectstyle.wolips.bindings.api.Wo;
import org.w3c.dom.Element;

public class Unsettable
extends AbstractNamedValidation {
    protected static final String UNSETTABLE = "unsettable";

    protected Unsettable(Element element, ApiModel apiModel) {
        super(element, apiModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToWoWithBinding(Wo wo, Binding binding) {
        ApiModel apiModel = wo.apiModel;
        synchronized (apiModel) {
            Element newValidationElement = wo.element.getOwnerDocument().createElement("validation");
            wo.element.appendChild(newValidationElement);
            newValidationElement.setAttribute("message", "'" + binding.getName() + "' must be bound to a settable value");
            Element newUnsettableElement = wo.element.getOwnerDocument().createElement(UNSETTABLE);
            newValidationElement.appendChild(newUnsettableElement);
            newUnsettableElement.setAttribute("name", binding.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromWoWithBinding(Wo wo, Binding binding) {
        ApiModel apiModel = wo.apiModel;
        synchronized (apiModel) {
            List<Validation> validations = wo.getValidations();
            for (int i = validations.size() - 1; i >= 0; --i) {
                Validation validation = validations.get(i);
                List<Unsettable> unsettables = validation.getUnsettables();
                if (unsettables.size() != 1 || !unsettables.get(0).isAffectedByBindingNamed(binding.getName())) continue;
                validation.removeChild(unsettables.get(0));
            }
        }
    }

    @Override
    public boolean evaluate(Map<String, String> bindings) {
        String bindingName = this.getName();
        String bindingValue = bindings.get(bindingName);
        boolean evaluation = bindingValue != null && bindingValue.startsWith("\"") && !bindingValue.startsWith("\"~");
        return evaluation;
    }
}

