/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.utils;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.objectstyle.wolips.bindings.utils.TypeDepthComparator;
import org.objectstyle.wolips.bindings.wod.BindingValueKey;
import org.objectstyle.wolips.bindings.wod.BindingValueKeyPath;
import org.objectstyle.wolips.bindings.wod.TypeCache;
import org.objectstyle.wolips.core.resources.types.TypeNameCollector;
import org.objectstyle.wolips.core.resources.types.WOHierarchyScope;

public class BindingReflectionUtils {
    public static final String[] FIELD_PREFIXES = new String[]{"", "_"};
    public static final String[] SET_METHOD_PREFIXES = new String[]{"set", "_set"};
    public static final String[] GET_METHOD_PREFIXES = new String[]{"get", "", "_get", "is", "_is", "_"};
    public static final int ACCESSORS_ONLY = 0;
    public static final int MUTATORS_ONLY = 1;
    public static final int ACCESSORS_OR_VOID = 2;
    public static final int VOID_ONLY = 3;
    public static Set<String> _systemTypeNames = new HashSet<String>();
    public static Set<String> _uselessSystemBindings;
    public static Set<String> _usefulSystemBindings;

    public static boolean isBoolean(String typeName) {
        return "boolean".equals(typeName) || "Boolean".equals(typeName) || "java.lang.Boolean".equals(typeName);
    }

    public static boolean isImportRequired(String typeName) {
        return typeName != null && !BindingReflectionUtils.isPrimitive(typeName) && !typeName.equals("java.lang." + Signature.getSimpleName((String)typeName));
    }

    public static boolean isPrimitive(String typeName) {
        return "boolean".equals(typeName) || "byte".equals(typeName) || "char".equals(typeName) || "int".equals(typeName) || "short".equals(typeName) || "float".equals(typeName) || "double".equals(typeName);
    }

    public static String getFullClassName(IJavaProject javaProject, String shortClassName) throws JavaModelException {
        String expandedClassName = shortClassName;
        if (expandedClassName != null && expandedClassName.indexOf(46) == -1) {
            if ("String".equals(shortClassName)) {
                expandedClassName = "java.lang.String";
            } else if ("Object".equals(shortClassName)) {
                expandedClassName = "java.lang.Object";
            } else if (!BindingReflectionUtils.isPrimitive(expandedClassName)) {
                SearchEngine searchEngine = new SearchEngine();
                IJavaSearchScope searchScope = JavaSearchScopeFactory.getInstance().createJavaProjectSearchScope(javaProject, 15);
                NullProgressMonitor progressMonitor = new NullProgressMonitor();
                TypeNameCollector typeNameCollector = new TypeNameCollector(javaProject, false);
                searchEngine.searchAllTypeNames(null, 0, shortClassName.toCharArray(), 0, 0, searchScope, (TypeNameRequestor)typeNameCollector, 3, (IProgressMonitor)progressMonitor);
                Set typeNames = typeNameCollector.getTypeNames();
                if (typeNames.size() == 1) {
                    expandedClassName = (String)typeNames.iterator().next();
                } else if (typeNames.size() == 0) {
                    System.out.println("BindingReflectionUtils.getFullClassName: Unknown type name " + shortClassName);
                } else {
                    System.out.println("BindingReflectionUtils.getFullClassName: Ambiguous type name " + shortClassName + " (" + typeNames + ")");
                }
            }
        }
        return expandedClassName;
    }

    public static String getShortClassName(String fullClassName) {
        int lastDotIndex = fullClassName.lastIndexOf(46);
        String shortClassName = lastDotIndex == -1 ? fullClassName : fullClassName.substring(lastDotIndex + 1);
        return shortClassName;
    }

    public static IType findElementType(IJavaProject javaProject, String elementTypeName, boolean requireTypeInProject, TypeCache cache) throws JavaModelException {
        String typeName = cache.getApiCache(javaProject).getElementTypeNamed(elementTypeName);
        IType type = null;
        if (typeName != null) {
            type = javaProject.findType(typeName);
        } else {
            NullProgressMonitor progressMonitor = new NullProgressMonitor();
            TypeNameCollector typeNameCollector = new TypeNameCollector(javaProject, requireTypeInProject);
            BindingReflectionUtils.findMatchingElementClassNames(elementTypeName, 0, typeNameCollector, (IProgressMonitor)progressMonitor);
            if (typeNameCollector.isExactMatch()) {
                String matchingElementClassName = typeNameCollector.firstTypeName();
                type = typeNameCollector.getTypeForClassName(matchingElementClassName);
            } else if (!typeNameCollector.isEmpty()) {
                String matchingElementClassName = typeNameCollector.firstTypeName();
                type = typeNameCollector.getTypeForClassName(matchingElementClassName);
            }
            if (type != null) {
                cache.getApiCache(javaProject).setElementTypeForName(type, elementTypeName);
            }
        }
        return type;
    }

    public static void findMatchingElementClassNames(String elementTypeName, int matchType, TypeNameCollector typeNameCollector, IProgressMonitor progressMonitor) throws JavaModelException {
        if (elementTypeName != null) {
            char[] typeName;
            char[] packageName;
            SearchEngine searchEngine = new SearchEngine();
            WOHierarchyScope searchScope = WOHierarchyScope.hierarchyScope((IType)typeNameCollector.getSuperclassType(), (IProject)typeNameCollector.getProject().getProject());
            int lastDotIndex = elementTypeName.lastIndexOf(46);
            if (lastDotIndex == -1) {
                packageName = null;
                typeName = elementTypeName.toCharArray();
            } else {
                packageName = elementTypeName.substring(0, lastDotIndex).toCharArray();
                typeName = elementTypeName.substring(lastDotIndex + 1).toCharArray();
            }
            searchEngine.searchAllTypeNames(packageName, 0, typeName, matchType, 5, (IJavaSearchScope)searchScope, (TypeNameRequestor)typeNameCollector, 3, progressMonitor);
        }
    }

    public static boolean isWOComponent(IType type, TypeCache cache) throws JavaModelException {
        return BindingReflectionUtils.isType(type, new String[]{"com.webobjects.appserver.WOComponent"}, cache);
    }

    public static boolean isNSKeyValueCoding(IType type, TypeCache cache) throws JavaModelException {
        return BindingReflectionUtils.isType(type, new String[]{"com.webobjects.foundation.NSKeyValueCoding"}, cache);
    }

    public static boolean isNSCollection(IType type, TypeCache cache) throws JavaModelException {
        return BindingReflectionUtils.isType(type, new String[]{"com.webobjects.foundation.NSDictionary", "com.webobjects.foundation.NSArray", "com.webobjects.foundation.NSSet", "er.extensions.ERXLocalizer"}, cache);
    }

    public static boolean isType(IType type, String[] possibleTypes, TypeCache cache) throws JavaModelException {
        boolean isType = false;
        List<IType> types = cache.getSupertypesOf(type);
        for (int typeNum = 0; !isType && typeNum < types.size(); ++typeNum) {
            String name = types.get(typeNum).getFullyQualifiedName();
            for (int possibleTypeNum = 0; !isType && possibleTypeNum < possibleTypes.length; ++possibleTypeNum) {
                if (!possibleTypes[possibleTypeNum].equals(name)) continue;
                isType = true;
            }
        }
        return isType;
    }

    public static Set<String> getArrayOperators() {
        HashSet<String> operators = new HashSet<String>();
        operators.add("avg");
        operators.add("count");
        operators.add("min");
        operators.add("max");
        operators.add("sum");
        operators.add("sort");
        operators.add("sortAsc");
        operators.add("sortDesc");
        return operators;
    }

    public static List<BindingValueKey> getBindingKeys(IJavaProject javaProject, IType type, String nameStartingWith, boolean requireExactNameMatch, int accessorsOrMutators, boolean allowInheritanceDuplicates, TypeCache cache) throws JavaModelException {
        LinkedList<BindingValueKey> bindingKeys = new LinkedList<BindingValueKey>();
        if (type != null) {
            String lowercaseNameStartingWith = nameStartingWith.toLowerCase();
            HashSet<String> additionalProposals = new HashSet<String>();
            List<IType> types = cache.getSupertypesOf(type);
            if (types != null) {
                IType usuallySubclassedSupertype = null;
                IType nextType = null;
                for (int typeNum = 0; usuallySubclassedSupertype == null && typeNum < types.size(); ++typeNum) {
                    String typeName = types.get(typeNum).getElementName();
                    if ("WOApplication".equals(typeName) || "WOSession".equals(typeName) || "WODirectAction".equals(typeName)) {
                        usuallySubclassedSupertype = types.get(typeNum);
                        continue;
                    }
                    if (!"NSArray".equals(typeName)) continue;
                    for (String operator : BindingReflectionUtils.getArrayOperators()) {
                        additionalProposals.add("@" + operator);
                    }
                    nextType = types.get(typeNum);
                }
                for (String additionalProposal : additionalProposals) {
                    if (!additionalProposal.startsWith(nameStartingWith)) continue;
                    BindingValueKey additionalKey = new BindingValueKey(additionalProposal, null, null, javaProject, cache);
                    bindingKeys.add(additionalKey);
                }
                if (usuallySubclassedSupertype != null) {
                    types = cache.getSubtypesOfInProject(usuallySubclassedSupertype, javaProject);
                }
            }
            if (types != null) {
                for (int typeNum = 0; !(requireExactNameMatch && bindingKeys.size() != 0 || typeNum >= types.size()); ++typeNum) {
                    BindingReflectionUtils.fillInBindingKeys(type, types.get(typeNum), lowercaseNameStartingWith, requireExactNameMatch, accessorsOrMutators, allowInheritanceDuplicates, javaProject, bindingKeys, cache);
                }
            }
        }
        return bindingKeys;
    }

    protected static void fillInBindingKeys(IType declaringType, IType type, String lowercaseNameStartingWith, boolean requireExactNameMatch, int accessorsOrMutators, boolean allowInheritanceDuplicates, IJavaProject javaProject, List<BindingValueKey> bindingKeys, TypeCache cache) throws JavaModelException {
        IField[] fields = type.getFields();
        block0: for (int fieldNum = 0; !(requireExactNameMatch && bindingKeys.size() != 0 || fieldNum >= fields.length); ++fieldNum) {
            for (String prefix : FIELD_PREFIXES) {
                BindingValueKey bindingKey = BindingReflectionUtils.getBindingKeyIfMatches(javaProject, declaringType, (IMember)fields[fieldNum], prefix + lowercaseNameStartingWith, prefix, requireExactNameMatch, accessorsOrMutators, cache);
                if (bindingKey == null) continue;
                bindingKeys.add(bindingKey);
                continue block0;
            }
        }
        if (!requireExactNameMatch || bindingKeys.size() == 0) {
            IMethod[] methods = type.getMethods();
            String[] prefixes = accessorsOrMutators == 0 ? GET_METHOD_PREFIXES : (accessorsOrMutators == 2 ? GET_METHOD_PREFIXES : (accessorsOrMutators == 1 ? SET_METHOD_PREFIXES : new String[]{}));
            block2: for (int methodNum = 0; !(requireExactNameMatch && bindingKeys.size() != 0 || methodNum >= methods.length); ++methodNum) {
                for (String prefix : prefixes) {
                    BindingValueKey bindingKey = BindingReflectionUtils.getBindingKeyIfMatches(javaProject, declaringType, (IMember)methods[methodNum], prefix + lowercaseNameStartingWith, prefix, requireExactNameMatch, accessorsOrMutators, cache);
                    if (bindingKey == null) continue;
                    if (!allowInheritanceDuplicates && bindingKeys.contains(bindingKey)) continue block2;
                    bindingKeys.add(bindingKey);
                    continue block2;
                }
            }
        }
    }

    public static boolean isDefaultPackage(IMember member) {
        IType declaringType = member.getDeclaringType();
        String declaringTypePackageName = declaringType.getPackageFragment().getElementName();
        return declaringTypePackageName == null || declaringTypePackageName.length() == 0;
    }

    public static BindingValueKey getBindingKeyIfMatches(IJavaProject javaProject, IType type, IMember member, String nameStartingWith, String prefix, boolean requireExactNameMatch, int accessorsOrMutators, TypeCache cache) throws JavaModelException {
        BindingValueKey bindingKey = null;
        int flags = member.getFlags();
        Visibility visible = Visibility.Hidden;
        if (Flags.isPrivate((int)flags)) {
            visible = Visibility.Hidden;
        } else if (Flags.isStatic((int)flags)) {
            visible = Visibility.Hidden;
        } else if (Flags.isPublic((int)flags) || type.isInterface()) {
            visible = Visibility.Visible;
        } else if (Flags.isProtected((int)flags) || Flags.isPackageDefault((int)flags)) {
            visible = BindingReflectionUtils.isDefaultPackage(member) ? Visibility.Visible : Visibility.MaybeVisible;
        }
        if (visible != Visibility.Hidden) {
            boolean memberSignatureMatches;
            if (member instanceof IMethod) {
                IMethod method = (IMethod)member;
                if (method.isConstructor()) {
                    memberSignatureMatches = false;
                } else {
                    int parameterCount = method.getParameterTypes().length;
                    String returnType = method.getReturnType();
                    memberSignatureMatches = accessorsOrMutators == 0 ? parameterCount == 0 && !"V".equals(returnType) : (accessorsOrMutators == 2 ? parameterCount == 0 : (accessorsOrMutators == 3 ? parameterCount == 0 && "V".equals(returnType) : parameterCount == 1 && "V".equals(returnType)));
                }
            } else {
                memberSignatureMatches = true;
            }
            if (memberSignatureMatches) {
                String memberName = member.getElementName();
                String lowercaseMemberName = memberName.toLowerCase();
                int prefixLength = prefix.length();
                if (requireExactNameMatch && lowercaseMemberName.equals(nameStartingWith) || !requireExactNameMatch && lowercaseMemberName.startsWith(nameStartingWith)) {
                    String bindingName = BindingReflectionUtils.toLowercaseFirstLetter(memberName.substring(prefixLength));
                    if (nameStartingWith.length() > 0 || !bindingName.startsWith("_")) {
                        if (visible == Visibility.MaybeVisible) {
                            String packageName = type.getPackageFragment().getElementName();
                            String kvcProtectedAccessorClassName = packageName.length() == 0 ? "KeyValueCodingProtectedAccessor" : packageName + ".KeyValueCodingProtectedAccessor";
                            IType kvcProtectedAccessor = type.getJavaProject().findType(kvcProtectedAccessorClassName);
                            if (kvcProtectedAccessor != null) {
                                visible = Visibility.Visible;
                            }
                        }
                        if (visible == Visibility.Visible) {
                            bindingKey = new BindingValueKey(bindingName, type, member, javaProject, cache);
                        }
                    }
                }
            }
        }
        return bindingKey;
    }

    public static String toLowercaseFirstLetter(String _memberName) {
        char firstChar;
        String lowercaseFirstLetterMemberName = _memberName.length() > 0 ? (Character.isUpperCase(firstChar = _memberName.charAt(0)) ? Character.toLowerCase(firstChar) + _memberName.substring(1) : _memberName) : _memberName;
        return lowercaseFirstLetterMemberName;
    }

    public static boolean isSystemBindingValueKey(BindingValueKey bindingValueKey, boolean showUsefulSystemBindings) {
        boolean isSystemBinding = false;
        if (bindingValueKey != null && bindingValueKey.getDeclaringType() != null) {
            String declaringTypeName = bindingValueKey.getDeclaringType().getElementName();
            String bindingName = bindingValueKey.getBindingName();
            if (_systemTypeNames.contains(declaringTypeName)) {
                if (!showUsefulSystemBindings && _usefulSystemBindings.contains(bindingName)) {
                    isSystemBinding = true;
                } else if (_uselessSystemBindings.contains(bindingName)) {
                    isSystemBinding = true;
                }
            } else if (bindingName.startsWith("_")) {
                isSystemBinding = true;
            }
        }
        return isSystemBinding;
    }

    public static boolean isBooleanValue(String keyPath) {
        return "true".equalsIgnoreCase(keyPath) || "false".equalsIgnoreCase(keyPath) || "yes".equalsIgnoreCase(keyPath) || "no".equalsIgnoreCase(keyPath);
    }

    public static List<BindingValueKey> filterSystemBindingValueKeys(List<BindingValueKey> bindingKeys, boolean showUsefulSystemBindings) {
        List<BindingValueKey> filteredBindingValueKeys;
        HashSet<BindingValueKey> systemBindingValueKeys = new HashSet<BindingValueKey>();
        for (BindingValueKey bindingKey : bindingKeys) {
            if (!BindingReflectionUtils.isSystemBindingValueKey(bindingKey, showUsefulSystemBindings)) continue;
            systemBindingValueKeys.add(bindingKey);
        }
        if (systemBindingValueKeys.isEmpty()) {
            filteredBindingValueKeys = bindingKeys;
        } else {
            filteredBindingValueKeys = new LinkedList<BindingValueKey>();
            for (BindingValueKey bindingKey : bindingKeys) {
                if (systemBindingValueKeys.contains(bindingKey)) continue;
                filteredBindingValueKeys.add(bindingKey);
            }
        }
        return filteredBindingValueKeys;
    }

    public static Map<IType, Set<BindingValueKey>> getGroupedBindingValueKeys(String startingWith, IType type, TypeCache cache) throws JavaModelException {
        BindingValueKeyPath bindingValueKeyPath = new BindingValueKeyPath(startingWith, type, type.getJavaProject(), cache);
        List<BindingValueKey> bindingValueKeys = bindingValueKeyPath.getPartialMatchesForLastBindingKey(true);
        List<BindingValueKey> filteredBindingValueKeys = BindingReflectionUtils.filterSystemBindingValueKeys(bindingValueKeys, true);
        TreeSet<BindingValueKey> uniqueBingingValueKeys = new TreeSet<BindingValueKey>(filteredBindingValueKeys);
        TreeMap<IType, Set<BindingValueKey>> typeKeys = new TreeMap<IType, Set<BindingValueKey>>(new TypeDepthComparator(cache));
        for (BindingValueKey key : uniqueBingingValueKeys) {
            IType declaringType = key.getDeclaringType();
            TreeSet<BindingValueKey> typeKeysSet = (TreeSet<BindingValueKey>)typeKeys.get(declaringType);
            if (typeKeysSet == null) {
                typeKeysSet = new TreeSet<BindingValueKey>();
                typeKeys.put(declaringType, typeKeysSet);
            }
            typeKeysSet.add(key);
        }
        return typeKeys;
    }

    public static boolean bindingPointsToDeprecatedValue(BindingValueKey bindingKey) {
        return BindingReflectionUtils.memberIsDeprecated(bindingKey.getBindingMember());
    }

    public static boolean memberIsDeprecated(IMember member) {
        boolean isDeprecated = false;
        if (member != null) {
            try {
                isDeprecated = (member.getFlags() & 0x100000) == 0x100000;
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return isDeprecated;
    }

    static {
        _systemTypeNames.add("Object");
        _systemTypeNames.add("WOElement");
        _systemTypeNames.add("WOActionResults");
        _systemTypeNames.add("WOComponent");
        _uselessSystemBindings = new HashSet<String>();
        _uselessSystemBindings.add("baseURL");
        _uselessSystemBindings.add("bindingKeys");
        _uselessSystemBindings.add("cachingEnabled");
        _uselessSystemBindings.add("childTemplate");
        _uselessSystemBindings.add("getClass");
        _uselessSystemBindings.add("class");
        _uselessSystemBindings.add("clone");
        _uselessSystemBindings.add("componentDefinition");
        _uselessSystemBindings.add("componentUnroll");
        _uselessSystemBindings.add("frameworkName");
        _uselessSystemBindings.add("generateResponse");
        _uselessSystemBindings.add("hashCode");
        _uselessSystemBindings.add("isCachingEnabled");
        _uselessSystemBindings.add("eventLoggingEnabled");
        _uselessSystemBindings.add("isEventLoggingEnabled");
        _uselessSystemBindings.add("isPage");
        _uselessSystemBindings.add("isStateless");
        _uselessSystemBindings.add("stateless");
        _uselessSystemBindings.add("keyAssociations");
        _uselessSystemBindings.add("name");
        _uselessSystemBindings.add("page");
        _uselessSystemBindings.add("parent");
        _uselessSystemBindings.add("path");
        _uselessSystemBindings.add("pathURL");
        _uselessSystemBindings.add("synchronizesVariablesWithBindings");
        _uselessSystemBindings.add("template");
        _uselessSystemBindings.add("toString");
        _uselessSystemBindings.add("unroll");
        _usefulSystemBindings = new HashSet<String>();
        _usefulSystemBindings.add("application");
        _usefulSystemBindings.add("context");
        _usefulSystemBindings.add("hasSession");
        _usefulSystemBindings.add("session");
    }

    protected static enum Visibility {
        Hidden,
        Visible,
        MaybeVisible;

    }
}

