/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.wod;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.objectstyle.wolips.bindings.Activator;
import org.objectstyle.wolips.bindings.api.ApiModelException;
import org.objectstyle.wolips.bindings.wod.HtmlElementCache;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.IWodModel;
import org.objectstyle.wolips.bindings.wod.TypeCache;
import org.objectstyle.wolips.bindings.wod.WodElementComparator;
import org.objectstyle.wolips.bindings.wod.WodElementProblem;
import org.objectstyle.wolips.bindings.wod.WodProblem;

public abstract class AbstractWodModel
implements IWodModel {
    private List<IWodElement> _elements = new LinkedList<IWodElement>();
    private List<WodProblem> _parseProblems = new LinkedList<WodProblem>();
    private boolean _hasInheritedElements;

    protected void clear() {
        this._elements.clear();
        this._parseProblems.clear();
    }

    @Override
    public IWodElement getElementNamed(String name) {
        IWodElement matchingElement = null;
        if (name != null) {
            Iterator<IWodElement> wodElementsIter = this._elements.iterator();
            while (matchingElement == null && wodElementsIter.hasNext()) {
                IWodElement wodElement = wodElementsIter.next();
                if (!name.equals(wodElement.getElementName())) continue;
                matchingElement = wodElement;
            }
        }
        return matchingElement;
    }

    public synchronized void addElement(IWodElement _element) {
        if (this._hasInheritedElements) {
            IWodElement existingElement = this.getElementNamed(_element.getElementName());
            if (existingElement != null && existingElement.isInherited()) {
                this._elements.remove(existingElement);
            }
        } else if (_element.isInherited()) {
            this._hasInheritedElements = true;
        }
        this._elements.add(_element);
    }

    @Override
    public synchronized List<IWodElement> getElements() {
        return this._elements;
    }

    @Override
    public void writeWodFormat(Writer writer, boolean alphabetize) throws IOException {
        List<IWodElement> elementsList = this.getElements();
        if (alphabetize) {
            elementsList = new LinkedList<IWodElement>(elementsList);
            Collections.sort(elementsList, new WodElementComparator());
        }
        for (IWodElement element : elementsList) {
            element.writeWodFormat(writer, alphabetize);
            writer.write("\n");
        }
    }

    @Override
    public List<WodProblem> getProblems(IJavaProject javaProject, IType javaFileType, TypeCache typeCache, HtmlElementCache htmlCache) throws CoreException, IOException, ApiModelException {
        LinkedList<WodProblem> problems = new LinkedList<WodProblem>();
        boolean checkBindingValues = Activator.getDefault().getPluginPreferences().getBoolean("CheckBindingValues");
        this.fillInProblems(javaProject, javaFileType, checkBindingValues, problems, typeCache, htmlCache);
        return problems;
    }

    protected void addParseProblem(WodProblem problem) {
        this._parseProblems.add(problem);
    }

    @Override
    public void fillInProblems(IJavaProject javaProject, IType javaFileType, boolean checkBindingValues, List<WodProblem> problems, TypeCache typeCache, HtmlElementCache htmlCache) throws CoreException, IOException, ApiModelException {
        problems.addAll(this._parseProblems);
        HashSet<String> wodElementNames = new HashSet<String>();
        for (IWodElement element : this.getElements()) {
            String elementName = element.getElementName();
            if (wodElementNames.contains(elementName)) {
                problems.add(new WodElementProblem(element, "Duplicate definition of '" + elementName + "'", element.getElementNamePosition(), element.getLineNumber(), false));
            } else {
                wodElementNames.add(elementName);
            }
            element.fillInProblems(javaProject, javaFileType, checkBindingValues, problems, typeCache, htmlCache);
        }
    }

    public String toString() {
        return "[" + this.getClass().getName() + ": elements = " + this._elements + "]";
    }
}

