/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards;

import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonStatusDialogField;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.objectstyle.wolips.bindings.utils.BindingReflectionUtils;
import org.objectstyle.wolips.core.resources.types.TypeNameCollector;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;
import org.objectstyle.wolips.eomodeler.utils.StringLabelProvider;
import org.objectstyle.wolips.locate.LocateException;
import org.objectstyle.wolips.locate.LocatePlugin;
import org.objectstyle.wolips.locate.result.LocalizedComponentsLocateResult;
import org.objectstyle.wolips.wizards.Messages;
import org.objectstyle.wolips.wizards.WOComponentCreator;
import org.objectstyle.wolips.wizards.WizardNewWOResourcePage;

public class WOComponentCreationPage
extends WizardNewWOResourcePage {
    private static final String BODY_CHECKBOX_KEY = "WOComponentCreationWizardSection.bodyCheckbox";
    private static final String API_CHECKBOX_KEY = "WOComponentCreationWizardSection.apiCheckbox";
    private static final String HTML_DOCTYPE_KEY = "WOComponentCreationWizardSection.htmlDocType";
    private static final String NSSTRING_ENCODING_KEY = "WOComponentCreationWizardSection.encoding";
    private static final String SUPERCLASS_KEY = "WOComponentCreationWizardSection.superclass";
    private Button _bodyCheckbox;
    private Combo _htmlCombo;
    private Combo _encodingCombo;
    private Button _apiCheckbox;
    private IResource[] _resourcesToReveal;
    private StringButtonStatusDialogField _packageDialogField;
    private StringButtonStatusDialogField _superclassDialogField;
    private Object _currentSelection;

    public WOComponentCreationPage(IStructuredSelection selection) {
        super("createWOComponentPage1", WOComponentCreationPage.processSelection(selection));
        this.setTitle(Messages.getString("WOComponentCreationPage.title"));
        this.setDescription(Messages.getString("WOComponentCreationPage.description"));
        if (selection != null) {
            Object selectedObject = selection.getFirstElement();
            if (selectedObject instanceof IFolder) {
                IJavaElement parentJavaElement = JavaCore.create((IFolder)((IFolder)selectedObject));
                if (parentJavaElement instanceof IPackageFragment) {
                    this._currentSelection = parentJavaElement;
                    this.setContainerFullPath(this.componentPathForPackage((IPackageFragment)this._currentSelection));
                } else {
                    IFolder selectedFolder = (IFolder)selectedObject;
                    ProjectAdapter projectAdapter = (ProjectAdapter)selectedFolder.getProject().getAdapter(ProjectAdapter.class);
                    IPath rootFolder = selectedFolder.getProjectRelativePath().uptoSegment(1);
                    if (!rootFolder.equals((Object)projectAdapter.getDefaultComponentsFolder().getProjectRelativePath())) {
                        this.setContainerFullPath(projectAdapter.getDefaultComponentsFolder().getFullPath());
                    }
                }
            } else if (selectedObject instanceof IResource) {
                IResource selectedResource = (IResource)selectedObject;
                ProjectAdapter projectAdapter = (ProjectAdapter)selectedResource.getProject().getAdapter(ProjectAdapter.class);
                this.setContainerFullPath(projectAdapter.getDefaultComponentsFolder().getFullPath());
            }
        }
    }

    public static IStructuredSelection processSelection(IStructuredSelection selection) {
        StructuredSelection processedSelection = null;
        if (selection != null) {
            Object selectedObject = selection.getFirstElement();
            if (selectedObject instanceof IFile) {
                selectedObject = ((IFile)selectedObject).getParent();
                processedSelection = null;
            }
            if (selectedObject instanceof IFolder) {
                IFolder currentFolder = (IFolder)selectedObject;
                IJavaElement parentJavaElement = JavaCore.create((IFolder)currentFolder);
                if (parentJavaElement instanceof IPackageFragment) {
                    processedSelection = new StructuredSelection((Object)currentFolder.getProject());
                } else if (parentJavaElement instanceof IPackageFragmentRoot) {
                    processedSelection = new StructuredSelection((Object)currentFolder.getProject());
                } else if (currentFolder.getName().endsWith(".wo")) {
                    processedSelection = new StructuredSelection((Object)currentFolder.getParent());
                }
            }
        }
        return processedSelection;
    }

    protected void initialPopulateContainerNameField() {
        super.initialPopulateContainerNameField();
    }

    protected void createAdvancedControls(Composite parent) {
    }

    protected IStatus validateLinkedResource() {
        return Status.OK_STATUS;
    }

    protected boolean validatePage() {
        IStatus status = JavaConventions.validateCompilationUnitName((String)(this.getFileName() + ".java"), (String)"1.3", (String)"1.3");
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getContainerFullPath().segment(0));
        LocatePlugin locatePlugin = LocatePlugin.getDefault();
        try {
            LocalizedComponentsLocateResult result = locatePlugin.getLocalizedComponentsLocateResult(project, this.getFileName());
            if (result.getResources().length > 0) {
                this.setErrorMessage("A component by that name already exists");
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IPath path = this.getContainerFullPath();
        if (path.lastSegment().endsWith(".wo")) {
            this.setErrorMessage("Cannot create a component within another component");
            return false;
        }
        return super.validatePage();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite composite = (Composite)this.getControl();
        this.setFileName(Messages.getString("WOComponentCreationPage.newComponent.defaultName"));
        Group javaGroup = new Group(composite, 0);
        javaGroup.setText(Messages.getString("WOComponentCreationPage.creationOptions.javaFile.group"));
        GridLayout javaLayout = new GridLayout();
        javaLayout.numColumns = 4;
        javaGroup.setLayout((Layout)javaLayout);
        javaGroup.setLayoutData((Object)new GridData(768));
        PackageButtonAdapter packageButtonAdapter = new PackageButtonAdapter();
        this._packageDialogField = new StringButtonStatusDialogField((IStringButtonAdapter)packageButtonAdapter);
        this._packageDialogField.setDialogFieldListener((IDialogFieldListener)packageButtonAdapter);
        this._packageDialogField.setLabelText(NewWizardMessages.NewTypeWizardPage_package_label);
        this._packageDialogField.setButtonLabel(NewWizardMessages.NewTypeWizardPage_package_button);
        this._packageDialogField.setStatusWidthHint(NewWizardMessages.NewTypeWizardPage_default);
        this._packageDialogField.doFillIntoGrid((Composite)javaGroup, 4);
        Text packageText = this._packageDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)packageText, (int)this.convertWidthInCharsToPixels(40));
        LayoutUtil.setHorizontalGrabbing((Control)packageText);
        if (this._currentSelection instanceof IPackageFragment) {
            this._packageDialogField.setText(((IPackageFragment)this._currentSelection).getElementName());
        } else {
            String _package = null;
            IResource _resource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.getContainerFullPath());
            if (_resource instanceof IFolder) {
                _package = this.packageNameForComponentFolder((IFolder)_resource);
            }
            if (_package == null && (_package = this.packageNameForComponent("Main")) == null) {
                _package = "";
            }
            this._packageDialogField.setText(_package);
        }
        SuperclassButtonAdapter superclassButtonAdapter = new SuperclassButtonAdapter();
        this._superclassDialogField = new StringButtonStatusDialogField((IStringButtonAdapter)superclassButtonAdapter);
        this._superclassDialogField.setDialogFieldListener((IDialogFieldListener)superclassButtonAdapter);
        this._superclassDialogField.setLabelText(NewWizardMessages.NewTypeWizardPage_superclass_label);
        this._superclassDialogField.setButtonLabel(NewWizardMessages.NewTypeWizardPage_superclass_button);
        this._superclassDialogField.setStatusWidthHint(NewWizardMessages.NewTypeWizardPage_default);
        this._superclassDialogField.doFillIntoGrid((Composite)javaGroup, 4);
        String superclass = this.getDialogSettings().get(SUPERCLASS_KEY);
        if (superclass == null || superclass.length() == 0) {
            this._superclassDialogField.setText("com.webobjects.appserver.WOComponent");
        } else {
            this._superclassDialogField.setText(superclass);
        }
        Text superclassText = this._superclassDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)superclassText, (int)this.convertWidthInCharsToPixels(40));
        LayoutUtil.setHorizontalGrabbing((Control)superclassText);
        new Label(composite, 0);
        Group optionalFilesGroup = new Group(composite, 0);
        optionalFilesGroup.setLayout((Layout)new GridLayout(3, false));
        optionalFilesGroup.setText(Messages.getString("WOComponentCreationPage.creationOptions.group"));
        optionalFilesGroup.setLayoutData((Object)new GridData(768));
        ButtonSelectionAdaptor listener = new ButtonSelectionAdaptor();
        this._bodyCheckbox = new Button((Composite)optionalFilesGroup, 32);
        this._bodyCheckbox.setText(Messages.getString("WOComponentCreationPage.creationOptions.bodyTag.button"));
        this._bodyCheckbox.setSelection(this.getDialogSettings().getBoolean(BODY_CHECKBOX_KEY));
        this._bodyCheckbox.setAlignment(0x1000000);
        this._bodyCheckbox.addListener(13, (Listener)this);
        this._bodyCheckbox.addSelectionListener((SelectionListener)listener);
        Label htmlLabel = new Label((Composite)optionalFilesGroup, 131072);
        htmlLabel.setText(Messages.getString("WOComponentCreationPage.creationOptions.bodyTag.label"));
        htmlLabel.setLayoutData((Object)new GridData(768));
        this._htmlCombo = new Combo((Composite)optionalFilesGroup, 4);
        this._htmlCombo.setLayoutData((Object)new GridData(768));
        this.populateHTMLCombo(this._htmlCombo);
        this.refreshButtonSettings(this._bodyCheckbox);
        this._apiCheckbox = new Button((Composite)optionalFilesGroup, 32);
        GridData apiLayoutData = new GridData();
        this._apiCheckbox.setLayoutData((Object)apiLayoutData);
        this._apiCheckbox.setText(Messages.getString("WOComponentCreationPage.creationOptions.apiFile.button"));
        this._apiCheckbox.setSelection(this.getDialogSettings().getBoolean(API_CHECKBOX_KEY));
        this._apiCheckbox.addListener(13, (Listener)this);
        this._apiCheckbox.addSelectionListener((SelectionListener)listener);
        Label encodingLabel = new Label((Composite)optionalFilesGroup, 131072);
        encodingLabel.setText(Messages.getString("WOComponentCreationPage.creationOptions.wooFile.label"));
        encodingLabel.setLayoutData((Object)new GridData(768));
        this._encodingCombo = new Combo((Composite)optionalFilesGroup, 4);
        this._encodingCombo.setLayoutData((Object)new GridData(768));
        this.populateStringEncodingCombo(this._encodingCombo);
        this.setPageComplete(this.validatePage());
    }

    public boolean createComponent() {
        WOComponentCreator componentCreator;
        String componentName = this.getFileName();
        String packageName = this._packageDialogField.getText();
        String superclassName = this._superclassDialogField.getText();
        IProject actualProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getContainerFullPath().segment(0));
        switch (this.getContainerFullPath().segmentCount()) {
            case 0: {
                this.setErrorMessage("unknown error");
                return false;
            }
            case 1: {
                componentCreator = new WOComponentCreator((IResource)actualProject, componentName, packageName, superclassName, this._bodyCheckbox.getSelection(), this._apiCheckbox.getSelection(), this);
                break;
            }
            default: {
                IFolder subprojectFolder = actualProject.getFolder(this.getContainerFullPath().removeFirstSegments(1));
                componentCreator = new WOComponentCreator((IResource)subprojectFolder, componentName, packageName, superclassName, this._bodyCheckbox.getSelection(), this._apiCheckbox.getSelection(), this);
            }
        }
        this.getDialogSettings().put(SUPERCLASS_KEY, this._superclassDialogField.getText());
        this.getDialogSettings().put(BODY_CHECKBOX_KEY, this._bodyCheckbox.getSelection());
        this.getDialogSettings().put(HTML_DOCTYPE_KEY, this._htmlCombo.getText());
        this.getDialogSettings().put(NSSTRING_ENCODING_KEY, this._encodingCombo.getText());
        this.getDialogSettings().put(API_CHECKBOX_KEY, this._apiCheckbox.getSelection());
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)componentCreator);
        return this.createResourceOperation((IRunnableWithProgress)op);
    }

    public void logPreferences() {
        System.out.println("BODY_CHECKBOX_KEY: " + this.getDialogSettings().get(BODY_CHECKBOX_KEY));
        System.out.println("HTML_DOCTYPE_KEY: " + this.getDialogSettings().get(HTML_DOCTYPE_KEY));
        System.out.println("NSSTRING_ENCODING_KEY: " + this.getDialogSettings().get(NSSTRING_ENCODING_KEY));
        System.out.println("API_CHECKBOX_KEY: " + this.getDialogSettings().get(API_CHECKBOX_KEY));
        System.out.println("SUPERCLASS_KEY: " + this.getDialogSettings().get(SUPERCLASS_KEY));
    }

    public void populateHTMLCombo(Combo c) {
        for (HTML entry : HTML.values()) {
            c.add(entry.getDisplayString());
        }
        this.selectHTMLDocTypePreference(c);
    }

    public void selectHTMLDocTypePreference(Combo c) {
        String previousDocType = this.getDialogSettings().get(HTML_DOCTYPE_KEY);
        if (previousDocType != null && previousDocType.length() > 0) {
            int i = 0;
            for (HTML entry : HTML.values()) {
                if (previousDocType.equals(entry.getDisplayString())) {
                    c.select(i);
                    return;
                }
                ++i;
            }
        }
        c.select(3);
    }

    public HTML getSelectedHTMLDocType() {
        if (this._bodyCheckbox.getSelection()) {
            return this.getHTMLForDisplayString(this._htmlCombo.getText());
        }
        return HTML.TRANSITIONAL_XHTML10;
    }

    public HTML getHTMLForDisplayString(String displayString) {
        for (HTML entry : HTML.values()) {
            if (!displayString.equals(entry.getDisplayString())) continue;
            return entry;
        }
        return HTML.TRANSITIONAL_XHTML10;
    }

    public void populateStringEncodingCombo(Combo c) {
        for (NSSTRINGENCODING entry : NSSTRINGENCODING.values()) {
            c.add(entry.getDisplayString());
        }
        this.selectNSStringEncodingPreference(c);
    }

    public void selectNSStringEncodingPreference(Combo c) {
        String previousEncoding = this.getDialogSettings().get(NSSTRING_ENCODING_KEY);
        if (previousEncoding != null && previousEncoding.length() > 0) {
            int i = 0;
            for (NSSTRINGENCODING entry : NSSTRINGENCODING.values()) {
                if (previousEncoding.equals(entry.getDisplayString())) {
                    c.select(i);
                    return;
                }
                ++i;
            }
        }
        c.select(0);
    }

    public String getSelectedEncoding() {
        return this.getEncodingForDisplayString(this._encodingCombo.getText());
    }

    public String getEncodingForDisplayString(String displayString) {
        for (NSSTRINGENCODING entry : NSSTRINGENCODING.values()) {
            if (!displayString.equals(entry.getDisplayString())) continue;
            return displayString;
        }
        return NSSTRINGENCODING.NSUTF8StringEncoding.getDefaultEncoding();
    }

    protected String getNewFileLabel() {
        return Messages.getString("WOComponentCreationPage.newComponent.label");
    }

    public IResource[] getResourcesToReveal() {
        return this._resourcesToReveal;
    }

    public void setResourcesToReveal(IResource[] resources) {
        this._resourcesToReveal = resources;
    }

    protected String packageNameForComponent(String componentName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getContainerFullPath().segment(0));
        try {
            IType javaType;
            LocalizedComponentsLocateResult result = LocatePlugin.getDefault().getLocalizedComponentsLocateResult(project, componentName);
            if (result != null && (javaType = result.getDotJavaType()) != null) {
                return javaType.getPackageFragment().getElementName();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (LocateException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected String packageNameForComponentFolder(IFolder folder) {
        try {
            for (IResource resource : folder.members()) {
                if (!"wo".equals(resource.getLocation().getFileExtension())) continue;
                return this.packageNameForComponent(resource.getLocation().removeFileExtension().lastSegment());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected IPath componentPathForPackage(IPackageFragment _selection) {
        try {
            LocatePlugin locate = LocatePlugin.getDefault();
            for (IJavaElement element : _selection.getChildren()) {
                String componentName = locate.fileNameWithoutExtension(element.getElementName());
                LocalizedComponentsLocateResult result = locate.getLocalizedComponentsLocateResult(_selection.getJavaProject().getProject(), componentName);
                IFolder[] components = result.getComponents();
                if (components.length <= 0) continue;
                IContainer selectionPath = components[0].getParent();
                return selectionPath.getFullPath();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (LocateException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected IPackageFragment choosePackage() {
        LinkedList<IJavaElement> packagesList = new LinkedList<IJavaElement>();
        try {
            IProject actualProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getContainerFullPath().segment(0));
            IJavaProject javaProject = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject((IResource)actualProject);
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            for (int k = 0; k < roots.length; ++k) {
                if (roots[k].getKind() != 1) continue;
                IJavaElement[] children = roots[k].getChildren();
                for (int i = 0; i < children.length; ++i) {
                    packagesList.add(children[i]);
                }
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        Object[] packages = packagesList.toArray(new IJavaElement[packagesList.size()]);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setIgnoreCase(false);
        dialog.setTitle(NewWizardMessages.NewTypeWizardPage_ChoosePackageDialog_title);
        dialog.setMessage(NewWizardMessages.NewTypeWizardPage_ChoosePackageDialog_description);
        dialog.setEmptyListMessage(NewWizardMessages.NewTypeWizardPage_ChoosePackageDialog_empty);
        dialog.setFilter(this._packageDialogField.getText());
        dialog.setElements(packages);
        if (dialog.open() == 0) {
            return (IPackageFragment)dialog.getFirstResult();
        }
        return null;
    }

    protected String chooseSuperclass() {
        HashSet<String> superclasses = new HashSet<String>();
        try {
            IProject actualProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getContainerFullPath().segment(0));
            IJavaProject javaProject = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject((IResource)actualProject);
            TypeNameCollector typeNameCollector = new TypeNameCollector(javaProject, false);
            BindingReflectionUtils.findMatchingElementClassNames((String)"", (int)1, (TypeNameCollector)typeNameCollector, (IProgressMonitor)new NullProgressMonitor());
            for (String typeName : typeNameCollector.getTypeNames()) {
                superclasses.add(typeName);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new StringLabelProvider());
        dialog.setIgnoreCase(true);
        dialog.setTitle(NewWizardMessages.NewTypeWizardPage_SuperClassDialog_title);
        dialog.setMessage(NewWizardMessages.NewTypeWizardPage_SuperClassDialog_message);
        dialog.setFilter(this._superclassDialogField.getText());
        dialog.setElements(superclasses.toArray());
        if (dialog.open() == 0) {
            return (String)dialog.getFirstResult();
        }
        return null;
    }

    protected void refreshButtonSettings(Button button) {
        if (button.equals(this._bodyCheckbox)) {
            if (this._bodyCheckbox.getSelection()) {
                this._htmlCombo.setEnabled(true);
            } else {
                this._htmlCombo.setEnabled(false);
            }
        }
        if (button.equals(this._apiCheckbox)) {
            // empty if block
        }
    }

    protected void handleSelectionEvent(SelectionEvent event) {
        Widget w = event.widget;
        if (w instanceof Button) {
            this.refreshButtonSettings((Button)w);
        }
    }

    public StringButtonStatusDialogField getPackageDialogField() {
        return this._packageDialogField;
    }

    public StringButtonStatusDialogField getSuperclassDialogField() {
        return this._superclassDialogField;
    }

    protected class ButtonSelectionAdaptor
    implements SelectionListener {
        protected ButtonSelectionAdaptor() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            WOComponentCreationPage.this.handleSelectionEvent(event);
        }

        public void widgetSelected(SelectionEvent event) {
            WOComponentCreationPage.this.handleSelectionEvent(event);
        }
    }

    protected class SuperclassButtonAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        protected SuperclassButtonAdapter() {
        }

        public void changeControlPressed(DialogField _field) {
            String superclass = WOComponentCreationPage.this.chooseSuperclass();
            if (superclass != null) {
                WOComponentCreationPage.this.getSuperclassDialogField().setText(superclass);
            }
        }

        public void dialogFieldChanged(DialogField _field) {
        }
    }

    protected class PackageButtonAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        protected PackageButtonAdapter() {
        }

        public void changeControlPressed(DialogField _field) {
            IPackageFragment pack = WOComponentCreationPage.this.choosePackage();
            if (pack != null) {
                WOComponentCreationPage.this.getPackageDialogField().setText(pack.getElementName());
            }
        }

        public void dialogFieldChanged(DialogField _field) {
        }
    }

    static enum NSSTRINGENCODING {
        NSUTF8StringEncoding("NSUTF8StringEncoding"),
        NSMacOSRomanStringEncoding("NSMacOSRomanStringEncoding"),
        NSASCIIStringEncoding("NSASCIIStringEncoding"),
        NSNEXTSTEPStringEncoding("NSNEXTSTEPStringEncoding"),
        NSJapaneseEUCStringEncoding("NSJapaneseEUCStringEncoding"),
        NSISOLatin1StringEncoding("NSISOLatin1StringEncoding"),
        NSSymbolStringEncoding("NSSymbolStringEncoding"),
        NSNonLossyASCIIStringEncoding("NSNonLossyASCIIStringEncoding"),
        NSShiftJISStringEncoding("NSShiftJISStringEncoding"),
        NSISOLatin2StringEncoding("NSISOLatin2StringEncoding"),
        NSUnicodeStringEncoding("NSUnicodeStringEncoding"),
        NSWindowsCP1251StringEncoding("NSWindowsCP1251StringEncoding"),
        NSWindowsCP1252StringEncoding("NSWindowsCP1252StringEncoding"),
        NSWindowsCP1253StringEncoding("NSWindowsCP1253StringEncoding"),
        NSWindowsCP1254StringEncoding("NSWindowsCP1254StringEncoding"),
        NSWindowsCP1250StringEncoding("NSWindowsCP1250StringEncoding"),
        NSISO2022JPStringEncoding("NSISO2022JPStringEncoding"),
        NSProprietaryStringEncoding("NSProprietaryStringEncoding");

        private final String _encoding;

        private NSSTRINGENCODING(String encoding) {
            this._encoding = encoding;
        }

        String getDisplayString() {
            return this._encoding;
        }

        String getDefaultEncoding() {
            return NSUTF8StringEncoding.getDisplayString();
        }
    }

    static enum HTML {
        STRICT_401("HTML 4.0.1 Strict", "4.0.1 strict doctype", 0),
        TRANSITIONAL_401("HTML 4.0.1 Transitional", "4.0.1 transitional doctype", 1),
        STRICT_XHTML10("XHTML 1.0 Strict", "XHTML 1.0 strict doctype", 2),
        TRANSITIONAL_XHTML10("XHTML 1.0 Transitional", "XHTML 1.0 transitional doctype", 3),
        FRAMESET_XHTML10("XHTML 1.0 Frameset", "XHTML 1.0 frameset doctype", 4),
        XHTML11("XHTML 1.1", "XHTML 1.1 doctype", 5),
        LAZY_OLD("Lazy Old HTML", "Lazy Old HTML", 6);

        private final String _displayString;
        private final String _html;
        private final int _templateIndex;

        private HTML(String display, String html, int templateIndex) {
            this._displayString = display;
            this._html = html;
            this._templateIndex = templateIndex;
        }

        String getDisplayString() {
            return this._displayString;
        }

        String getHTML() {
            return this._html;
        }

        int getTemplateIndex() {
            return this._templateIndex;
        }

        String getDefaultDocType() {
            return TRANSITIONAL_XHTML10.getDisplayString();
        }
    }
}

