/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards.template;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.objectstyle.wolips.templateengine.ProjectInput;
import org.objectstyle.wolips.templateengine.ProjectTemplate;

public class TemplateInputsWizardPage
extends WizardPage
implements SelectionListener,
ModifyListener {
    private List<ProjectInput> _inputs;
    private Map<ProjectInput, Label> _questionLabels;
    private Map<ProjectInput, Control> _questionControls;
    private ProjectTemplate _projectTemplate;
    private boolean _projectTemplateChanged;

    public TemplateInputsWizardPage() {
        super("Template Variables");
        this.setTitle("Template Variables");
        this._questionLabels = new HashMap<ProjectInput, Label>();
        this._questionControls = new HashMap<ProjectInput, Control>();
    }

    public void setProjectTemplate(ProjectTemplate projectTemplate) {
        if (this._projectTemplate != projectTemplate) {
            this._projectTemplateChanged = true;
            this._projectTemplate = projectTemplate;
            if (this._projectTemplate != null) {
                this.setTitle(this._projectTemplate.getName());
                this.setMessage("This template has the following configuration options.");
            }
        }
    }

    public ProjectTemplate getProjectTemplate() {
        return this._projectTemplate;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.initializeDialogUnits((Control)parent);
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        Composite composite = (Composite)this.getControl();
        if (visible && this._projectTemplateChanged) {
            this.createTemplateInputFields(composite);
        }
        composite.layout(true, true);
    }

    protected void createTemplateInputFields(Composite parent) {
        Control control;
        Label label;
        if (this._inputs != null) {
            for (ProjectInput input : this._inputs) {
                label = this._questionLabels.get(input);
                control = this._questionControls.get(input);
                if (label != null) {
                    label.dispose();
                }
                if (control == null) continue;
                control.dispose();
            }
            this._questionLabels.clear();
            this._questionControls.clear();
        }
        this._inputs = this._projectTemplate != null ? this._projectTemplate.getInputs() : null;
        this._projectTemplateChanged = false;
        if (this._inputs != null) {
            for (ProjectInput input : this._inputs) {
                input.setValue(null);
                label = new Label(parent, 0);
                label.setText(input.getQuestion());
                this._questionLabels.put(input, label);
                control = this.createControlForInput(input, parent);
                this._questionControls.put(input, control);
            }
        }
    }

    protected Control createControlForInput(ProjectInput input, Composite parent) {
        Text control;
        Object value = input.getValue();
        ProjectInput.Type type = input.getType();
        if (input.hasOptions()) {
            Combo combo = new Combo(parent, 8);
            for (ProjectInput.Option option : input.getOptions()) {
                combo.add(option.getName());
            }
            ProjectInput.Option selectedOption = input.getSelectedOption();
            if (selectedOption != null) {
                combo.select(input.getOptions().indexOf(selectedOption));
            }
            combo.addModifyListener((ModifyListener)this);
            control = combo;
        } else if (type == ProjectInput.Type.String) {
            control = new Text(parent, 2052);
            control.setLayoutData((Object)new GridData(768));
            control.setText((String)value);
            control.addModifyListener((ModifyListener)this);
        } else if (type == ProjectInput.Type.Package) {
            control = new Text(parent, 2052);
            control.setLayoutData((Object)new GridData(768));
            control.setText((String)value);
            control.addModifyListener((ModifyListener)this);
        } else if (type == ProjectInput.Type.Integer) {
            control = new Spinner(parent, 0);
            if (value != null) {
                ((Spinner)control).setSelection(((Integer)value).intValue());
                control.setLayoutData((Object)new GridData());
            }
            ((Spinner)control).addModifyListener((ModifyListener)this);
        } else if (type == ProjectInput.Type.Boolean) {
            control = new Button(parent, 32);
            if (value != null) {
                ((Button)control).setSelection(((Boolean)value).booleanValue());
                control.setLayoutData((Object)new GridData());
            }
            ((Button)control).addSelectionListener((SelectionListener)this);
        } else {
            throw new IllegalArgumentException("Unknown type " + type + ".");
        }
        return control;
    }

    public void updateModel() {
        if (this._inputs != null) {
            for (ProjectInput input : this._inputs) {
                Control control = this._questionControls.get(input);
                if (input.hasOptions()) {
                    int selectedOptionIndex = ((Combo)control).getSelectionIndex();
                    ProjectInput.Option selectedOption = (ProjectInput.Option)input.getOptions().get(selectedOptionIndex);
                    input.setSelectedOption(selectedOption);
                    continue;
                }
                ProjectInput.Type type = input.getType();
                if (type == ProjectInput.Type.String) {
                    input.setValue((Object)((Text)control).getText());
                    continue;
                }
                if (type == ProjectInput.Type.Package) {
                    input.setValue((Object)((Text)control).getText());
                    continue;
                }
                if (type == ProjectInput.Type.Integer) {
                    input.setValue((Object)((Spinner)control).getSelection());
                    continue;
                }
                if (type == ProjectInput.Type.Boolean) {
                    input.setValue((Object)((Button)control).getSelection());
                    continue;
                }
                throw new IllegalArgumentException("Unknown type " + type + ".");
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateModel();
    }

    public void modifyText(ModifyEvent e) {
        this.updateModel();
    }
}

