/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.objectstyle.wolips.baseforuiplugins.utils.WorkbenchUtilities;
import org.objectstyle.wolips.workbenchutilities.actions.AbstractActionOnIResource;

public class OpenWOAction
extends AbstractActionOnIResource {
    private static final String woExtension = ".wo";
    private static final String wodExtension = ".wod";
    private static final String htmlExtension = ".html";

    public void run(IAction action) {
        OpenWOAction.openResourceIfPossible(this.getActionResource());
    }

    public static boolean openResourceIfPossible(IResource actionResource) {
        boolean opened = false;
        if (actionResource != null) {
            if (actionResource.getFileExtension() == null || !actionResource.getName().endsWith(woExtension)) {
                return false;
            }
            String fileName = actionResource.getName();
            fileName = fileName.substring(0, fileName.length() - woExtension.length());
            ArrayList list = new ArrayList();
            WorkbenchUtilities.findFilesInResourceByName(list, (IResource)actionResource, (String)(fileName + htmlExtension));
            if (list.size() > 0) {
                WorkbenchUtilities.open((IFile)((IFile)list.get(0)), (String)"org.objectstyle.wolips.componenteditor.ComponentEditor");
                opened = true;
            } else {
                WorkbenchUtilities.findFilesInResourceByName(list, (IResource)actionResource, (String)(fileName + wodExtension));
                if (list.size() > 0) {
                    WorkbenchUtilities.open(list);
                    opened = true;
                }
            }
        }
        return opened;
    }
}

