/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.variables;

import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.objectstyle.woenvironment.env.WOEnvironment;
import org.objectstyle.woenvironment.env.WOVariables;
import org.objectstyle.wolips.baseforplugins.AbstractBaseActivator;
import org.objectstyle.wolips.preferences.Preferences;
import org.objectstyle.wolips.variables.BuildProperties;
import org.objectstyle.wolips.variables.ProjectVariables;
import org.osgi.framework.BundleContext;

public class VariablesPlugin
extends AbstractBaseActivator {
    private static VariablesPlugin plugin;

    public VariablesPlugin() {
        plugin = this;
    }

    public static VariablesPlugin getDefault() {
        return plugin;
    }

    public ProjectVariables getGlobalVariables() {
        return new ProjectVariables(this.getWOVariables(null, null));
    }

    public ProjectVariables getGlobalVariables(String wolipsPropertiesFile) {
        return new ProjectVariables(this.getWOVariables(null, wolipsPropertiesFile));
    }

    public ProjectVariables getProjectVariables(IProject project) {
        return new ProjectVariables(this.getWOVariables(project, null));
    }

    public boolean hasProjectVariables(IProject project) {
        if (project == null || !project.isAccessible()) {
            return false;
        }
        WOVariables wovars = this.getWOVariables(project, null);
        String wolipsPrefs = Preferences.getString((String)"org.objectstyle.wolips.wolipsPropertiesFile");
        return !wolipsPrefs.equals(wovars.getWOLipsPropertiesFile().getPath());
    }

    private WOVariables getWOVariables(IProject project, String wolipsPropertiesFile) {
        Properties defaultProperties = new Properties();
        String defaultPropertiesFile = wolipsPropertiesFile;
        if (defaultPropertiesFile == null || defaultPropertiesFile.length() == 0) {
            defaultPropertiesFile = Preferences.getString((String)"org.objectstyle.wolips.wolipsPropertiesFile");
        }
        if (defaultPropertiesFile != null && defaultPropertiesFile.length() > 0) {
            defaultProperties.put("wolips.properties", defaultPropertiesFile);
        }
        if (project != null) {
            BuildProperties buildPropertiesAdapter = (BuildProperties)project.getAdapter(BuildProperties.class);
            Properties buildProperties = null;
            if (buildPropertiesAdapter != null) {
                buildProperties = buildPropertiesAdapter.getProperties();
            }
            if (buildProperties != null) {
                defaultProperties.putAll((Map<?, ?>)buildProperties);
            }
        }
        WOVariables variables = new WOEnvironment((Map)defaultProperties).getWOVariables();
        return variables;
    }

    public static String getPluginId() {
        if (plugin != null) {
            Dictionary dictionary = plugin.getBundle().getHeaders();
            String pluginID = (String)dictionary.get("Bundle-Name");
            return pluginID;
        }
        return null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }
}

