/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.debug.logicalstructure;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JavaLogicalStructure;
import org.eclipse.jdt.internal.debug.core.model.JDIClassType;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.objectstyle.wolips.debug.Activator;

public abstract class LogicalStructure {
    public boolean isSuperclassOfValue(String superclass, IValue value) {
        if (value == null || !(value instanceof JDIObjectValue)) {
            return false;
        }
        JDIObjectValue jdiObjectValue = (JDIObjectValue)value;
        try {
            IJavaType javaType = jdiObjectValue.getJavaType();
            if (!(javaType instanceof JDIClassType)) {
                return false;
            }
            JDIClassType jdiClassType = (JDIClassType)javaType;
            if (jdiClassType.getName().equals(superclass)) {
                return true;
            }
            for (IJavaClassType javaClassType = jdiClassType.getSuperclass(); javaClassType != null; javaClassType = javaClassType.getSuperclass()) {
                if (!javaClassType.getName().equals(superclass)) continue;
                return true;
            }
        }
        catch (DebugException e) {
            Activator.getDefault().log(e);
        }
        return false;
    }

    public IJavaClassType getIJavaClassType(IValue value) throws DebugException {
        if (!(value instanceof IJavaObject)) {
            return null;
        }
        IJavaObject javaValue = (IJavaObject)value;
        IJavaType type = javaValue.getJavaType();
        if (!(type instanceof IJavaClassType)) {
            return null;
        }
        IJavaClassType classType = (IJavaClassType)type;
        return classType;
    }

    public String resolve(String method, IValue value) {
        String resolvedString = null;
        try {
            IJavaClassType classType = this.getIJavaClassType(value);
            JavaLogicalStructure countJavaLogicalStructure = new JavaLogicalStructure(classType.getName(), true, method, "bla", new String[0][0]);
            IValue resolvedValue = countJavaLogicalStructure.getLogicalStructure(value);
            resolvedString = resolvedValue.getValueString();
        }
        catch (DebugException e) {
            Activator.getDefault().log(e);
        }
        catch (CoreException e) {
            Activator.getDefault().log(e);
        }
        return resolvedString;
    }

    public String[] concat(String[] strings, String[] moreStrings) {
        String[] returnValue = new String[strings.length + moreStrings.length];
        System.arraycopy(strings, 0, returnValue, 0, strings.length);
        System.arraycopy(moreStrings, 0, returnValue, strings.length, moreStrings.length);
        return returnValue;
    }
}

